/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.h5.sdk.plugin.migration.utils;

import com.vmware.h5.sdk.plugin.migration.ExtensionType;
import com.vmware.h5.sdk.plugin.migration.UnsupportedExtensionInfo;
import com.vmware.h5.sdk.plugin.migration.error.PluginManifestError;
import com.vmware.h5.sdk.plugin.migration.model.PluginBuilderConfig;
import com.vmware.h5.sdk.plugin.migration.utils.PluginMigrationUtils;
import com.vmware.h5.sdk.plugin.migration.utils.XmlUtils;
import com.vmware.vise.plugin.manifest.model.object.ObjectType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObjectTypeUtils {
    private static final Pattern OBJECT_TYPE_PATTERN = Pattern.compile("vsphere\\.core\\.(\\w+)\\.\\w*");

    public static List<ObjectType> getObjectTypes(Element element, String extendedPoint, Map<String, List<Element>> templateInstancesMap, PluginBuilderConfig pluginBuilderConfig) {
        String type2 = XmlUtils.getLastChildElementNodeValue(element, "metadata", "objectType");
        ArrayList<ObjectType> objectTypeList = new ArrayList<ObjectType>();
        String folderType = XmlUtils.getLastChildElementNodeValue(element, "metadata", "folderType");
        if (!PluginMigrationUtils.isStringEmpty(type2)) {
            String[] objectTypes;
            for (String objectTypeVal : objectTypes = type2.split(",")) {
                if (!PluginMigrationUtils.isStringEmpty(folderType)) {
                    String[] folderTypes;
                    for (String folder : folderTypes = folderType.split(",")) {
                        objectTypeList.addAll(ObjectTypeUtils.getApplicableObjectTypes(objectTypeVal, folder, element, templateInstancesMap, false, pluginBuilderConfig));
                    }
                    continue;
                }
                objectTypeList.addAll(ObjectTypeUtils.getApplicableObjectTypes(objectTypeVal, folderType, element, templateInstancesMap, false, pluginBuilderConfig));
            }
        } else if (extendedPoint.startsWith("vsphere.core.")) {
            objectTypeList.addAll(ObjectTypeUtils.getObjectTypeForExtension(extendedPoint, folderType, element, templateInstancesMap, pluginBuilderConfig));
        }
        if (objectTypeList.isEmpty() && (ExtensionType.ACTIONS.matches(extendedPoint) || ExtensionType.ACTIONS_SPECS.matches(extendedPoint))) {
            return Arrays.asList(ObjectType.values());
        }
        return objectTypeList;
    }

    public static List<ObjectType> getObjectTypeForExtension(String extendedPoint, String folderType, Element element, Map<String, List<Element>> templateInstancesMap, PluginBuilderConfig pluginBuilderConfig) {
        Matcher matcher = OBJECT_TYPE_PATTERN.matcher(extendedPoint);
        String type2 = "";
        if (matcher.find()) {
            type2 = matcher.group(1);
        }
        return ObjectTypeUtils.getApplicableObjectTypes(type2, folderType, element, templateInstancesMap, true, pluginBuilderConfig);
    }

    public static List<ObjectType> getApplicableObjectTypes(String type2, String folderType, Element element, Map<String, List<Element>> templateInstancesMap, boolean isExtensionName, PluginBuilderConfig pluginBuilderConfig) {
        ArrayList<ObjectType> matchedObjectTypes = new ArrayList<ObjectType>();
        for (ObjectType objectType : ObjectType.values()) {
            if (!ObjectTypeUtils.isObjectTypeMatched(type2, isExtensionName, objectType, element, templateInstancesMap, pluginBuilderConfig) || !PluginMigrationUtils.isStringEmpty(folderType) && !objectType.getMetadata().get("folderType").equals(folderType)) continue;
            matchedObjectTypes.add(objectType);
        }
        return matchedObjectTypes;
    }

    private static boolean isObjectTypeMatched(String type2, boolean isExtensionName, ObjectType objectType, Element element, Map<String, List<Element>> templateInstanceMap, PluginBuilderConfig pluginBuilderConfig) {
        boolean isVmTemplate;
        boolean isMatched = isExtensionName && ObjectTypeUtils.isExtensionNameMatched(objectType, type2) || ObjectTypeUtils.isVsphereNameMatched(objectType, type2);
        boolean isVm = objectType == ObjectType.VIRTUAL_MACHINE;
        boolean bl = isVmTemplate = objectType == ObjectType.VIRTUAL_MACHINE_TEMPLATE;
        if (isVm || isVmTemplate) {
            return isMatched && ObjectTypeUtils.matchWithPropertyConditions(element, templateInstanceMap, isVm, pluginBuilderConfig, type2);
        }
        ObjectTypeUtils.checkAndLogUnsupportedPropertyConditions(element, pluginBuilderConfig, type2);
        return isMatched;
    }

    private static boolean isVsphereNameMatched(ObjectType objectType, String type2) {
        return objectType.getVsphereObjectTypes().contains(type2);
    }

    private static boolean isExtensionNameMatched(ObjectType objectType, String type2) {
        return objectType == ObjectType.VIRTUAL_MACHINE_TEMPLATE && "vm".equals(type2) || objectType.getExtensionName().equals(type2);
    }

    private static boolean matchWithPropertyConditions(Element element, Map<String, List<Element>> templateInstancesMap, boolean isVm, PluginBuilderConfig pluginBuilderConfig, String type2) {
        String extendedPoint = XmlUtils.getChildElementNodeValue(element, "extendedPoint");
        if (extendedPoint.equals(ExtensionType.SOLUTION_MENUS.toString())) {
            boolean isVmTemplateConstraintMatched = ObjectTypeUtils.isVMTemplateConstraintMatched(element, templateInstancesMap, pluginBuilderConfig, type2);
            return isVm && !isVmTemplateConstraintMatched || !isVm && isVmTemplateConstraintMatched;
        }
        if (extendedPoint.equals(ExtensionType.ACTIONS.toString())) {
            return true;
        }
        return isVm;
    }

    private static void checkAndLogUnsupportedPropertyConditions(Element element, PluginBuilderConfig pluginBuilderConfig, String type2) {
        if (XmlUtils.getLastChildElementNode(element, "metadata", "propertyConditions") != null || XmlUtils.getLastChildElementNode(element, "metadata", "globalPrivileges") != null || XmlUtils.getLastChildElementNode(element, "object", "requiredPrivileges") != null) {
            UnsupportedExtensionInfo extInfo = new UnsupportedExtensionInfo(type2, PluginManifestError.CONSTRAINTS_UNSUPPORTED_ERR.getMessage(), PluginManifestError.CONSTRAINTS_UNSUPPORTED_ERR.getErrorCode());
            pluginBuilderConfig.getUnsupportedConditionsMap().put(extInfo, Collections.singletonList(element));
        }
    }

    private static boolean isVMTemplateConstraintMatched(Element element, Map<String, List<Element>> templateInstancesMap, PluginBuilderConfig pluginBuilderConfig, String type2) {
        Element propertyConditions;
        Element metadata = XmlUtils.getLastChildElementNode(element, "metadata");
        if (metadata != null && (propertyConditions = XmlUtils.getChildElement(metadata, "propertyConditions")) != null) {
            Element nestedConstraints = XmlUtils.getLastChildElementNode(propertyConditions, "com.vmware.data.query.CompositeConstraint", "nestedConstraints");
            List<Element> propertyConstraints = XmlUtils.getChildElements(nestedConstraints, "com.vmware.data.query.PropertyConstraint");
            for (int i = 0; i < propertyConstraints.size(); ++i) {
                String comparator;
                Element propertyConstraintEl = propertyConstraints.get(i);
                String propertyName = XmlUtils.getChildElementNodeValue(propertyConstraintEl, "propertyName");
                if (!"isNormalVMOrPrimaryFTVM".equals(propertyName) && !"config/template".equals(propertyName) && !"isNormalVM".equals(propertyName) || !"equals".equalsIgnoreCase(comparator = XmlUtils.getChildElementNodeValue(propertyConstraintEl, "comparator"))) continue;
                Boolean value = Boolean.valueOf(XmlUtils.getLastChildElementNodeValue(propertyConstraintEl, "comparableValue", "Boolean"));
                return "config/template".equals(propertyName) ? value : value == false;
            }
            UnsupportedExtensionInfo extInfo = new UnsupportedExtensionInfo(type2, PluginManifestError.CONSTRAINTS_UNSUPPORTED_ERR.getMessage(), PluginManifestError.CONSTRAINTS_UNSUPPORTED_ERR.getErrorCode());
            pluginBuilderConfig.getUnsupportedConditionsMap().put(extInfo, Collections.singletonList(element));
        }
        String extensionId = XmlUtils.getAttributeValue(element, "id");
        for (Map.Entry<String, List<Element>> entry : templateInstancesMap.entrySet()) {
            if (!extensionId.startsWith(entry.getKey())) continue;
            List<Element> templateInstances = entry.getValue();
            for (int i = 0; i < templateInstances.size(); ++i) {
                Node templatedNode = templateInstances.get(i);
                NodeList templateChildNodes = templatedNode.getChildNodes();
                boolean isNormalVMPropertyPresent = false;
                for (int j = 0; j < templateChildNodes.getLength(); ++j) {
                    Node templateChildNode = templateChildNodes.item(j);
                    if (!templateChildNode.getNodeName().equals("variable")) continue;
                    String name = XmlUtils.getAttributeValue((Element)templateChildNode, "name");
                    String value = XmlUtils.getAttributeValue((Element)templateChildNode, "value");
                    if ("propertyName".equals(name) && "isNormalVM".equals(value)) {
                        isNormalVMPropertyPresent = true;
                        continue;
                    }
                    if (!isNormalVMPropertyPresent || !"propertyValue".equals(name)) continue;
                    return Boolean.valueOf(value) == false;
                }
            }
        }
        return false;
    }
}

