/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.query;

import java.util.ArrayList;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertyConstraintValueAdapter
extends XmlAdapter<Object, Object> {
    private static final String TYPE_INTEGER = "Int";
    private static final String TYPE_LONG = "Long";
    private static final String TYPE_BOOLEAN = "Boolean";
    private static final String TYPE_ARRAY = "Array";

    public Object unmarshal(Object value) {
        if (!(value instanceof Node)) {
            return value;
        }
        Node valueNode = (Node)value;
        Node dataNode = valueNode.getFirstChild();
        if (dataNode == null) {
            return null;
        }
        String dataType = dataNode.getNodeName();
        Object nodeValue = TYPE_ARRAY.equalsIgnoreCase(dataType) ? this.parseArray(dataNode) : this.toPrimitiveValue(dataType, dataNode.getTextContent());
        return nodeValue;
    }

    private Object toPrimitiveValue(String type2, String value) {
        if (TYPE_BOOLEAN.equalsIgnoreCase(type2)) {
            return Boolean.parseBoolean(value);
        }
        if (TYPE_INTEGER.equalsIgnoreCase(type2)) {
            return Integer.parseInt(value);
        }
        if (TYPE_LONG.equalsIgnoreCase(type2)) {
            return Long.parseLong(value);
        }
        return value;
    }

    private Object[] parseArray(Node dataNode) {
        NodeList childrenNodes = dataNode.getChildNodes();
        ArrayList<Object> nodeValues = new ArrayList<Object>();
        for (int i = 0; i < childrenNodes.getLength(); ++i) {
            Node childNode = childrenNodes.item(i);
            if (1 != childNode.getNodeType()) continue;
            String dataType = childNode.getNodeName();
            Object nodeValue = this.toPrimitiveValue(dataType, childNode.getTextContent());
            nodeValues.add(nodeValue);
        }
        return nodeValues.toArray();
    }

    public Object marshal(Object value) throws Exception {
        return value;
    }
}

