/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.plugin.manifest.model.object;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;

public class FilteringConditions {
    private static final ObjectMapper mapper = new ObjectMapper();
    public PropertyConditionCnf propertyConditionCnf;
    @JsonProperty(value="privileges")
    public List<String> privileges;
    @JsonProperty(value="features")
    public List<String> features;

    @JsonProperty(value="booleanProperties")
    public void setBooleanProperties(Object booleanProperties) {
        List<String> resourceModels;
        List clauses;
        if (booleanProperties instanceof Map) {
            BooleanPropertiesObjectType properties = mapper.convertValue(booleanProperties, BooleanPropertiesObjectType.class);
            clauses = properties.condition;
            resourceModels = properties.resourceModels;
            Validate.notNull(clauses, "The clauses cannot be null.", new Object[0]);
            Validate.notNull(resourceModels, "The resource models cannot be null.", new Object[0]);
        } else if (booleanProperties instanceof List) {
            clauses = mapper.convertValue(booleanProperties, List.class);
            resourceModels = null;
        } else {
            throw new RuntimeException("Unknown type for property 'booleanProperties'.");
        }
        this.propertyConditionCnf = new PropertyConditionCnf(FilteringConditions.parseClauses(clauses), resourceModels);
    }

    private static List<List<String>> parseClauses(List<?> clauses) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (Object clause : clauses) {
            if (clause instanceof String) {
                result.add(Collections.singletonList((String)clause));
                continue;
            }
            if (clause instanceof List) {
                List literalList = ((List)clause).stream().map(obj -> (String)obj).collect(Collectors.toList());
                result.add(literalList);
                continue;
            }
            throw new RuntimeException("Unknown type of the literal.");
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteringConditions that = (FilteringConditions)o;
        return Objects.equals(this.propertyConditionCnf, that.propertyConditionCnf) && Objects.equals(this.privileges, that.privileges) && Objects.equals(this.features, that.features);
    }

    public int hashCode() {
        return Objects.hash(this.propertyConditionCnf, this.privileges, this.features);
    }

    private static class BooleanPropertiesObjectType {
        public List<?> condition;
        public List<String> resourceModels;

        private BooleanPropertiesObjectType() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BooleanPropertiesObjectType that = (BooleanPropertiesObjectType)o;
            return Objects.equals(this.condition, that.condition) && Objects.equals(this.resourceModels, that.resourceModels);
        }

        public int hashCode() {
            return Objects.hash(this.condition, this.resourceModels);
        }
    }

    public static class PropertyConditionCnf {
        public final List<List<String>> clauses;
        public final List<String> resourceModels;

        public PropertyConditionCnf(List<List<String>> clauses, List<String> resourceModels) {
            this.clauses = clauses.stream().map(Collections::unmodifiableList).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
            this.resourceModels = resourceModels != null ? Collections.unmodifiableList(resourceModels) : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyConditionCnf that = (PropertyConditionCnf)o;
            return Objects.equals(this.clauses, that.clauses) && Objects.equals(this.resourceModels, that.resourceModels);
        }

        public int hashCode() {
            return Objects.hash(this.clauses, this.resourceModels);
        }
    }
}

