/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.plugin.manifest.model.object.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vmware.vise.plugin.manifest.model.object.DynamicItemConfig;
import com.vmware.vise.plugin.manifest.model.object.view.BaseObjectView;
import com.vmware.vise.plugin.manifest.model.object.view.CategoryDefinition;
import com.vmware.vise.plugin.manifest.model.object.view.LegacyObjectView;
import com.vmware.vise.plugin.manifest.model.object.view.ObjectView;
import com.vmware.vise.plugin.manifest.model.object.view.SlotObjectView;
import java.util.stream.Stream;

public class Category {
    @JsonProperty(value="views")
    private BaseObjectView[] views;
    @JsonProperty(value="definitions")
    private Definitions definitions;
    @JsonProperty(value="forceExpand")
    private boolean forceExpand;
    @JsonIgnore
    private String defaultCategoryLabelKey;
    @JsonIgnore
    private boolean dynamic;
    @JsonIgnore
    private DynamicItemConfig dynamicItemConfig;

    @JsonProperty(value="dynamicUri")
    public void setDynamicUri(Object dynamicUri) {
        this.setDynamicItemConfig(DynamicItemConfig.parse(dynamicUri));
    }

    public final BaseObjectView[] getViews() {
        return this.views;
    }

    public final void setViews(BaseObjectView[] views) {
        if (views != null) {
            for (int i = 0; i < views.length; ++i) {
                views[i].localId = String.valueOf(i);
            }
        }
        this.views = views;
    }

    @JsonIgnore
    public final ObjectView[] getStandardViews() {
        if (this.views == null) {
            return null;
        }
        return (ObjectView[])Stream.of(this.views).filter(baseObjectView -> baseObjectView instanceof ObjectView).map(baseObjectView -> (ObjectView)baseObjectView).toArray(ObjectView[]::new);
    }

    @JsonIgnore
    public final LegacyObjectView[] getLegacyViews() {
        if (this.views == null) {
            return null;
        }
        return (LegacyObjectView[])Stream.of(this.views).filter(baseObjectView -> baseObjectView instanceof LegacyObjectView).map(baseObjectView -> (LegacyObjectView)baseObjectView).toArray(LegacyObjectView[]::new);
    }

    @JsonIgnore
    public final SlotObjectView[] getSlotViews() {
        if (this.views == null) {
            return null;
        }
        return (SlotObjectView[])Stream.of(this.views).filter(baseObjectView -> baseObjectView instanceof SlotObjectView).map(baseObjectView -> (SlotObjectView)baseObjectView).toArray(SlotObjectView[]::new);
    }

    public final Definitions getDefinitions() {
        return this.definitions;
    }

    public final void setDefinitions(Definitions definitions) {
        this.definitions = definitions;
    }

    public final CategoryDefinition getCategoryDefinition(String categoryId) {
        CategoryDefinition[] categoryDefinitions;
        CategoryDefinition[] categoryDefinitionArray = categoryDefinitions = this.definitions == null ? null : this.definitions.getCategoryDefinitions();
        if (categoryId != null && categoryDefinitions != null) {
            for (CategoryDefinition categoryDefinition : categoryDefinitions) {
                if (!categoryDefinition.id.equals(categoryId)) continue;
                return categoryDefinition;
            }
        }
        return null;
    }

    public final String getDefaultCategoryLabelKey() {
        return this.defaultCategoryLabelKey;
    }

    public final void setDefaultCategoryLabelKey(String defaultLabelKey) {
        this.defaultCategoryLabelKey = defaultLabelKey;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isForceExpand() {
        return this.forceExpand;
    }

    public void setForceExpand(boolean forceExpand) {
        this.forceExpand = forceExpand;
    }

    public DynamicItemConfig getDynamicItemConfig() {
        return this.dynamicItemConfig;
    }

    public void setDynamicItemConfig(DynamicItemConfig dynamicItemConfig) {
        this.dynamicItemConfig = dynamicItemConfig;
    }

    public static class Definitions {
        @JsonProperty(value="categories")
        private CategoryDefinition[] categoryDefinitions;

        public final CategoryDefinition[] getCategoryDefinitions() {
            return this.categoryDefinitions;
        }

        public final void setCategoryDefinitions(CategoryDefinition[] categoryDefinitions) {
            this.categoryDefinitions = categoryDefinitions;
        }
    }
}

