/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.ImageArea;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.SpanArea;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.InlineArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.LeaderArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.render.Renderer;
import org.apache.fop.svg.SVGArea;

public abstract class AbstractRenderer
implements Renderer {
    protected Logger log;
    protected int currentYPosition = 0;
    protected int currentXPosition = 0;
    protected int currentAreaContainerXPosition = 0;
    protected IDReferences idReferences;

    protected abstract void addFilledRect(int var1, int var2, int var3, int var4, ColorType var5);

    /*
     * Unable to fully structure code
     */
    protected void doBackground(Area area, int x, int y, int w, int h) {
        block19: {
            if (h == 0 || w == 0) {
                return;
            }
            props = area.getBackground();
            if (props == null) {
                return;
            }
            if (props.backColor.alpha() == 0.0f) {
                this.addFilledRect(x, y, w, -h, props.backColor);
            }
            if (props.backImage == null) break block19;
            try {
                imgW = props.backImage.getWidth() * 1000;
                imgH = props.backImage.getHeight() * 1000;
            }
            catch (FopImageException fie) {
                this.log.error("Error obtaining bg image width and height", fie);
                return;
            }
            dx = x;
            dy = y;
            endX = x + w;
            endY = y - h;
            clipW = w % imgW;
            clipH = h % imgH;
            repeatX = true;
            repeatY = true;
            switch (props.backRepeat) {
                case 90: {
                    repeatY = false;
                    break;
                }
                case 91: {
                    repeatX = false;
                    break;
                }
                case 71: {
                    repeatX = false;
                    repeatY = false;
                    break;
                }
                default: {
                    this.log.error("Ignoring invalid background-repeat property");
                }
                case 51: 
                case 89: 
            }
            fs = area.getFontState();
            ** GOTO lbl57
            {
                if (dx + imgW <= endX) {
                    if (dy - imgH >= endY) {
                        this.drawImageScaled(dx, dy, imgW, imgH, props.backImage, fs);
                    } else {
                        this.drawImageClipped(dx, dy, 0, 0, imgW, clipH, props.backImage, fs);
                    }
                } else if (dy - imgH >= endY) {
                    this.drawImageClipped(dx, dy, 0, 0, clipW, imgH, props.backImage, fs);
                } else {
                    this.drawImageClipped(dx, dy, 0, 0, clipW, clipH, props.backImage, fs);
                }
                if (!repeatX) ** GOTO lbl54
                dx += imgW;
                do {
                    if (dx < endX) continue block8;
lbl54:
                    // 2 sources

                    dx = x;
                    if (!repeatY) break block8;
                    dy -= imgH;
lbl57:
                    // 2 sources

                } while (dy > endY);
            }
        }
    }

    protected abstract void doFrame(Area var1);

    protected void drawImage(int x, int y, FopImage image, FontState fs) {
        int h;
        int w;
        try {
            w = image.getWidth() * 1000;
            h = image.getHeight() * 1000;
        }
        catch (FopImageException e) {
            this.log.error("Failed to obtain the image width and height", e);
            return;
        }
        this.drawImageScaled(x, y, w, h, image, fs);
    }

    protected abstract void drawImageClipped(int var1, int var2, int var3, int var4, int var5, int var6, FopImage var7, FontState var8);

    protected abstract void drawImageScaled(int var1, int var2, int var3, int var4, FopImage var5, FontState var6);

    public IDReferences getIDReferences() {
        return this.idReferences;
    }

    public abstract void render(Page var1, OutputStream var2) throws IOException, FOPException;

    public void renderAreaContainer(AreaContainer area) {
        int saveY = this.currentYPosition;
        int saveX = this.currentAreaContainerXPosition;
        if (area.getPosition() == 1) {
            this.currentYPosition = area.getYPosition();
            this.currentAreaContainerXPosition = area.getXPosition();
        } else if (area.getPosition() == 88) {
            this.currentYPosition -= area.getYPosition();
            this.currentAreaContainerXPosition += area.getXPosition();
        } else if (area.getPosition() == 107) {
            this.currentYPosition -= area.getPaddingTop() + area.getBorderTopWidth();
        }
        this.currentXPosition = this.currentAreaContainerXPosition;
        this.doFrame(area);
        ArrayList children = area.getChildren();
        int i = 0;
        while (i < children.size()) {
            Box b = (Box)children.get(i);
            b.render(this);
            ++i;
        }
        this.currentYPosition = saveY;
        this.currentAreaContainerXPosition = saveX;
        if (area.getPosition() == 107) {
            this.currentYPosition -= area.getHeight();
        }
    }

    public void renderBlockArea(BlockArea area) {
        this.currentYPosition -= area.getPaddingTop() + area.getBorderTopWidth();
        this.doFrame(area);
        ArrayList children = area.getChildren();
        int i = 0;
        while (i < children.size()) {
            Box b = (Box)children.get(i);
            b.render(this);
            ++i;
        }
        this.currentYPosition -= area.getPaddingBottom() + area.getBorderBottomWidth();
    }

    public void renderBodyAreaContainer(BodyAreaContainer area) {
        int saveY = this.currentYPosition;
        int saveX = this.currentAreaContainerXPosition;
        if (area.getPosition() == 1) {
            this.currentYPosition = area.getYPosition();
            this.currentAreaContainerXPosition = area.getXPosition();
        } else if (area.getPosition() == 88) {
            this.currentYPosition -= area.getYPosition();
            this.currentAreaContainerXPosition += area.getXPosition();
        }
        this.currentXPosition = this.currentAreaContainerXPosition;
        int rx = this.currentAreaContainerXPosition;
        int ry = this.currentYPosition;
        int w = area.getAllocationWidth();
        int h = area.getMaxHeight();
        this.doBackground(area, rx, ry, w, h);
        this.renderAreaContainer(area.getBeforeFloatReferenceArea());
        this.renderAreaContainer(area.getFootnoteReferenceArea());
        ArrayList children = area.getMainReferenceArea().getChildren();
        int i = 0;
        while (i < children.size()) {
            Box b = (Box)children.get(i);
            b.render(this);
            ++i;
        }
        if (area.getPosition() != 107) {
            this.currentYPosition = saveY;
            this.currentAreaContainerXPosition = saveX;
        } else {
            this.currentYPosition -= area.getHeight();
        }
    }

    public abstract void renderDisplaySpace(DisplaySpace var1);

    public abstract void renderForeignObjectArea(ForeignObjectArea var1);

    public void renderImageArea(ImageArea area) {
        int x = this.currentXPosition + area.getXOffset();
        int y = this.currentYPosition;
        int w = area.getContentWidth();
        int h = area.getHeight();
        this.currentYPosition -= h;
        FopImage img = area.getImage();
        if (img == null) {
            this.log.error("Error while loading image: area.getImage() is null");
        } else {
            this.drawImageScaled(x, y, w, h, img, area.getFontState());
        }
        this.currentXPosition += w;
    }

    public abstract void renderInlineSpace(InlineSpace var1);

    public abstract void renderLeaderArea(LeaderArea var1);

    public void renderLineArea(LineArea area) {
        int rx = this.currentAreaContainerXPosition + area.getStartIndent();
        int ry = this.currentYPosition;
        int w = area.getContentWidth();
        int h = area.getHeight();
        this.currentYPosition -= area.getPlacementOffset();
        this.currentXPosition = rx;
        int bl = this.currentYPosition;
        ArrayList children = area.getChildren();
        int i = 0;
        while (i < children.size()) {
            Box b = (Box)children.get(i);
            if (b instanceof InlineArea) {
                InlineArea ia = (InlineArea)b;
                this.currentYPosition = ry - ia.getYOffset();
            } else {
                this.currentYPosition = ry - area.getPlacementOffset();
            }
            b.render(this);
            ++i;
        }
        this.currentYPosition = ry - h;
        this.currentXPosition = rx;
    }

    public abstract void renderPage(Page var1);

    public void renderRegionAreaContainer(AreaContainer area) {
        int saveY = this.currentYPosition;
        int saveX = this.currentAreaContainerXPosition;
        if (area.getPosition() == 1) {
            this.currentYPosition = area.getYPosition();
            this.currentAreaContainerXPosition = area.getXPosition();
        } else if (area.getPosition() == 88) {
            this.currentYPosition -= area.getYPosition();
            this.currentAreaContainerXPosition += area.getXPosition();
        }
        this.currentXPosition = this.currentAreaContainerXPosition;
        int rx = this.currentAreaContainerXPosition;
        int ry = this.currentYPosition;
        int w = area.getAllocationWidth();
        int h = area.getMaxHeight();
        this.doBackground(area, rx, ry, w, h);
        ArrayList children = area.getChildren();
        int i = 0;
        while (i < children.size()) {
            Box b = (Box)children.get(i);
            b.render(this);
            ++i;
        }
        if (area.getPosition() != 107) {
            this.currentYPosition = saveY;
            this.currentAreaContainerXPosition = saveX;
        } else {
            this.currentYPosition -= area.getHeight();
        }
    }

    public void renderRegions(Page page) {
        page.getBody().render(this);
        if (page.getBefore() != null) {
            page.getBefore().render(this);
        }
        if (page.getAfter() != null) {
            page.getAfter().render(this);
        }
        if (page.getStart() != null) {
            page.getStart().render(this);
        }
        if (page.getEnd() != null) {
            page.getEnd().render(this);
        }
    }

    public abstract void renderSVGArea(SVGArea var1);

    public void renderSpanArea(SpanArea area) {
        ArrayList children = area.getChildren();
        int i = 0;
        while (i < children.size()) {
            Box b = (Box)children.get(i);
            b.render(this);
            ++i;
        }
    }

    public abstract void renderWordArea(WordArea var1);

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    public abstract void setOptions(Map var1);

    public abstract void setProducer(String var1);

    public abstract void setupFontInfo(FontInfo var1) throws FOPException;

    public abstract void startRenderer(OutputStream var1) throws IOException;

    public abstract void stopRenderer(OutputStream var1) throws IOException;
}

