/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.hardware.ciminfo.model;

import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.HealthStatus;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.Sensor;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.SensorStatus;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.reader.CimMessageReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SensorGroup
extends Sensor {
    private int alertCount;
    private int warningCount;

    @Override
    public List<SensorStatus> getStatus() {
        String statusMessage;
        ArrayList<SensorStatus> statuses = new ArrayList<SensorStatus>();
        if (this.alertCount == 0 && this.warningCount == 0) {
            statuses.add(this.getSensorStatus(this.healthStatus));
            return statuses;
        }
        if (this.alertCount > 0) {
            String alertStatus = this.getSensorStatus((HealthStatus)HealthStatus.HEALTH_STATUS_ALERT).status;
            statusMessage = this.getAlertsMessage(this.alertCount);
            SensorStatus alertStatusGroup = new SensorStatus(alertStatus, statusMessage);
            statuses.add(alertStatusGroup);
        }
        if (this.warningCount > 0) {
            String warningStatus = this.getSensorStatus((HealthStatus)HealthStatus.HEALTH_STATUS_WARNING).status;
            statusMessage = this.getWarningsMessage(this.warningCount);
            SensorStatus warningStatusGroup = new SensorStatus(warningStatus, statusMessage);
            statuses.add(warningStatusGroup);
        }
        return statuses;
    }

    private SensorStatus getSensorStatus(HealthStatus healthStatus) {
        String statusKey = healthStatus.getStatusKey();
        return new SensorStatus(statusKey, this.getStatusMessage(statusKey));
    }

    private String getStatusMessage(String statusKey) {
        return StringUtils.isEmpty((CharSequence)statusKey) ? "" : CimMessageReader.getMessage(statusKey);
    }

    public void updateStatus(Sensor sensor) {
        if (sensor.hasWarning()) {
            ++this.warningCount;
        } else if (sensor.hasAlert()) {
            ++this.alertCount;
        }
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getAlertCount() {
        return this.alertCount;
    }

    private String getWarningsMessage(int count) {
        if (count == 1) {
            return CimMessageReader.getMessage("oneWarning");
        }
        return CimMessageReader.getMessage("nWarnings", String.valueOf(count));
    }

    private String getAlertsMessage(int count) {
        if (count == 1) {
            return CimMessageReader.getMessage("oneAlert");
        }
        return CimMessageReader.getMessage("nAlerts", String.valueOf(count));
    }
}

