/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.imports;

import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vise.core.model.annotation.Dto;
import com.vmware.vsphere.client.h5.network.NumericRangeUtil;
import com.vmware.vsphere.client.modules.api.util.ModulesApiUtil;

@Dto
public class DvpgRestoreVlanPolicyModel {
    public static final String VLAN_NONE = "none";
    public static final String VLAN_VLAN = "vlan";
    public static final String VLAN_TRUNK = "trunk";
    public static final String VLAN_PRIVATE = "private";
    public VmwareDistributedVirtualSwitch.VlanSpec policy;
    public VmwareDistributedVirtualSwitch.PvlanMapEntry privateVlanEntry = null;
    public int vlanId;
    private String vlanType;
    public String vlanIdRanges;
    public VmwareDistributedVirtualSwitch.PvlanMapEntry[] privateVlanEntries = new VmwareDistributedVirtualSwitch.PvlanMapEntry[0];

    public void setPolicy(VmwareDistributedVirtualSwitch.VlanSpec value, VmwareDistributedVirtualSwitch.PvlanMapEntry[] pvlanMapEntries) {
        if (value == null) {
            this.policy = null;
            this.vlanType = VLAN_NONE;
            return;
        }
        if (value != this.policy) {
            this.policy = value;
            if (this.vlanType == null) {
                this.vlanType = this.vlanTypeFromPolicy(pvlanMapEntries);
            }
        }
    }

    private String vlanTypeFromPolicy(VmwareDistributedVirtualSwitch.PvlanMapEntry[] pvlanMapEntries) {
        if (this.policy instanceof VmwareDistributedVirtualSwitch.VlanIdSpec) {
            this.vlanId = ((VmwareDistributedVirtualSwitch.VlanIdSpec)this.policy).vlanId;
            if (this.vlanId == 0) {
                return VLAN_NONE;
            }
            return VLAN_VLAN;
        }
        if (this.policy instanceof VmwareDistributedVirtualSwitch.TrunkVlanSpec) {
            return VLAN_TRUNK;
        }
        if (this.policy instanceof VmwareDistributedVirtualSwitch.PvlanSpec) {
            if (pvlanMapEntries != null && pvlanMapEntries.length > 0) {
                this.privateVlanEntries = pvlanMapEntries;
            }
            return VLAN_PRIVATE;
        }
        return null;
    }

    public String getVlanId() {
        if (this.vlanType.equals(VLAN_NONE)) {
            return ModulesApiUtil.getString("dvpg.restore.vlanId.none");
        }
        if (this.policy instanceof VmwareDistributedVirtualSwitch.VlanIdSpec) {
            return Integer.toString(((VmwareDistributedVirtualSwitch.VlanIdSpec)this.policy).getVlanId());
        }
        return ModulesApiUtil.getString("dvpg.restore.vlanId.none");
    }

    public String getVlanIdRanges() {
        if (VLAN_TRUNK.equals(this.vlanType)) {
            if (this.vlanIdRanges == null) {
                VmwareDistributedVirtualSwitch.TrunkVlanSpec p = (VmwareDistributedVirtualSwitch.TrunkVlanSpec)this.policy;
                this.vlanIdRanges = NumericRangeUtil.asString(p.vlanId);
            }
            return this.vlanIdRanges;
        }
        return null;
    }

    public VmwareDistributedVirtualSwitch.PvlanMapEntry getPrivateVlanEntry() {
        if (!VLAN_PRIVATE.equals(this.vlanType)) {
            return null;
        }
        if (this.privateVlanEntry == null) {
            for (VmwareDistributedVirtualSwitch.PvlanMapEntry entry : this.privateVlanEntries) {
                if (entry.secondaryVlanId != ((VmwareDistributedVirtualSwitch.PvlanSpec)this.policy).pvlanId) continue;
                this.privateVlanEntry = entry;
                break;
            }
        }
        return this.privateVlanEntry;
    }

    public VmwareDistributedVirtualSwitch.VlanSpec getPolicy() {
        return this.policy;
    }

    public String getVlanType() {
        return this.vlanType;
    }
}

