/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.data.datastore.vvol;

import com.vmware.vim.binding.vim.VimVasaProviderInfo;
import com.vmware.vise.core.model.annotation.Dto;
import com.vmware.vsphere.client.modules.api.util.ModulesApiUtil;

@Dto
public class VvolStorageProvidersViewData {
    public StorageProviderItem[] storageProviderItems;

    public static VvolStorageProvidersViewData newInstance(VimVasaProviderInfo[] providerInfos) {
        VvolStorageProvidersViewData result = new VvolStorageProvidersViewData();
        if (providerInfos == null) {
            result.storageProviderItems = new StorageProviderItem[0];
        } else {
            result.storageProviderItems = new StorageProviderItem[providerInfos.length];
            for (int i = 0; i < providerInfos.length; ++i) {
                result.storageProviderItems[i] = StorageProviderItem.newInstance(providerInfos[i]);
            }
        }
        return result;
    }

    @Dto
    public static class StorageProviderItem {
        public int priority = 0;
        public String formattedPriority = "";
        public String formattedName = "";
        public String url = "";
        public String state = "";

        public static StorageProviderItem newInstance(VimVasaProviderInfo providerInfo) {
            StorageProviderItem result = new StorageProviderItem();
            boolean isActive = false;
            if (providerInfo != null && providerInfo.provider != null) {
                result.formattedName = providerInfo.provider.name;
                result.url = StorageProviderItem.getStringValue(providerInfo.provider.url);
                if (providerInfo.arrayState != null && providerInfo.arrayState.length > 0) {
                    result.priority = providerInfo.arrayState[0].priority;
                    result.formattedPriority = Integer.toString(result.priority);
                    if (providerInfo.arrayState[0].active) {
                        isActive = true;
                        result.formattedName = ModulesApiUtil.getString("datastore.monitor.storageProvidersView.activeProviderName", result.formattedName);
                    }
                }
            }
            result.state = isActive ? ModulesApiUtil.getString("datastore.monitor.storageProvidersView.active") : ModulesApiUtil.getString("datastore.monitor.storageProvidersView.inactive");
            return result;
        }

        private static String getStringValue(String value) {
            return value != null ? value : ModulesApiUtil.getString("na");
        }
    }
}

