/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.data.host;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.Capability;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.annotation.Dto;
import com.vmware.vise.util.Version;
import com.vmware.vsphere.client.h5.storage.util.H5StorageUtil;
import com.vmware.vsphere.client.modules.api.util.ModulesApiUtil;

@Dto
public class HostData {
    private static final Version ESX_5_5 = new Version("5.5.0");
    private static final Version ESX_6_5 = new Version("6.5.0");
    public ManagedObjectReference hostRef;
    public String formattedName;
    public String hostName;
    public String clusterName;
    public boolean isHostConnected;
    public boolean isHostStandByState;
    public boolean isHostNotResponding;
    public boolean hasConfigStoragePrivilege;
    public Boolean isNfs4Supported;
    public Boolean isIpV6NfsSupported;
    public Boolean isVMFS6Supported;
    public Boolean isInDomain;
    public Boolean areKerberosCredentialsSet;
    public Boolean isKerberos5iSupported;
    public Boolean isVmknicBindingSupported;
    public Boolean isVvolSupported;
    public String[] virtualNics;
    public Boolean isNvmeVvolSupported;

    public static HostData newInstance(ManagedObjectReference hostRef, String name, HostSystem.ConnectionState connectionState, HostSystem.PowerState powerState, String clusterName, boolean hasConfigStoragePrivilege, Capability capability, String esxVersion, Boolean isInDomain, VirtualNic[] virtualNics) {
        HostData hostData = new HostData();
        hostData.isHostConnected = HostSystem.ConnectionState.connected.equals((Object)connectionState);
        hostData.hostRef = hostRef;
        if (HostSystem.ConnectionState.notResponding.equals((Object)connectionState)) {
            if (HostSystem.PowerState.standBy.equals((Object)powerState)) {
                hostData.formattedName = ModulesApiUtil.getString("vmfsDatastore.options.hostState.standby", name);
                hostData.isHostStandByState = true;
            } else {
                hostData.formattedName = ModulesApiUtil.getString("vmfsDatastore.options.hostState.notResponding", name);
                hostData.isHostNotResponding = true;
            }
        } else {
            hostData.formattedName = HostSystem.ConnectionState.disconnected.equals((Object)connectionState) ? ModulesApiUtil.getString("vmfsDatastore.options.hostState.disconnected", name) : name;
        }
        hostData.hostName = name;
        hostData.clusterName = clusterName;
        hostData.hasConfigStoragePrivilege = hasConfigStoragePrivilege;
        if (capability != null) {
            hostData.isNfs4Supported = capability.nfs41Supported;
            hostData.isVvolSupported = capability.virtualVolumeDatastoreSupported;
            hostData.isKerberos5iSupported = capability.nfs41Krb5iSupported;
            hostData.isVmknicBindingSupported = capability.vmknicBindingSupported;
            hostData.isNvmeVvolSupported = capability.nvmeVvolSupported;
        }
        hostData.isIpV6NfsSupported = Version.compare((Version)new Version(esxVersion), (Version)ESX_5_5) > 0;
        hostData.isVMFS6Supported = Version.compare((Version)new Version(esxVersion), (Version)ESX_6_5) >= 0;
        hostData.isInDomain = isInDomain;
        if (virtualNics != null) {
            hostData.virtualNics = H5StorageUtil.filterDefaultTcpipStackVirtualNics(virtualNics);
        }
        return hostData;
    }
}

