/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.data.host;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.host.CacheConfigurationManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.modules.api.util.ModulesApiUtil;

public class HostSwapToSsdData {
    public boolean hasAdvancedConfigPrivilege;
    public DatastoreItem[] ssdDatastores;

    public static class DatastoreItem {
        public ManagedObjectReference dsRef;
        public String formattedName;
        public long capacity;
        public long freeSpace;
        public Long hostCacheSpaceInMb;
        public boolean canBeUsedForCache;

        public static DatastoreItem newInstance(ManagedObjectReference dsRef, String dsName, long capacity, long freeSpace, boolean accessible, Datastore.HostMount hostMount, CacheConfigurationManager.CacheConfigurationInfo cacheConfigInfo) {
            DatastoreItem item = new DatastoreItem();
            item.dsRef = dsRef;
            item.formattedName = dsName;
            item.canBeUsedForCache = true;
            if (!accessible) {
                item.formattedName = ModulesApiUtil.getString("datastore.inaccessible", item.formattedName);
                item.canBeUsedForCache = false;
            }
            if (!DatastoreItem.isDatastoreMounted(hostMount)) {
                item.formattedName = ModulesApiUtil.getString("datastore.unmounted", item.formattedName);
                item.canBeUsedForCache = false;
            }
            item.freeSpace = freeSpace;
            item.capacity = capacity;
            if (cacheConfigInfo != null) {
                item.hostCacheSpaceInMb = cacheConfigInfo.swapSize;
            }
            return item;
        }

        private static boolean isDatastoreMounted(Datastore.HostMount hostMount) {
            return hostMount != null && hostMount.mountInfo != null && (hostMount.mountInfo.mounted == null || Boolean.TRUE.equals(hostMount.mountInfo.mounted));
        }
    }
}

