/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.data.multipathing;

import com.vmware.vise.core.model.annotation.Dto;
import com.vmware.vsphere.client.h5.storage.data.multipathing.BaseStoragePath;
import com.vmware.vsphere.client.h5.storage.util.H5StorageUtil;
import com.vmware.vsphere.client.storage.DeviceMultipathingInfo;
import com.vmware.vsphere.client.storage.adapters.StoragePathData;

@Dto
public class VmfsExtentStoragePath
extends BaseStoragePath {
    public String lunId;
    public int lunNumber;
    public String adapter;
    public String preferred;

    public static VmfsExtentStoragePath newInstance(StoragePathData pathData, String preferredPathName) {
        VmfsExtentStoragePath path = new VmfsExtentStoragePath();
        path.initialize(pathData);
        path.preferred = BaseStoragePath.getPreferred(path, preferredPathName);
        path.adapter = H5StorageUtil.formatHostStorageAdapterIdentifier(pathData.pathHba);
        path.lunId = BaseStoragePath.getLunId(pathData);
        path.lunNumber = BaseStoragePath.getLunNumber(pathData);
        return path;
    }

    public static VmfsExtentStoragePath[] extractStoragePaths(DeviceMultipathingInfo deviceMultipathingInfo) {
        if (deviceMultipathingInfo == null || deviceMultipathingInfo.paths == null) {
            return null;
        }
        String preferredPathName = BaseStoragePath.getPreferredPathName(deviceMultipathingInfo.pathSelectionPolicy);
        VmfsExtentStoragePath[] paths = new VmfsExtentStoragePath[deviceMultipathingInfo.paths.length];
        for (int pathIndex = 0; pathIndex < deviceMultipathingInfo.paths.length; ++pathIndex) {
            paths[pathIndex] = VmfsExtentStoragePath.newInstance(deviceMultipathingInfo.paths[pathIndex], preferredPathName);
        }
        return paths;
    }
}

