/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.util;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vim.binding.sms.storage.StorageContainer;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vim.binding.vim.host.DiskDimensions;
import com.vmware.vim.binding.vim.host.FibreChannelHba;
import com.vmware.vim.binding.vim.host.FibreChannelTargetTransport;
import com.vmware.vim.binding.vim.host.FileSystemMountInfo;
import com.vmware.vim.binding.vim.host.FileSystemVolumeInfo;
import com.vmware.vim.binding.vim.host.HostBusAdapter;
import com.vmware.vim.binding.vim.host.InternetScsiHba;
import com.vmware.vim.binding.vim.host.InternetScsiTargetTransport;
import com.vmware.vim.binding.vim.host.MountInfo;
import com.vmware.vim.binding.vim.host.NasVolume;
import com.vmware.vim.binding.vim.host.NetStackInstance;
import com.vmware.vim.binding.vim.host.ScsiDisk;
import com.vmware.vim.binding.vim.host.ScsiLun;
import com.vmware.vim.binding.vim.host.TargetTransport;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VmfsDatastoreInfo;
import com.vmware.vim.binding.vim.host.VmfsVolume;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.modules.api.util.ModulesApiUtil;
import com.vmware.vsphere.client.storage.adapters.StoragePathData;
import com.vmware.vsphere.client.storage.util.StorageUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class H5StorageUtil {
    private static final String DC_TO_CLUSTER_RELATION = "cluster";
    private static final String DC_TO_DATASTORE_RELATION = "datastore";
    private static final long BLOCK_SIZE_DEFAULT = 512L;
    public static final String VMFS = "vmfs";
    public static final String VSAND = "vsanD";
    private static final String PATH_RUNTIME_NAME_TMPL = "%s:C%s:T%s:L%s";
    private static final String VMFS_ZERO_VERSION = "0.00";
    public static final String NFS3 = "NFS";
    public static final String NFS41 = "NFS41";
    public static final String VVOL = "vvol";
    public static final String NVME_VVOL = "NVMe";
    public static final String VSAN = "vsan";
    public static final String VMFS3 = "VMFS 3";
    public static final String VMFS5 = "VMFS 5";
    public static final String VMFS6 = "VMFS 6";

    public static String localizeDatastoreSpecificType(String specificType) {
        if (NFS41.equalsIgnoreCase(specificType)) {
            return ModulesApiUtil.getString("datastore.nfs41");
        }
        if (NFS3.equalsIgnoreCase(specificType)) {
            return ModulesApiUtil.getString("datastore.nfs3");
        }
        if (VVOL.equalsIgnoreCase(specificType)) {
            return ModulesApiUtil.getString("datastore.vvol");
        }
        if (VSAN.equalsIgnoreCase(specificType)) {
            return ModulesApiUtil.getString("datastore.vsan");
        }
        if (VSAND.equalsIgnoreCase(specificType)) {
            return ModulesApiUtil.getString("datastore.vsand");
        }
        if (VMFS3.equalsIgnoreCase(specificType)) {
            return ModulesApiUtil.getString("datastore.vmfs3");
        }
        if (VMFS5.equalsIgnoreCase(specificType)) {
            return ModulesApiUtil.getString("datastore.vmfs5");
        }
        if (VMFS6.equalsIgnoreCase(specificType)) {
            return ModulesApiUtil.getString("datastore.vmfs6");
        }
        return specificType;
    }

    public static long lbaToBytes(DiskDimensions.Lba lba) {
        long blockSize = lba.blockSize == 0 ? 512L : (long)lba.blockSize;
        return lba.block * blockSize;
    }

    public static String formatFlash(Boolean isFlash) {
        if (isFlash != null && isFlash.booleanValue()) {
            return ModulesApiUtil.getString("flash");
        }
        return ModulesApiUtil.getString("hdd");
    }

    public static String formatDatastoreType(String dsType) {
        if (NFS41.equalsIgnoreCase(dsType)) {
            return ModulesApiUtil.getString("datastore.nfs41");
        }
        if (NFS3.equalsIgnoreCase(dsType)) {
            return ModulesApiUtil.getString("datastore.nfs3");
        }
        if (VVOL.equalsIgnoreCase(dsType)) {
            return ModulesApiUtil.getString("datastore.vvol");
        }
        return dsType;
    }

    public static String formatSupportedValue(Boolean supported) {
        if (Boolean.TRUE.equals(supported)) {
            return ModulesApiUtil.getString("supported");
        }
        return ModulesApiUtil.getString("notSupported");
    }

    public static String formatEnabledValue(Boolean enabled) {
        if (Boolean.TRUE.equals(enabled)) {
            return ModulesApiUtil.getString("enabled");
        }
        return ModulesApiUtil.getString("disabled");
    }

    public static boolean isVmfsDsType(String dsType) {
        return VMFS.equalsIgnoreCase(dsType);
    }

    public static String formatPathRuntimeName(StoragePathData data) {
        if (data.pathHba != null && data.path != null && data.pathHba.device != null && data.path.channelNumber != null && data.path.targetNumber != null && data.path.lunNumber != null) {
            return String.format(PATH_RUNTIME_NAME_TMPL, data.pathHba.device, data.path.channelNumber, data.path.targetNumber, data.path.lunNumber);
        }
        return "";
    }

    public static String formatTargetStringForPath(TargetTransport transport) {
        String formatted = "";
        if (transport == null) {
            return formatted;
        }
        if (transport instanceof FibreChannelTargetTransport) {
            FibreChannelTargetTransport fibreTransport = (FibreChannelTargetTransport)transport;
            String nodeName = H5StorageUtil.formatWWPN(fibreTransport.getNodeWorldWideName());
            String portName = H5StorageUtil.formatWWPN(fibreTransport.getPortWorldWideName());
            if (StringUtils.isEmpty((CharSequence)nodeName) && StringUtils.isEmpty((CharSequence)portName)) {
                return formatted;
            }
            if (StringUtils.isEmpty((CharSequence)nodeName)) {
                return portName;
            }
            if (StringUtils.isEmpty((CharSequence)portName)) {
                return nodeName;
            }
            formatted = String.format("%s %s", nodeName, portName);
        } else if (transport instanceof InternetScsiTargetTransport) {
            InternetScsiTargetTransport iscsiTransport = (InternetScsiTargetTransport)transport;
            StringBuilder ipAddressesStringBuilder = new StringBuilder();
            String[] ipAddresses = iscsiTransport.address;
            if (ipAddresses != null) {
                for (int i = 0; i < ipAddresses.length; ++i) {
                    String ipAddress = ipAddresses[i];
                    ipAddressesStringBuilder.append(ipAddress);
                    if (i >= ipAddresses.length - 1) continue;
                    ipAddressesStringBuilder.append(", ");
                }
            }
            String ipAddressesString = ipAddressesStringBuilder.toString();
            if (StringUtils.isEmpty((CharSequence)iscsiTransport.iScsiName) && StringUtils.isEmpty((CharSequence)ipAddressesString)) {
                return "";
            }
            String name = StringUtils.isNotEmpty((CharSequence)iscsiTransport.iScsiName) ? iscsiTransport.iScsiName : ModulesApiUtil.getString("storage.adapters.iscsi.noName");
            formatted = String.format("%s:%s", name, ipAddressesString);
        }
        return formatted;
    }

    public static String formatAccessMode(String accessMode) {
        if (MountInfo.AccessMode.readOnly.toString().equals(accessMode)) {
            return ModulesApiUtil.getString("datastore.accessMode.readOnly");
        }
        if (MountInfo.AccessMode.readWrite.toString().equals(accessMode)) {
            return ModulesApiUtil.getString("datastore.accessMode.readWrite");
        }
        return "";
    }

    public static String formatKerberosAuthentication(NasVolume nasVolume) {
        if (nasVolume == null || NFS3.equals(nasVolume.getType())) {
            return null;
        }
        if (NasVolume.SecurityType.SEC_KRB5.toString().equals(nasVolume.getSecurityType())) {
            return ModulesApiUtil.getString("datastore.kerberosAuthentication.enabledKrb5");
        }
        if (NasVolume.SecurityType.SEC_KRB5I.toString().equals(nasVolume.getSecurityType())) {
            return ModulesApiUtil.getString("datastore.kerberosAuthentication.enabledKrb5i");
        }
        return ModulesApiUtil.getString("datastore.kerberosAuthentication.disabled");
    }

    public static String formatHostStorageAdapterIdentifier(HostBusAdapter hba) {
        if (hba instanceof FibreChannelHba) {
            FibreChannelHba fibreChannelHba = (FibreChannelHba)hba;
            String nodeName = H5StorageUtil.formatWWPN(fibreChannelHba.nodeWorldWideName);
            String portName = H5StorageUtil.formatWWPN(fibreChannelHba.portWorldWideName);
            if (nodeName.isEmpty()) {
                return portName;
            }
            if (portName.isEmpty()) {
                return nodeName;
            }
            return nodeName + " " + portName;
        }
        if (hba instanceof InternetScsiHba) {
            InternetScsiHba iscsiHba = (InternetScsiHba)hba;
            String result = StringUtils.isEmpty((CharSequence)iscsiHba.iScsiAlias) ? iscsiHba.iScsiName : (StringUtils.isEmpty((CharSequence)iscsiHba.iScsiName) ? iscsiHba.iScsiAlias : String.format("%s(%s)", iscsiHba.iScsiAlias, iscsiHba.iScsiName));
            if (result == null) {
                result = ModulesApiUtil.getString("na");
            }
            return result;
        }
        return ModulesApiUtil.getString("na");
    }

    public static String formatWWPN(long wwpn) {
        if (wwpn == 0L) {
            return "";
        }
        StringBuilder builder = new StringBuilder(Long.toHexString(wwpn));
        if (builder.length() % 2 != 0) {
            builder.insert(0, "0");
        }
        for (int i = builder.length() - 2; i > 0; i -= 2) {
            builder.insert(i, ":");
        }
        return builder.toString();
    }

    public static String getHostStateIssue(HostSystem.ConnectionState connectionState, HostSystem.PowerState powerState) {
        String hostState = null;
        if (connectionState == HostSystem.ConnectionState.notResponding) {
            hostState = powerState == HostSystem.PowerState.standBy ? ModulesApiUtil.getString("hostState.standBy") : ModulesApiUtil.getString("hostState.notResponding");
        } else if (connectionState == HostSystem.ConnectionState.disconnected) {
            hostState = ModulesApiUtil.getString("hostState.disconnected");
        }
        return hostState;
    }

    public static String appendIssue(String hostName, String compatibilityIssue) {
        if (compatibilityIssue == null) {
            return hostName;
        }
        return ModulesApiUtil.getString("formattedHostName.label", hostName, compatibilityIssue);
    }

    public static boolean checkMountUnmountVmfsDatastoreActionAvailability(Boolean isUnmounting, Datastore.Info dsInfo, Datastore.HostMount[] hostMounts) {
        if (!(dsInfo instanceof VmfsDatastoreInfo)) {
            return false;
        }
        if (StorageUtil.isForceMountedVMFSDatastore(dsInfo).booleanValue()) {
            return false;
        }
        if (ArrayUtils.isEmpty((Object[])hostMounts)) {
            return false;
        }
        for (Datastore.HostMount hostMount : hostMounts) {
            if (hostMount.mountInfo == null || !isUnmounting.equals(hostMount.mountInfo.mounted)) continue;
            return true;
        }
        return false;
    }

    public static String formatVmfsVersion(VmfsVolume vmfsVolume) {
        String vmfsVersion = ModulesApiUtil.getString("vmfsDatastore.version.format", vmfsVolume.version);
        if (VMFS_ZERO_VERSION.equals(vmfsVolume.version)) {
            vmfsVersion = vmfsVolume.majorVersion > 0 ? ModulesApiUtil.getString("vmfsDatastore.version.format", Integer.toString(vmfsVolume.majorVersion)) : ModulesApiUtil.getString("vmfsDatastore.version.format", "");
        }
        return vmfsVersion;
    }

    public static String formatIormMode(boolean isAutomaticMode, StorageResourceManager.IORMConfigInfo iormConfigInfo) {
        if (isAutomaticMode) {
            return ModulesApiUtil.getString("datastore.manage.general.datastoreCapabilities.iormMode.automatic", iormConfigInfo.percentOfPeakThroughput.toString());
        }
        return ModulesApiUtil.getString("datastore.manage.general.datastoreCapabilities.iormMode.manual");
    }

    public static String getSectorFormatByScsiLun(ScsiLun scsiLun) {
        if (scsiLun instanceof ScsiDisk) {
            String scsiDiskType = ((ScsiDisk)scsiLun).scsiDiskType;
            return H5StorageUtil.getSectorFormatByScsiDiskType(scsiDiskType);
        }
        return "";
    }

    public static String getSectorFormatByScsiDiskType(String scsiDiskType) {
        if (scsiDiskType != null) {
            String diskTypeKey = "scsiDisk.scsiDiskType.unknown";
            switch (ScsiDisk.ScsiDiskType.valueOf((String)scsiDiskType)) {
                case native512: {
                    diskTypeKey = "scsiDisk.scsiDiskType.native512";
                    break;
                }
                case emulated512: {
                    diskTypeKey = "scsiDisk.scsiDiskType.emulated512";
                    break;
                }
                case native4k: {
                    diskTypeKey = "scsiDisk.scsiDiskType.native4k";
                    break;
                }
                case SoftwareEmulated4k: {
                    diskTypeKey = "scsiDisk.scsiDiskType.softwareEmulated4k";
                }
            }
            return ModulesApiUtil.getString(diskTypeKey);
        }
        return "";
    }

    public static ScsiLun.State getOperationalState(String[] operationalState) {
        if (operationalState != null) {
            HashSet operationalStateSet = new HashSet();
            Collections.addAll(operationalStateSet, operationalState);
            if (operationalStateSet.contains(ScsiLun.State.ok.toString())) {
                return ScsiLun.State.ok;
            }
            if (operationalStateSet.contains(ScsiLun.State.off.toString())) {
                return ScsiLun.State.off;
            }
            if (operationalStateSet.contains(ScsiLun.State.lostCommunication.toString())) {
                return ScsiLun.State.lostCommunication;
            }
            if (operationalStateSet.contains(ScsiLun.State.error.toString())) {
                return ScsiLun.State.error;
            }
        }
        return ScsiLun.State.unknownState;
    }

    public static boolean isVsanContainer(StorageContainer container) {
        if (container == null || StringUtils.isEmpty((CharSequence)container.uuid)) {
            return false;
        }
        return container.uuid.toLowerCase().startsWith("vsan:");
    }

    public static boolean isIoFilterContainer(StorageContainer container) {
        if (container == null || container.arrayId == null || ArrayUtils.isEmpty((Object[])container.arrayId)) {
            return false;
        }
        for (String arrayId : container.arrayId) {
            if (!StringUtils.isNotEmpty((CharSequence)arrayId) || !arrayId.toLowerCase().startsWith("iofilters:")) continue;
            return true;
        }
        return false;
    }

    public static NasVolume getNasVolumeByMountInfo(FileSystemVolumeInfo fileSystemVolumeInfo, MountInfo mountInfo) {
        if (fileSystemVolumeInfo != null && mountInfo != null && fileSystemVolumeInfo.mountInfo != null && fileSystemVolumeInfo.mountInfo != null) {
            for (FileSystemMountInfo fileSystemMountInfo : fileSystemVolumeInfo.mountInfo) {
                if (!(fileSystemMountInfo.volume instanceof NasVolume) || !fileSystemMountInfo.mountInfo.path.equals(mountInfo.path)) continue;
                return (NasVolume)fileSystemMountInfo.volume;
            }
        }
        return null;
    }

    public static boolean areNasVolumeSpecsEqual(NasVolume.Specification nasVolumeSpecification1, NasVolume.Specification nasVolumeSpecification2) {
        if (nasVolumeSpecification1 == null || nasVolumeSpecification2 == null) {
            return false;
        }
        return nasVolumeSpecification1.remoteHost.equals(nasVolumeSpecification2.remoteHost) && nasVolumeSpecification1.remotePath.equals(nasVolumeSpecification2.remotePath);
    }

    public static ManagedObjectReference queryParentDatacenterRef(QueryService queryService, ManagedObjectReference objRef) {
        String property;
        if (queryService == null || objRef == null) {
            return null;
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, (String)Datacenter.class.getSimpleName())) {
            return objRef;
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, (String)ClusterComputeResource.class.getSimpleName())) {
            property = DC_TO_CLUSTER_RELATION;
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, (String)Datastore.class.getSimpleName())) {
            property = DC_TO_DATASTORE_RELATION;
        } else {
            return null;
        }
        ResultSet resultSet = queryService.select(new String[]{"@modelKey"}).from(new String[]{Datacenter.class.getSimpleName()}).where(property, PropertyPredicate.ComparisonOperator.EQUAL, (Object)objRef).fetch();
        if (H5StorageUtil.isResultSetNullOrEmpty(resultSet)) {
            return null;
        }
        return (ManagedObjectReference)((ResourceItem)resultSet.getItems().get(0)).get("@modelKey");
    }

    public static boolean isResultSetNullOrEmpty(ResultSet resultSet) {
        return resultSet == null || resultSet.getItems() == null || resultSet.getItems().isEmpty();
    }

    public static boolean isVsanDirectDatastore(Datastore.Summary dsSummary) {
        return dsSummary != null && VSAND.equalsIgnoreCase(dsSummary.getType());
    }

    public static boolean isVsanDirectDatastore(String dsType) {
        return VSAND.equalsIgnoreCase(dsType);
    }

    public static String overlay(String str, int overlayStartIndex, char overlayChar) {
        if (str == null) {
            return null;
        }
        int startIndex = overlayStartIndex > 0 && overlayStartIndex < str.length() ? overlayStartIndex : 0;
        int overlayLength = str.length() - startIndex;
        return StringUtils.overlay((String)str, (String)StringUtils.repeat((char)overlayChar, (int)overlayLength), (int)startIndex, (int)str.length());
    }

    public static String[] filterDefaultTcpipStackVirtualNics(VirtualNic[] virtualNics) {
        ArrayList<String> result = new ArrayList<String>();
        for (VirtualNic virtualNic : virtualNics) {
            if (virtualNic == null || virtualNic.spec == null || !virtualNic.spec.netStackInstanceKey.equals(NetStackInstance.SystemStackKey.defaultTcpipStack.name())) continue;
            result.add(virtualNic.device);
        }
        return result.toArray(new String[result.size()]);
    }
}

