/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.data;

import com.vmware.vim.binding.vim.profile.host.ExecuteResult;
import com.vmware.vsphere.client.hostprofile.util.AmfTypeRestorer;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;

public class ExecuteResultWrapper
implements Externalizable {
    private ExecuteResult _executeResult;
    private Map<String, String> _incompatibleConfigMetadata;

    public ExecuteResultWrapper() {
    }

    public ExecuteResultWrapper(ExecuteResult executeResult) {
        this._executeResult = executeResult;
        this.persistConfigIncompatibleProperties();
    }

    private void persistConfigIncompatibleProperties() {
        if (this._executeResult != null) {
            this._incompatibleConfigMetadata = new HashMap<String, String>();
            AmfTypeRestorer.extractIncompatibleFlexObjects(this._executeResult.configSpec, this._incompatibleConfigMetadata, null);
        }
    }

    private void restoreConfigIncompatibleValues() {
        if (this._executeResult != null && this._incompatibleConfigMetadata != null) {
            AmfTypeRestorer.restoreIncompatibleFlexObjects(this._executeResult.configSpec, this._incompatibleConfigMetadata);
        }
    }

    public ExecuteResult getExecuteResult() {
        this.restoreConfigIncompatibleValues();
        return this._executeResult;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._executeResult);
        out.writeObject(this._incompatibleConfigMetadata);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._executeResult = (ExecuteResult)in.readObject();
        this._incompatibleConfigMetadata = (Map)in.readObject();
    }

    public ExecuteResult get_executeResult() {
        this.restoreConfigIncompatibleValues();
        return this._executeResult;
    }
}

