/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.data;

import com.vmware.vim.binding.vim.profile.ApplyProfile;
import com.vmware.vim.binding.vim.profile.Policy;

public class ProfileComponentData {
    public static final String TYPE_PROFILE = "profile";
    public static final String TYPE_POLICY = "policy";
    public static final String TYPE_FOLDER = "folder";
    public static final String TYPE_EMPTY = "empty";
    public String name;
    public String category;
    public ApplyProfile profileRef;
    public Policy policyRef;
    public String componentType;
    public String parentComponentType = "profile";

    public static ProfileComponentData createEmptyComponent(String category, String name) {
        ProfileComponentData result = new ProfileComponentData(category, name);
        result.componentType = TYPE_EMPTY;
        result.parentComponentType = TYPE_FOLDER;
        return result;
    }

    public static ProfileComponentData createPolicyComponent(String category, String name, ApplyProfile profile, Policy policy) {
        ProfileComponentData result = new ProfileComponentData(category, name);
        result.componentType = TYPE_POLICY;
        result.profileRef = profile;
        result.policyRef = policy;
        return result;
    }

    public static ProfileComponentData createFolderComponent(String category, String name) {
        ProfileComponentData result = new ProfileComponentData(category, name);
        result.componentType = TYPE_FOLDER;
        return result;
    }

    public static ProfileComponentData createProfileComponent(String category, String name, ApplyProfile profile) {
        ProfileComponentData result = new ProfileComponentData(category, name);
        result.componentType = TYPE_PROFILE;
        result.profileRef = profile;
        return result;
    }

    public static ProfileComponentData createProfileComponentWithFolderParent(String category, String name, ApplyProfile profile) {
        ProfileComponentData result = new ProfileComponentData(category, name);
        result.componentType = TYPE_PROFILE;
        result.parentComponentType = TYPE_FOLDER;
        result.profileRef = profile;
        return result;
    }

    private ProfileComponentData(String category, String name) {
        this.category = category;
        this.name = name;
    }
}

