/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.data.h5;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vsphere.client.hostprofile.data.ComplianceFailuresByCategory;
import com.vmware.vsphere.client.hostprofile.data.h5.compliancefailures.ComplianceFailureEntity;
import com.vmware.vsphere.client.hostprofile.data.h5.compliancefailures.ComplianceFailureFactory;
import com.vmware.vsphere.client.hostprofile.data.h5.compliancefailures.ComplianceFailuresFlatData;
import com.vmware.vsphere.client.hostprofile.util.HostProfileComplianceDataUtil;
import java.util.List;

@QueryBinding(value="HostSystem")
public class HostProfileComplianceFailuresData
extends IdentifiableQueryBinding {
    @Property(value="HostSystem/complianceFailures")
    public ComplianceFailuresByCategory[] complianceFailuresByCategories;
    @Property(value="HostSystem/remediationState")
    public transient HostSystem.RemediationState remediationState;
    @Property(value="HostSystem/complianceCheckState")
    public transient HostSystem.ComplianceCheckState complianceCheckState;

    public List<ComplianceFailureEntity> getComplianceFailureTreeListData() {
        return this.isComplianceFailuresAvailable() ? this.getComplianceFailureEntities() : null;
    }

    public List<ComplianceFailuresFlatData> getComplianceFailureFlatListData() {
        return this.isComplianceFailuresAvailable() ? this.getComplianceFailureFlatList() : null;
    }

    private List<ComplianceFailuresFlatData> getComplianceFailureFlatList() {
        ComplianceFailureFactory factory = new ComplianceFailureFactory();
        return factory.getFlatComplianceFailures(this.complianceFailuresByCategories);
    }

    private List<ComplianceFailureEntity> getComplianceFailureEntities() {
        ComplianceFailureFactory factory = new ComplianceFailureFactory();
        return factory.getComplianceFailureEntities(this.complianceFailuresByCategories);
    }

    private boolean isComplianceFailuresAvailable() {
        return this.complianceFailuresByCategories != null && !this.isHpRelatedOperationRunning();
    }

    private boolean isHpRelatedOperationRunning() {
        return HostProfileComplianceDataUtil.getIsHpRelatedOperationRunning(this.remediationState, this.complianceCheckState);
    }
}

