/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.data.h5.remediate;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.cluster.DrsConfigInfo;
import com.vmware.vim.binding.vim.profile.host.AnswerFileStatusResult;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.HostPrecheckAvailabilityData;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.HostRemediateResult;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.util.HostRemediateStatusUtil;
import com.vmware.vsphere.client.hostprofile.util.HostProfileComplianceDataUtil;

@QueryBinding(value="HostSystem")
public class HostPrecheckResultData
extends HostPrecheckAvailabilityData {
    @Property(value="HostSystem/name")
    public String name;
    @Relationship(value={"HostSystem/parent"})
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/enabled")
    protected Boolean clusterDrsEnabled;
    @Relationship(value={"HostSystem/parent"})
    @Property(value="ClusterComputeResource/configurationEx/drsConfig/defaultVmBehavior")
    protected DrsConfigInfo.DrsBehavior defaultDrsBehavior;
    @Property(value="HostSystem/runtime/inMaintenanceMode")
    protected boolean inMaintenanceMode;
    @Property(value="HostSystem/runtime/connectionState")
    protected HostSystem.ConnectionState connectionState;
    @Property(value="HostSystem/answerFileValidationState")
    protected AnswerFileStatusResult answerFileValidationState;
    @Property(value="HostSystem/complianceCheckState")
    private HostSystem.ComplianceCheckState complianceCheckState;
    @Property(value="HostSystem/hp")
    protected ManagedObjectReference hp;

    public HostRemediateResult getPrecheckResult() {
        return HostRemediateStatusUtil.getPrecheckResult(this.precheckRemediationResult, this.clusterDrsEnabled, this.defaultDrsBehavior, this.inMaintenanceMode);
    }

    public ManagedObjectReference getHostMor() {
        return (ManagedObjectReference)this.provider;
    }

    private boolean getAreHostCustomizationsRequired() {
        return this.answerFileValidationState != null && HostProfileComplianceDataUtil.getAreHostCustomizationsRequired(this.answerFileValidationState.getStatus());
    }

    public boolean getIsHostStateValid() {
        boolean isStatusRunning = this.getIsHpRelatedOperationRunning();
        boolean areHostCustomizationsRequired = this.getAreHostCustomizationsRequired();
        boolean isHostConnected = this.isHostConnected();
        return HostProfileComplianceDataUtil.getIsHostStateValid(isStatusRunning, areHostCustomizationsRequired, isHostConnected, this.hp);
    }

    private boolean getIsHpRelatedOperationRunning() {
        ManagedObjectReference ref = this.getHostMor();
        return VcServiceUtil.is66VcOrLaterByServerGuid((String)ref.getServerGuid()) && HostProfileComplianceDataUtil.getIsHpRelatedOperationRunning(this.remediationState, this.complianceCheckState);
    }

    private boolean isHostConnected() {
        return HostProfileComplianceDataUtil.isHostConnected(this.connectionState);
    }
}

