/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.util;

import com.vmware.vim.binding.vim.profile.ApplyProfile;
import com.vmware.vim.binding.vim.profile.ApplyProfileElement;
import com.vmware.vim.binding.vim.profile.ApplyProfileProperty;
import com.vmware.vim.binding.vim.profile.Policy;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vim.profile.ProfileCategoryMetadata;
import com.vmware.vim.binding.vim.profile.ProfileComponentMetadata;
import com.vmware.vim.binding.vim.profile.ProfileMetadata;
import java.lang.reflect.Field;

public class KeyUtil {
    public static final String EMPTY_KEY = "";

    public static String getProfileMetaDataKey(ProfileMetadata meta) {
        if (meta == null || meta.key == null) {
            return EMPTY_KEY;
        }
        String key = EMPTY_KEY;
        key = ApplyProfile.class.isAssignableFrom(meta.key.getClass()) || ApplyProfileElement.class.isAssignableFrom(meta.key.getClass()) ? meta.key.getName() : meta.profileTypeName;
        return key.toLowerCase();
    }

    public static String getProfileTypeKey(ApplyProfile ap) {
        if (ap == null || ap.profileTypeName == null) {
            return EMPTY_KEY;
        }
        String key = ap.profileTypeName;
        return key.toLowerCase();
    }

    public static String getPolicyMetaDataKey(PolicyMetadata meta) {
        if (meta == null || meta.id == null || meta.id.key == null) {
            return EMPTY_KEY;
        }
        return meta.id.key.toLowerCase();
    }

    public static String getComponentMetaDataKey(ProfileComponentMetadata meta) {
        if (meta == null || meta.id == null || meta.id.key == null) {
            return EMPTY_KEY;
        }
        return meta.id.key.toLowerCase();
    }

    public static String getCategoryMetaDataKey(ProfileCategoryMetadata meta) {
        if (meta == null || meta.id == null || meta.id.key == null) {
            return EMPTY_KEY;
        }
        return meta.id.key.toLowerCase();
    }

    public static String getPolicyKeyForMetadata(Policy policy) {
        if (policy == null || policy.id == null) {
            return EMPTY_KEY;
        }
        return policy.id.toLowerCase();
    }

    public static String getApplyProfileKey(ApplyProfile ap) {
        if (ap == null) {
            return EMPTY_KEY;
        }
        String key = ap.getClass() == ApplyProfile.class ? ap.profileTypeName : ap.getClass().getSimpleName();
        return key.toLowerCase();
    }

    public static String getPropertyKey(ApplyProfileProperty prop) {
        if (prop == null || prop.propertyName == null) {
            return EMPTY_KEY;
        }
        return prop.propertyName.toLowerCase();
    }

    public static String getSubprofileFieldKey(Field f) {
        if (f == null) {
            return EMPTY_KEY;
        }
        String key = f.getType().getSimpleName().replace("[]", EMPTY_KEY);
        return key.toLowerCase();
    }

    public static String getApplyProfileArrayElementKey(ApplyProfile ap) {
        if (ap == null) {
            return EMPTY_KEY;
        }
        String key = ap.getClass().getSimpleName();
        return key.toLowerCase();
    }
}

