/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.util;

import com.vmware.vim.binding.vim.profile.ParameterMetadata;
import com.vmware.vim.binding.vim.profile.Policy;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vim.profile.PolicyOptionMetadata;
import com.vmware.vim.binding.vim.profile.ProfileMetadata;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vsphere.client.hostprofile.util.DescriptionAdapter;
import com.vmware.vsphere.client.hostprofile.util.KeyUtil;
import com.vmware.vsphere.client.hostprofile.util.ProfileNameUtil;
import java.util.HashMap;

public class MetadataAdapter {
    public static final String EMPTY_LABEL = "";
    private ProfileMetadata[] _profileMeta;
    private PolicyMetadata[] _policyMeta;
    private final HashMap<String, ProfileMetadata> _profileMap = new HashMap();
    private final HashMap<String, PolicyMetadata> _policyMap = new HashMap();

    public MetadataAdapter(PolicyMetadata[] policyMeta) {
        if (policyMeta == null) {
            throw new NullPointerException("PolicyMetadata[] is null");
        }
        this._policyMeta = policyMeta;
        this.localizePolicyMetadata();
    }

    public MetadataAdapter(ProfileMetadata[] profileMeta, PolicyMetadata[] policyMeta) {
        if (profileMeta == null) {
            throw new NullPointerException("ProfileMetadata[] is null");
        }
        if (policyMeta == null) {
            throw new NullPointerException("PolicyMetadata[] is null");
        }
        this._profileMeta = profileMeta;
        this._policyMeta = policyMeta;
        this.localizeProfileMetadata();
        this.localizePolicyMetadata();
    }

    private void localizePolicyMetadata() {
        for (PolicyMetadata meta : this._policyMeta) {
            if (meta == null) continue;
            meta.id.label = this.getLocalizedLabel(DescriptionAdapter.valueOf(meta.id));
            meta.id.summary = this.getLocalizedSummary(DescriptionAdapter.valueOf(meta.id));
            this.localizePolicyPossibleOption(meta);
            String key = KeyUtil.getPolicyMetaDataKey(meta);
            this._policyMap.put(key, meta);
        }
    }

    private void localizePolicyPossibleOption(PolicyMetadata policyMeta) {
        if (policyMeta == null || policyMeta.possibleOption == null) {
            return;
        }
        for (PolicyOptionMetadata meta : policyMeta.possibleOption) {
            if (meta == null) continue;
            meta.id.label = this.getLocalizedLabel(DescriptionAdapter.valueOf(meta.id));
            meta.id.summary = this.getLocalizedSummary(DescriptionAdapter.valueOf(meta.id));
            this.localizePolicyOptionMetadataParam(meta);
        }
    }

    private void localizePolicyOptionMetadataParam(PolicyOptionMetadata pomMeta) {
        if (pomMeta == null || pomMeta.parameter == null) {
            return;
        }
        for (ParameterMetadata meta : pomMeta.parameter) {
            if (meta == null) continue;
            DescriptionAdapter description = DescriptionAdapter.valueOf(meta.id);
            meta.id.label = this.getLocalizedLabel(description);
            meta.id.summary = this.getLocalizedSummary(description);
            if (description == null || description.messageCatalogKeyPrefix == null || !meta.id.label.equals(description.messageCatalogKeyPrefix + ".label")) continue;
            meta.id.label = meta.id.key;
            meta.id.summary = EMPTY_LABEL;
        }
    }

    private void localizeProfileMetadata() {
        for (ProfileMetadata meta : this._profileMeta) {
            if (meta == null) continue;
            meta.description.label = this.getLocalizedLabel(DescriptionAdapter.valueOf(meta.description));
            meta.description.summary = this.getLocalizedSummary(DescriptionAdapter.valueOf(meta.description));
            String key = KeyUtil.getProfileMetaDataKey(meta);
            this._profileMap.put(key, meta);
        }
    }

    public String getProfileLabel(String key, boolean trim) {
        ProfileMetadata meta = this.getProfileMeta(key);
        if (meta == null || meta.description == null || meta.description.label == null) {
            return EMPTY_LABEL;
        }
        String result = meta.description.label;
        if (trim) {
            result = ProfileNameUtil.trimPlaceholders(result);
        }
        return result;
    }

    public ProfileMetadata getProfileMeta(String key) {
        if (ProfileNameUtil.isNullOrEmpty(key)) {
            return null;
        }
        return this._profileMap.get(key);
    }

    public String getProfileLabel(String key) {
        return this.getProfileLabel(key, true);
    }

    public String getPolicyLabel(Policy policy) {
        PolicyMetadata meta = this.getPolicyMeta(policy);
        if (meta == null || meta.id == null || meta.id.label == null) {
            return EMPTY_LABEL;
        }
        return ProfileNameUtil.trimPlaceholders(meta.id.label);
    }

    public PolicyMetadata getPolicyMeta(Policy policy) {
        if (policy == null) {
            return null;
        }
        String key = KeyUtil.getPolicyKeyForMetadata(policy);
        if (ProfileNameUtil.isNullOrEmpty(key)) {
            return null;
        }
        if (!this._policyMap.containsKey(key)) {
            return null;
        }
        return this._policyMap.get(key);
    }

    private String getLocalizedLabel(DescriptionAdapter description) {
        if (description == null) {
            return EMPTY_LABEL;
        }
        return LocalizationUtil.getLocalizedMessage((String)(description.messageCatalogKeyPrefix + ".label"), (KeyAnyValue[])description.messageArg);
    }

    private String getLocalizedSummary(DescriptionAdapter description) {
        if (description == null) {
            return EMPTY_LABEL;
        }
        return LocalizationUtil.getLocalizedMessage((String)(description.messageCatalogKeyPrefix + ".summary"), (KeyAnyValue[])description.messageArg);
    }

    public static String extractProfileSummary(ProfileMetadata meta, String defaultDescription) {
        if (meta == null || meta.description == null) {
            return defaultDescription;
        }
        return meta.description.summary;
    }
}

