/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.util;

import com.vmware.vise.util.Pair;
import com.vmware.vsphere.client.hostprofile.data.ProfileWrapper;
import com.vmware.vsphere.client.hostprofile.data.ProfileWrapperComparator;
import com.vmware.vsphere.client.hostprofile.util.CategoryGrouper;
import com.vmware.vsphere.client.hostprofile.util.CategoryMetadataAdapter;
import com.vmware.vsphere.client.hostprofile.util.ComponentGrouper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class ProfileGrouper {
    protected CategoryMetadataAdapter _metaAdapter;

    public static ProfileGrouper createCategoryGrouper(CategoryMetadataAdapter metaAdapter) {
        return new CategoryGrouper(metaAdapter);
    }

    public static ProfileGrouper createComponentGrouper(CategoryMetadataAdapter metaAdapter) {
        return new ComponentGrouper(metaAdapter);
    }

    abstract String getGrouperKey(ProfileWrapper var1);

    abstract Pair<String, ProfileWrapper> createGrouper(ProfileWrapper var1);

    abstract ProfileWrapper groupChildren(ProfileWrapper var1);

    public static void ungroup(ProfileWrapper wrapper) {
        if (wrapper == null) {
            return;
        }
        wrapper.children = ProfileGrouper.ungroupInternal(wrapper);
    }

    private static ArrayList<ProfileWrapper> ungroupInternal(ProfileWrapper wrapper) {
        ArrayList<ProfileWrapper> result = new ArrayList<ProfileWrapper>();
        for (ProfileWrapper child : wrapper.children) {
            if (!ProfileWrapper.isCategory(child) && !ProfileWrapper.isComponent(child)) {
                result.add(child);
                continue;
            }
            result.addAll(ProfileGrouper.ungroupInternal(child));
        }
        return result;
    }

    public ProfileWrapper group(ProfileWrapper wrapper) {
        if (!ProfileWrapper.isCategory(wrapper) && !ProfileWrapper.isRootNode(wrapper)) {
            return wrapper;
        }
        ArrayList<ProfileWrapper> children = ProfileGrouper.extractChildren(wrapper);
        if (children.size() == 0) {
            return wrapper;
        }
        HashMap<String, ProfileWrapper> groupers = new HashMap<String, ProfileWrapper>();
        ArrayList<ProfileWrapper> groupedChildren = new ArrayList<ProfileWrapper>();
        for (ProfileWrapper child : children) {
            ProfileWrapper matchingGrouper = this.findMatchingGrouper(groupers, child);
            if (matchingGrouper != null) {
                matchingGrouper.addChild(child);
                continue;
            }
            Pair<String, ProfileWrapper> keyGrouperPair = this.createGrouper(child);
            if (keyGrouperPair != null) {
                String grouperKey = (String)keyGrouperPair.first;
                ProfileWrapper grouper = (ProfileWrapper)keyGrouperPair.second;
                grouper.addChild(child);
                groupedChildren.add(grouper);
                groupers.put(grouperKey, grouper);
                continue;
            }
            groupedChildren.add(child);
        }
        Collections.sort(groupedChildren, new ProfileWrapperComparator());
        wrapper.children.clear();
        wrapper.children.addAll(groupedChildren);
        wrapper = this.groupChildren(wrapper);
        return wrapper;
    }

    protected static ArrayList<ProfileWrapper> extractChildren(ProfileWrapper wrapper) {
        ArrayList<ProfileWrapper> result = new ArrayList<ProfileWrapper>();
        if (wrapper == null || wrapper.children == null) {
            return result;
        }
        for (ProfileWrapper child : wrapper.children) {
            result.add(child);
        }
        return result;
    }

    private ProfileWrapper findMatchingGrouper(Map<String, ProfileWrapper> groupers, ProfileWrapper targetNode) {
        if (groupers == null || targetNode == null) {
            return null;
        }
        String targetNodeGrouperKey = this.getGrouperKey(targetNode);
        return groupers.get(targetNodeGrouperKey);
    }
}

