/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.adapters;

import com.vmware.vim.binding.vim.host.BlockHba;
import com.vmware.vim.binding.vim.host.FibreChannelHba;
import com.vmware.vim.binding.vim.host.FibreChannelOverEthernetHba;
import com.vmware.vim.binding.vim.host.HostBusAdapter;
import com.vmware.vim.binding.vim.host.InternetScsiHba;
import com.vmware.vim.binding.vim.host.ParallelScsiHba;
import com.vmware.vim.binding.vim.host.PcieHba;
import com.vmware.vim.binding.vim.host.RdmaHba;
import com.vmware.vim.binding.vim.host.SerialAttachedHba;
import com.vmware.vim.binding.vim.host.TcpHba;

public enum StorageAdapterType {
    SCSI,
    BLOCKSCSI,
    FCOE,
    FIBRECHANNEL,
    ISCSI,
    SAS,
    RDMA,
    PCIE,
    NVMETCP,
    UNKNOWN;


    public static StorageAdapterType getType(HostBusAdapter hba) {
        if (hba instanceof ParallelScsiHba) {
            return SCSI;
        }
        if (hba instanceof BlockHba) {
            return BLOCKSCSI;
        }
        if (hba instanceof FibreChannelOverEthernetHba) {
            return FCOE;
        }
        if (hba instanceof FibreChannelHba) {
            return FIBRECHANNEL;
        }
        if (hba instanceof InternetScsiHba) {
            return ISCSI;
        }
        if (hba instanceof SerialAttachedHba) {
            return SAS;
        }
        if (hba instanceof RdmaHba) {
            return RDMA;
        }
        if (hba instanceof PcieHba) {
            return PCIE;
        }
        if (hba instanceof TcpHba) {
            return NVMETCP;
        }
        return UNKNOWN;
    }
}

