/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.tools.util;

import com.vmware.vsphere.client.modules.api.util.ModulesApiUtil;

public class VmToolsUtil {
    public static final String GUEST_TOOLS_NA = "guestToolsNA";
    public static final String ONLY = "Only";
    public static final String PIPE = "\\|";
    public static final String GUEST_TOOLS_NOT_RUNNING = "guestToolsNotRunning";
    public static final String GUEST_TOOLS_NOT_INSTALLED = "guestToolsNotInstalled";
    public static final String GUEST_TOOLS_NOT_RUNNING_NOT_INSTALLED = "guestToolsNotRunningNotInstalled";
    public static final String DETAILED_TOOLS_VERSION_STATUS = "detailedToolsVersionStatus";
    public static final String TEXT = ".text";

    public String getVersionStatus(String runningStatus, String versionAndVendor) {
        if (VmToolsUtil.isNullOrEmpty(runningStatus)) {
            return ModulesApiUtil.getString(GUEST_TOOLS_NA);
        }
        if (runningStatus.equals(GUEST_TOOLS_NOT_RUNNING) && (versionAndVendor == null || versionAndVendor.startsWith(GUEST_TOOLS_NOT_INSTALLED))) {
            return ModulesApiUtil.getString(GUEST_TOOLS_NOT_RUNNING_NOT_INSTALLED);
        }
        String localizedDetailedToolsVersion = VmToolsUtil.getLocalizedDetailedToolsVersion(versionAndVendor);
        if (VmToolsUtil.isNullOrEmpty(localizedDetailedToolsVersion)) {
            return ModulesApiUtil.getString(runningStatus + ONLY);
        }
        return ModulesApiUtil.getString(runningStatus, localizedDetailedToolsVersion);
    }

    private static String getLocalizedDetailedToolsVersion(String versionAndVendor) {
        if (VmToolsUtil.isNullOrEmpty(versionAndVendor)) {
            return null;
        }
        String[] toolsVersionDataParts = versionAndVendor.split(PIPE);
        String version = null;
        if (toolsVersionDataParts.length > 0) {
            version = toolsVersionDataParts[0];
        }
        String vendor = null;
        if (toolsVersionDataParts.length > 1) {
            vendor = toolsVersionDataParts[1];
        }
        return VmToolsUtil.localizeDetailedToolsVersionStatus(version, vendor);
    }

    private static String localizeDetailedToolsVersionStatus(String version, String vendor) {
        String result;
        if (VmToolsUtil.isNullOrEmpty(version)) {
            return vendor;
        }
        String localizableVersionStatusKey = version + TEXT;
        String string = result = localizableVersionStatusKey.equals(result = ModulesApiUtil.getString(localizableVersionStatusKey)) ? version : result;
        if (!VmToolsUtil.isNullOrEmpty(vendor)) {
            result = ModulesApiUtil.getString(DETAILED_TOOLS_VERSION_STATUS, vendor, result);
        }
        return result;
    }

    private static boolean isNullOrEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

