/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.spbm.impl;

import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.commonservice.util.QueryServiceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public class PrivilegesPropertyProvider
implements PropertyProviderAdapter {
    private static final String GRANTED_PRIVILEGES = "grantedPrivileges";
    private static final String SPBM_POLICY_PERMISSION_CAPABILITY = "capability.spbmPolicyPermissionSupported";
    private static final String VC_PRIVILEGES_PROPERTY = "vcGrantedPrivileges";
    private static final String IS_SPBM_POLICY_PERMISSION_SUPPORTED_PROPERTY = "isSpbmPolicyPermissionSupported";
    private final QueryService _queryService;

    public PrivilegesPropertyProvider(QueryServiceFactory queryServiceFactory, DataServiceExtensionRegistry registry) {
        this._queryService = queryServiceFactory.getQueryService();
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = VirtualMachine.class.getSimpleName();
        ti.properties = new String[]{VC_PRIVILEGES_PROPERTY, IS_SPBM_POLICY_PERMISSION_SUPPORTED_PROPERTY};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        Validate.notNull((Object)propertyRequest);
        Object[] objects = propertyRequest.objects;
        Set<String> requestedProperties = this.getDistinctRequestedProperties(propertyRequest);
        ResultSet resultSet = new ResultSet();
        ResultItem[] resultItems = new ResultItem[objects.length];
        List<Object> vcPrivileges = new ArrayList();
        if (requestedProperties.contains(VC_PRIVILEGES_PROPERTY)) {
            vcPrivileges = this.getPrivileges(objects);
        }
        List<Object> isSpbmPolicyPermissionSupported = new ArrayList();
        if (requestedProperties.contains(IS_SPBM_POLICY_PERMISSION_SUPPORTED_PROPERTY)) {
            isSpbmPolicyPermissionSupported = this.checkIsSpbmPolicyPermissionSupported(objects);
        }
        for (int i = 0; i < objects.length; ++i) {
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = objects[i];
            ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>();
            if (requestedProperties.contains(VC_PRIVILEGES_PROPERTY)) {
                propertyValues.add(this.createPropValue(VC_PRIVILEGES_PROPERTY, vcPrivileges.get(i), resultItem.resourceObject));
            }
            if (requestedProperties.contains(IS_SPBM_POLICY_PERMISSION_SUPPORTED_PROPERTY)) {
                propertyValues.add(this.createPropValue(IS_SPBM_POLICY_PERMISSION_SUPPORTED_PROPERTY, isSpbmPolicyPermissionSupported.get(i), resultItem.resourceObject));
            }
            resultItem.properties = propertyValues.toArray(new PropertyValue[0]);
            resultItems[i] = resultItem;
        }
        resultSet.items = resultItems;
        return resultSet;
    }

    private Set<String> getDistinctRequestedProperties(PropertyRequestSpec propertyRequest) {
        HashSet<String> requestedProperties = new HashSet<String>();
        for (PropertySpec propSpec : propertyRequest.properties) {
            requestedProperties.addAll(Arrays.asList(propSpec.propertyNames));
        }
        return requestedProperties;
    }

    private PropertyValue createPropValue(String name, Object value, Object provider) {
        PropertyValue propValue = new PropertyValue();
        propValue.propertyName = name;
        propValue.value = value;
        propValue.resourceObject = provider;
        return propValue;
    }

    private List<String[]> getPrivileges(Object[] vms) {
        ManagedObjectReference vcRef;
        ArrayList<String[]> result = new ArrayList<String[]>(vms.length);
        HashMap<ManagedObjectReference, ManagedObjectReference> vmVcs = new HashMap<ManagedObjectReference, ManagedObjectReference>();
        HashSet<ManagedObjectReference> vcRefs = new HashSet<ManagedObjectReference>();
        for (Object vm : vms) {
            ManagedObjectReference vmRef = (ManagedObjectReference)vm;
            vcRef = ManagedObjectUtil.getRootFolder((String)vmRef.getServerGuid());
            vmVcs.put(vmRef, vcRef);
            vcRefs.add(vcRef);
        }
        Map vcsPrivileges = QueryServiceUtil.queryPropertiesForMultipleObjects((QueryService)this._queryService, vcRefs, (String[])new String[]{GRANTED_PRIVILEGES});
        for (Object vm : vms) {
            vcRef = (ManagedObjectReference)vmVcs.get((ManagedObjectReference)vm);
            String[] vmVcPrivileges = (String[])((Map)vcsPrivileges.get(vcRef)).get(GRANTED_PRIVILEGES);
            result.add(vmVcPrivileges);
        }
        return result;
    }

    private List<Boolean> checkIsSpbmPolicyPermissionSupported(Object[] vms) {
        ManagedObjectReference serviceInstanceRef;
        ArrayList<Boolean> result = new ArrayList<Boolean>(vms.length);
        HashMap<ManagedObjectReference, ManagedObjectReference> vmServiceInstances = new HashMap<ManagedObjectReference, ManagedObjectReference>();
        HashSet<ManagedObjectReference> serviceInstances = new HashSet<ManagedObjectReference>();
        for (Object vm : vms) {
            ManagedObjectReference vmRef = (ManagedObjectReference)vm;
            serviceInstanceRef = new ManagedObjectReference(ServiceInstance.class.getSimpleName(), ServiceInstance.class.getSimpleName(), ((ManagedObjectReference)vm).getServerGuid());
            vmServiceInstances.put(vmRef, serviceInstanceRef);
            serviceInstances.add(serviceInstanceRef);
        }
        Map capabilities = QueryServiceUtil.queryPropertiesForMultipleObjects((QueryService)this._queryService, serviceInstances, (String[])new String[]{SPBM_POLICY_PERMISSION_CAPABILITY});
        for (Object vm : vms) {
            serviceInstanceRef = (ManagedObjectReference)vmServiceInstances.get((ManagedObjectReference)vm);
            Boolean isSpbmPolicyPermissionSupported = (Boolean)((Map)capabilities.get(serviceInstanceRef)).get(SPBM_POLICY_PERMISSION_CAPABILITY);
            result.add(isSpbmPolicyPermissionSupported);
        }
        return result;
    }
}

