/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.spbm.util;

import com.vmware.vim.binding.pbm.capability.CapabilityInstance;
import com.vmware.vim.binding.pbm.capability.CapabilityMetadata;
import com.vmware.vim.binding.pbm.capability.ConstraintInstance;
import com.vmware.vim.binding.pbm.capability.PropertyInstance;
import com.vmware.vim.binding.pbm.capability.PropertyMetadata;
import com.vmware.vim.binding.pbm.capability.TypeInfo;
import com.vmware.vim.binding.pbm.capability.types.BuiltinGenericTypesEnum;
import com.vmware.vim.binding.pbm.capability.types.DiscreteSet;
import com.vmware.vim.binding.pbm.capability.types.Range;
import com.vmware.vim.binding.pbm.compliance.ComplianceResult;
import com.vmware.vim.binding.pbm.compliance.PolicyStatus;
import com.vmware.vsphere.client.h5.spbm.data.SpbmComplianceFailure;
import com.vmware.vsphere.client.h5.spbm.util.SpbmStringUtil;
import com.vmware.vsphere.client.spbm.data.NamespaceCapabilityMetadata;
import com.vmware.vsphere.client.spbm.impl.formatters.FormatterUtil;
import com.vmware.vsphere.client.spbm.impl.formatters.VsanCapabilitiesFormatter;
import com.vmware.vsphere.client.spbm.util.MetadataUtil;
import com.vmware.vsphere.client.spbm.util.RuleSetUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComplianceFailureFormatter {
    private static final Log _logger = LogFactory.getLog(ComplianceFailureFormatter.class);

    public static SpbmComplianceFailure[] getComplianceFailures(ComplianceResult complianceResult, Map<String, NamespaceCapabilityMetadata> namespaceCapabilityMetadata) {
        if (complianceResult == null || ArrayUtils.isEmpty((Object[])complianceResult.violatedPolicies) || namespaceCapabilityMetadata == null) {
            return null;
        }
        ArrayList<SpbmComplianceFailure> failures = new ArrayList<SpbmComplianceFailure>();
        for (PolicyStatus policyStatus : complianceResult.violatedPolicies) {
            if (policyStatus.expectedValue == null || policyStatus.expectedValue.constraint == null) continue;
            CapabilityInstance expectedCapability = policyStatus.expectedValue;
            boolean isTagCapability = "http://www.vmware.com/storage/tag".equals(expectedCapability.id.namespace);
            CapabilityMetadata capabilityMetadata = ComplianceFailureFormatter.getCapabilityMetadata(expectedCapability, namespaceCapabilityMetadata);
            if (capabilityMetadata == null && !isTagCapability) {
                _logger.error((Object)String.format("Failed to load capability metadata for %s : %s", expectedCapability.id.namespace, expectedCapability.id.id));
                continue;
            }
            String namespaceTitle = ComplianceFailureFormatter.getNamespaceTitle(capabilityMetadata, namespaceCapabilityMetadata.get(expectedCapability.id.namespace), isTagCapability);
            for (int constraintIndex = 0; constraintIndex < expectedCapability.constraint.length; ++constraintIndex) {
                ConstraintInstance expectedConstraint = expectedCapability.constraint[constraintIndex];
                if (expectedConstraint == null || expectedConstraint.propertyInstance == null) continue;
                for (PropertyInstance expectedProperty : expectedConstraint.propertyInstance) {
                    PropertyMetadata propertyMetadata = null;
                    if (capabilityMetadata != null) {
                        propertyMetadata = MetadataUtil.getPropertyMetadata((PropertyMetadata[])capabilityMetadata.propertyMetadata, (String)expectedProperty.id);
                    }
                    if (propertyMetadata == null && !isTagCapability) continue;
                    PropertyInstance currentProperty = ComplianceFailureFormatter.getPropertyInstanceFromCapabilityInstance(policyStatus.currentValue, constraintIndex, expectedProperty.id);
                    SpbmComplianceFailure failure = new SpbmComplianceFailure();
                    failure.propertyName = ComplianceFailureFormatter.getPropertyName(propertyMetadata, namespaceTitle);
                    failure.expectedValue = ComplianceFailureFormatter.formatPropertyValue(expectedProperty, propertyMetadata, expectedCapability);
                    failure.currentValue = ComplianceFailureFormatter.formatPropertyValue(currentProperty, propertyMetadata, expectedCapability);
                    failures.add(failure);
                }
            }
        }
        if (failures.isEmpty()) {
            return null;
        }
        return failures.toArray(new SpbmComplianceFailure[failures.size()]);
    }

    private static String formatPropertyValue(PropertyInstance propertyInstance, PropertyMetadata propertyMetadata, CapabilityInstance capabilityInstance) {
        boolean isTagCapability = "http://www.vmware.com/storage/tag".equals(capabilityInstance.id.namespace);
        if (propertyInstance == null || propertyMetadata == null && !isTagCapability) {
            return null;
        }
        if (isTagCapability) {
            return ComplianceFailureFormatter.getSetTextValue(FormatterUtil.getTagValues((PropertyInstance)propertyInstance, (PropertyMetadata)propertyMetadata));
        }
        if (VsanCapabilitiesFormatter.isVsanNamespace((String)capabilityInstance.id.namespace) && "cacheReservation".equals(capabilityInstance.id.id)) {
            return FormatterUtil.getVsanCacheReservationPropertyValue((PropertyInstance)propertyInstance);
        }
        if (RuleSetUtil.hasGenericValue((PropertyInstance)propertyInstance, (PropertyMetadata)propertyMetadata)) {
            return ComplianceFailureFormatter.getGenericTextValue(propertyInstance, propertyMetadata);
        }
        TypeInfo typeInfo = propertyMetadata.type;
        DiscreteSet allowedValues = MetadataUtil.tryGetAllowedValueAsSet((PropertyMetadata)propertyMetadata);
        return FormatterUtil.getPropertyValue((Object)propertyInstance.value, (TypeInfo)typeInfo, (DiscreteSet)allowedValues, (boolean)false);
    }

    private static String getGenericTextValue(PropertyInstance propertyInstance, PropertyMetadata propertyMetadata) {
        String genericTypeName = RuleSetUtil.getGenericTypeName((PropertyMetadata)propertyMetadata);
        DiscreteSet allowedValues = MetadataUtil.tryGetAllowedValueAsSet((PropertyMetadata)propertyMetadata);
        if (BuiltinGenericTypesEnum.VMW_RANGE.toString().equals(genericTypeName)) {
            Range range = (Range)propertyInstance.value;
            String formattedMinValue = FormatterUtil.getPropertyValue((Object)range.min, (TypeInfo)propertyMetadata.type, (DiscreteSet)allowedValues, (boolean)false);
            String formattedMaxValue = FormatterUtil.getPropertyValue((Object)range.max, (TypeInfo)propertyMetadata.type, (DiscreteSet)allowedValues, (boolean)false);
            return SpbmStringUtil.getString("vmComplianceFailures.rangeValue", formattedMinValue, formattedMaxValue);
        }
        if (BuiltinGenericTypesEnum.VMW_SET.toString().equals(genericTypeName)) {
            DiscreteSet set = (DiscreteSet)propertyInstance.value;
            return ComplianceFailureFormatter.getSetTextValue(FormatterUtil.getDiscreteSetValues((DiscreteSet)set, (DiscreteSet)allowedValues, (TypeInfo)propertyMetadata.type, (boolean)false));
        }
        return null;
    }

    private static String getSetTextValue(List<String> values) {
        if (values == null || values.isEmpty()) {
            return "";
        }
        return SpbmStringUtil.getString("vmComplianceFailures.setValue", StringUtils.join(values, (String)", "));
    }

    private static PropertyInstance getPropertyInstanceFromCapabilityInstance(CapabilityInstance capabilityInstance, int constraintIndex, String propertyInstanceId) {
        if (capabilityInstance == null || capabilityInstance.constraint == null || constraintIndex >= capabilityInstance.constraint.length || propertyInstanceId == null) {
            return null;
        }
        for (PropertyInstance propInstance : capabilityInstance.constraint[constraintIndex].propertyInstance) {
            if (!propertyInstanceId.equals(propInstance.id)) continue;
            return propInstance;
        }
        return null;
    }

    private static String getNamespaceTitle(CapabilityMetadata capabilityMetadata, NamespaceCapabilityMetadata namespace, boolean isTagCapability) {
        String capabilityLabel;
        String namespaceTitle;
        String string = namespaceTitle = isTagCapability ? SpbmStringUtil.getString("vmComplianceFailures.tagsLabel") : MetadataUtil.getLocalizedNamespaceTitle((NamespaceCapabilityMetadata)namespace);
        if (RuleSetUtil.hasMultipleNestedProperties((CapabilityMetadata)capabilityMetadata) && StringUtils.isNotEmpty((CharSequence)(capabilityLabel = FormatterUtil.getCapabilityLabel((CapabilityMetadata)capabilityMetadata)))) {
            namespaceTitle = ComplianceFailureFormatter.formatPropertyName(namespaceTitle, capabilityLabel);
        }
        return namespaceTitle;
    }

    private static String formatPropertyName(String namespace, String propertyName) {
        if (StringUtils.isEmpty((CharSequence)namespace)) {
            return propertyName;
        }
        return SpbmStringUtil.getString("namespaceAndPropertyFormat", namespace, propertyName);
    }

    private static String getPropertyName(PropertyMetadata propertyMetadata, String namespaceTitle) {
        if (propertyMetadata != null) {
            return ComplianceFailureFormatter.formatPropertyName(namespaceTitle, FormatterUtil.getPropertyMetadataLabel((PropertyMetadata)propertyMetadata));
        }
        return ComplianceFailureFormatter.formatPropertyName(namespaceTitle, SpbmStringUtil.getString("vmComplianceFailures.categoryNA"));
    }

    private static CapabilityMetadata getCapabilityMetadata(CapabilityInstance capabilityInstance, Map<String, NamespaceCapabilityMetadata> namespaces) {
        NamespaceCapabilityMetadata capabilityNamespace = namespaces.get(capabilityInstance.id.namespace);
        if (capabilityNamespace == null) {
            return null;
        }
        return MetadataUtil.getCapabilityMetadata((CapabilityMetadata[])capabilityNamespace.capabilityMetadata, (CapabilityMetadata.UniqueId)capabilityInstance.id);
    }
}

