/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.data.datastore.factory;

import com.vmware.vim.binding.vim.host.DiskPartitionInfo;
import com.vmware.vsphere.client.h5.storage.data.devices.HostStorageDevicePartitionDetailsItem;
import com.vmware.vsphere.client.h5.storage.data.devices.HostStorageDevicePartitionItem;
import com.vmware.vsphere.client.h5.storage.util.internal.PartitionUtil;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostStorageDevicePartitionDetailsItemFactory {
    private static Log _logger = LogFactory.getLog(HostStorageDevicePartitionDetailsItem.class);

    public static HostStorageDevicePartitionDetailsItem newInstance(DiskPartitionInfo info) {
        HostStorageDevicePartitionDetailsItem formattedResult = new HostStorageDevicePartitionDetailsItem();
        if (info.spec == null || info.spec.partition == null) {
            return formattedResult;
        }
        formattedResult.partitionFormat = info.spec.partitionFormat;
        formattedResult.partitions = new ArrayList(info.spec.partition.length);
        for (DiskPartitionInfo.Partition partition : info.spec.partition) {
            DiskPartitionInfo.BlockRange partitionBlockRange = null;
            for (DiskPartitionInfo.BlockRange blockRange : info.layout.partition) {
                if (blockRange.partition == null || partition.partition != blockRange.partition) continue;
                partitionBlockRange = blockRange;
                break;
            }
            if (partitionBlockRange == null) {
                _logger.warn((Object)String.format("Could not find BlockRange %s for partition %d", partitionBlockRange, partition.partition));
                continue;
            }
            HostStorageDevicePartitionItem partitionItem = new HostStorageDevicePartitionItem();
            partitionItem.name = partitionBlockRange.type;
            partitionItem.partitionCapacity = PartitionUtil.getSizeOfBlockRange(partitionBlockRange);
            partitionItem.isLogical = partition.logical;
            formattedResult.partitions.add(partitionItem);
        }
        return formattedResult;
    }
}

