/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatastoreCollectionPropertyProvider {
    private static final String DATASTORE_TYPE_PROPERTY = "summary/type";
    private static final String NFS41_TYPE = "NFS41";
    private static final String NFS3_TYPE = "NFS";
    private static final Log _logger = LogFactory.getLog(DatastoreCollectionPropertyProvider.class);
    private static final Set<String> nfsTypes = new HashSet<String>();
    private QueryService _queryService;

    public DatastoreCollectionPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="Datastore/areAllDatastoresNfs")
    public List<Boolean> getAreAllDatastoresNfs(Collection<ManagedObjectReference> dsRefs) {
        if (dsRefs == null || dsRefs.isEmpty()) {
            return Collections.emptyList();
        }
        if (dsRefs.size() == 1) {
            return Collections.singletonList(Boolean.TRUE);
        }
        try {
            ResourceItem resourceItem;
            ResultSet resultSet = this._queryService.select(new String[]{DATASTORE_TYPE_PROPERTY}).from(new String[]{Datastore.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, dsRefs).fetch();
            if (resultSet == null || resultSet.getItems() == null || resultSet.getItems().isEmpty()) {
                _logger.error((Object)String.format("Data-service did not return any response for '%s'.", DATASTORE_TYPE_PROPERTY));
                return DatastoreCollectionPropertyProvider.booleanListResult(Boolean.FALSE, dsRefs.size());
            }
            boolean areAllNfs = true;
            List resourceItems = resultSet.getItems();
            Iterator iterator = resourceItems.iterator();
            while (iterator.hasNext() && (areAllNfs = nfsTypes.contains((resourceItem = (ResourceItem)iterator.next()).get(DATASTORE_TYPE_PROPERTY).toString().toLowerCase()))) {
            }
            return DatastoreCollectionPropertyProvider.booleanListResult(areAllNfs, resourceItems.size());
        }
        catch (Exception e) {
            _logger.error((Object)e);
            return DatastoreCollectionPropertyProvider.booleanListResult(Boolean.FALSE, dsRefs.size());
        }
    }

    private static List<Boolean> booleanListResult(Boolean b, int size) {
        return new ArrayList<Boolean>(Collections.nCopies(size, b));
    }

    static {
        nfsTypes.add(NFS3_TYPE.toLowerCase());
        nfsTypes.add(NFS41_TYPE.toLowerCase());
    }
}

