/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.FileSystemVolumeInfo;
import com.vmware.vim.binding.vim.host.MountInfo;
import com.vmware.vim.binding.vim.host.NasVolume;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vsphere.client.h5.storage.data.datastore.DatastoreConnectivityData;
import com.vmware.vsphere.client.h5.storage.data.datastore.HostConnectivityData;
import com.vmware.vsphere.client.h5.storage.data.datastore.NfsVvolDatastoreConnectivityItem;
import com.vmware.vsphere.client.h5.storage.data.datastore.VmfsDatastoreConnectivityItem;
import com.vmware.vsphere.client.h5.storage.data.datastore.VmknicBindingCapabilityData;
import com.vmware.vsphere.client.h5.storage.util.H5StorageUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DatastoreConnectivityPropertyProvider
implements PropertyProviderBean {
    private final QueryBindingService _queryBindingService;

    public DatastoreConnectivityPropertyProvider(QueryBindingServiceFactory queryBindingServiceFactory) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="connectivityWithHost", property="vmfsDatastoreConnectivity")
    public VmfsDatastoreConnectivityItem[] getVmfsDatastoreConnectivityWithHosts(ManagedObjectReference datastoreRef) {
        DatastoreConnectivityData dataserviceResponse = (DatastoreConnectivityData)this._queryBindingService.prepare(DatastoreConnectivityData.class).fetch((Object)datastoreRef);
        if (dataserviceResponse == null || dataserviceResponse.hostMounts == null || dataserviceResponse.hostsData == null) {
            return new VmfsDatastoreConnectivityItem[0];
        }
        ArrayList<VmfsDatastoreConnectivityItem> result = new ArrayList<VmfsDatastoreConnectivityItem>();
        Map<ManagedObjectReference, Datastore.HostMount> hostMountIndex = DatastoreConnectivityPropertyProvider.buildHostMountIndex(dataserviceResponse.hostMounts);
        for (HostConnectivityData connectivityData : dataserviceResponse.hostsData) {
            Datastore.HostMount hostMount = hostMountIndex.get(connectivityData.provider);
            if (hostMount == null) continue;
            VmfsDatastoreConnectivityItem currentItem = new VmfsDatastoreConnectivityItem();
            String hostFormattedName = H5StorageUtil.appendIssue((String)connectivityData.name, (String)H5StorageUtil.getHostStateIssue((HostSystem.ConnectionState)connectivityData.connectionState, (HostSystem.PowerState)connectivityData.powerState));
            currentItem.init(hostFormattedName, hostMount);
            currentItem.isMounted = hostMount.mountInfo.mounted == null || Boolean.TRUE.equals(hostMount.mountInfo.mounted);
            currentItem.isHostConnected = HostSystem.ConnectionState.connected == connectivityData.connectionState;
            result.add(currentItem);
        }
        return result.toArray(new VmfsDatastoreConnectivityItem[result.size()]);
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="connectivityWithHost", property="nfsVvolDatastoreConnectivity")
    public NfsVvolDatastoreConnectivityItem[] getNfsVvolDatastoreConnectivity(ManagedObjectReference datastoreRef) {
        DatastoreConnectivityData dataserviceResponse = (DatastoreConnectivityData)this._queryBindingService.prepare(DatastoreConnectivityData.class).fetch((Object)datastoreRef);
        if (dataserviceResponse == null || dataserviceResponse.hostMounts == null || dataserviceResponse.hostsData == null || dataserviceResponse.vmknicBindingCapabilityData == null) {
            return new NfsVvolDatastoreConnectivityItem[0];
        }
        ArrayList<NfsVvolDatastoreConnectivityItem> result = new ArrayList<NfsVvolDatastoreConnectivityItem>();
        Map<ManagedObjectReference, Datastore.HostMount> hostMountIndex = DatastoreConnectivityPropertyProvider.buildHostMountIndex(dataserviceResponse.hostMounts);
        for (HostConnectivityData connectivityData : dataserviceResponse.hostsData) {
            Datastore.HostMount hostMount = hostMountIndex.get(connectivityData.provider);
            if (hostMount == null) continue;
            NfsVvolDatastoreConnectivityItem currentItem = new NfsVvolDatastoreConnectivityItem();
            String hostFormattedName = H5StorageUtil.appendIssue((String)connectivityData.name, (String)H5StorageUtil.getHostStateIssue((HostSystem.ConnectionState)connectivityData.connectionState, (HostSystem.PowerState)connectivityData.powerState));
            currentItem.init(hostFormattedName, hostMount);
            currentItem.accessMode = H5StorageUtil.formatAccessMode((String)hostMount.mountInfo.accessMode);
            NasVolume nasVolume = H5StorageUtil.getNasVolumeByMountInfo((FileSystemVolumeInfo)connectivityData.fileSystemVolumeInfo, (MountInfo)hostMount.mountInfo);
            currentItem.kerberosAuthentication = H5StorageUtil.formatKerberosAuthentication((NasVolume)nasVolume);
            for (VmknicBindingCapabilityData capabilityData : dataserviceResponse.vmknicBindingCapabilityData) {
                if (!capabilityData.hostName.equals(connectivityData.name)) continue;
                currentItem.isVmknicBindingSupported = capabilityData.isVmknicBindingSupported;
                if (!Boolean.TRUE.equals(currentItem.isVmknicBindingSupported)) continue;
                currentItem.vmknicName = hostMount.mountInfo.vmknicName;
            }
            result.add(currentItem);
        }
        return result.toArray(new NfsVvolDatastoreConnectivityItem[result.size()]);
    }

    private static Map<ManagedObjectReference, Datastore.HostMount> buildHostMountIndex(Datastore.HostMount[] hostMounts) {
        HashMap<ManagedObjectReference, Datastore.HostMount> map = new HashMap<ManagedObjectReference, Datastore.HostMount>();
        for (Datastore.HostMount mountInfo : hostMounts) {
            map.put(mountInfo.key, mountInfo);
        }
        return map;
    }
}

