/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.cis.data.model.DerivedProperty;
import com.vmware.cis.data.model.SourceProperty;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.host.VmfsDatastoreInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.h5.storage.util.H5StorageUtil;

public class DatastoreExtendedDataModel {
    @DerivedProperty(value="Datastore/isUnmountVmfsDatastoreActionAvailable")
    public static boolean isUnmountVmfsDatastoreActionAvailable(@SourceProperty(value="Datastore/hostMount") Datastore.HostMount[] hostMounts, @SourceProperty(value="Datastore/info") Datastore.Info info) {
        return H5StorageUtil.checkMountUnmountVmfsDatastoreActionAvailability((Boolean)Boolean.TRUE, (Datastore.Info)info, (Datastore.HostMount[])hostMounts);
    }

    @DerivedProperty(value="Datastore/isMountVmfsDatastoreActionAvailable")
    public static boolean isMountVmfsDatastoreActionAvailable(@SourceProperty(value="Datastore/hostMount") Datastore.HostMount[] hostMounts, @SourceProperty(value="Datastore/info") Datastore.Info info) {
        return H5StorageUtil.checkMountUnmountVmfsDatastoreActionAvailability((Boolean)Boolean.FALSE, (Datastore.Info)info, (Datastore.HostMount[])hostMounts);
    }

    @DerivedProperty(value="Datastore/isSpaceReclamationEnabled")
    public static boolean isSpaceReclamationEnabled(@SourceProperty(value="Datastore/info") Datastore.Info info, @SourceProperty(value="Datastore/connectedHost") ManagedObjectReference connectedHost, @SourceProperty(value="Datastore/summary/type") String dsType) {
        if (!(info instanceof VmfsDatastoreInfo) || H5StorageUtil.isVsanDirectDatastore((String)dsType)) {
            return false;
        }
        VmfsDatastoreInfo vmfsDatastoreInfo = (VmfsDatastoreInfo)info;
        return vmfsDatastoreInfo.vmfs != null && vmfsDatastoreInfo.vmfs.majorVersion >= 6 && connectedHost != null;
    }

    @DerivedProperty(value="Datastore/hasConnectedHostWithConfigPrivilege")
    public static boolean hasConnectedHostWithConfigPrivilege(@SourceProperty(value="Datastore/connectedHost") ManagedObjectReference connectedHost) {
        return connectedHost != null;
    }

    @DerivedProperty(value="Datastore/enterMaintenanceModeAvailable")
    public static boolean getEnterMaintenanceModeAvailable(@SourceProperty(value="Datastore/parentPod") ManagedObjectReference parent, @SourceProperty(value="Datastore/summary/maintenanceMode") String maintenanceMode) {
        return parent != null && StoragePod.class.getSimpleName().equals(parent.getType()) && Datastore.Summary.MaintenanceModeState.normal.name().equals(maintenanceMode);
    }
}

