/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.google.common.collect.Sets;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.sms.storage.StorageContainer;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.cluster.DasConfigInfo;
import com.vmware.vim.binding.vim.host.DatastoreSystem;
import com.vmware.vim.binding.vim.host.DiskPartitionInfo;
import com.vmware.vim.binding.vim.host.FileSystemVolume;
import com.vmware.vim.binding.vim.host.NasDatastoreInfo;
import com.vmware.vim.binding.vim.host.NasVolume;
import com.vmware.vim.binding.vim.host.VmfsDatastoreInfo;
import com.vmware.vim.binding.vim.host.VmfsDatastoreOption;
import com.vmware.vim.binding.vim.host.VmfsVolume;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.model.PropertyValueData;
import com.vmware.vsphere.client.commonservice.util.QueryExecutorUtil;
import com.vmware.vsphere.client.commonservice.util.QueryServiceUtil;
import com.vmware.vsphere.client.h5.storage.data.cluster.ClusterInfoItem;
import com.vmware.vsphere.client.h5.storage.data.cluster.HeartbeatRequirement;
import com.vmware.vsphere.client.h5.storage.data.datastore.NfsNameAndConfigurationValidationResult;
import com.vmware.vsphere.client.h5.storage.data.datastore.StorageContainerInfoItem;
import com.vmware.vsphere.client.h5.storage.data.datastore.VmfsBlockSizeOptionItem;
import com.vmware.vsphere.client.h5.storage.data.datastore.VmfsDatastoreOptionData;
import com.vmware.vsphere.client.h5.storage.data.datastore.VmfsExtentMultipathingInfo;
import com.vmware.vsphere.client.h5.storage.data.datastore.factory.VmfsDatastoreOptionDataFactory;
import com.vmware.vsphere.client.h5.storage.data.host.HostData;
import com.vmware.vsphere.client.h5.storage.model.IncreaseDatastoreDetailsData;
import com.vmware.vsphere.client.h5.storage.model.vmdk.VirtualMachinesInVmdkClusterInfo;
import com.vmware.vsphere.client.h5.storage.model.vmdk.VmdkVirtualMachineInfo;
import com.vmware.vsphere.client.h5.storage.spec.HeartbeatDatastoreSpec;
import com.vmware.vsphere.client.h5.storage.spec.NfsDatastoreConfigurationSpec;
import com.vmware.vsphere.client.h5.storage.spec.VmfsDatastoreCreateOptionQuerySpec;
import com.vmware.vsphere.client.h5.storage.util.H5StorageUtil;
import com.vmware.vsphere.client.h5.storage.util.internal.StorageStringUtil;
import com.vmware.vsphere.client.sms.StorageContainerInfo;
import com.vmware.vsphere.client.storage.DatastoreIncreaseOptionsQuerySpec;
import com.vmware.vsphere.client.storage.DeviceMultipathingInfo;
import com.vmware.vsphere.client.storage.util.StorageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatastorePropertyProvider
implements PropertyProviderBean {
    private static final String DS_MOUNTED_HOST_KEYS_PROP = "hostKey";
    private static final String HOST_DATASTORE_SYSTEM = "datastoreSystem";
    private static final String DISK_PARTITION_INFO = "diskPartitionInfo";
    private static final String VMFS_CONFIG_OPTIONS = "vmfsConfigOption";
    private static final String DATACENTER_RELATION = "dc";
    private static final String DATASTORE_RELATION = "datastore";
    private static final String NAME_PROPERTY = "name";
    private static final String DATASTORE_INFO_PROPERTY = "info";
    private static final String DATASTORE_TYPE_PROPERTY = "summary.type";
    private static final String EXTENTS_MULTIPATHING_INFO = "extentsMultipathingInfo";
    private static final String LOCAL_DATASTORE_PROP = "info.vmfs.local";
    private static final String CONFIGURATION_DAS_CONFIG = "configuration/dasConfig";
    private static final String STORAGE_CONTAINERS_INFO = "storageContainersInfo";
    private static final int VMFS_VERSION_6 = 6;
    private static final String STORAGE_AVAILABLE_HOSTS_FOR_CREATE_DATASTORE = "storage:availableHostsForCreateDatastore";
    private static final String HOST_MOUNT_PROPERTY = "hostMount";
    private static final String VM_NAME_PROPERTY = "name";
    private static final String CLUSTERED_VMDK_VMS_PROPERTY = "clusteredVmdkEnabledPoweredOnVMs";
    private QueryExecutor _queryExecutor;
    private QuerySpecBuilder _querySpecBuilder;
    private final QueryService _queryService;
    private static final Log _logger = LogFactory.getLog(DatastorePropertyProvider.class);

    public DatastorePropertyProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, QueryServiceFactory queryServiceFactory) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
        this._queryService = queryServiceFactory.getQueryService();
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="datastore", property="vmfsDatastoreCreateOptionsData")
    public VmfsDatastoreOptionData getVmfsDatastoreCreateOptionsData(ManagedObjectReference hostRef, VmfsDatastoreCreateOptionQuerySpec spec) throws Exception {
        Map results;
        VmfsVolume.ConfigOption[] configOptions;
        Map<String, Object> hostProperties = this.getDatastoreSystemAndPartitionInfo(hostRef, spec.devicePath);
        ManagedObjectReference datastoreSystemMor = (ManagedObjectReference)hostProperties.get(HOST_DATASTORE_SYSTEM);
        DatastoreSystem datastoreSystem = (DatastoreSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)datastoreSystemMor);
        DiskPartitionInfo diskPartitionInfo = (DiskPartitionInfo)hostProperties.get(DISK_PARTITION_INFO);
        if (datastoreSystem == null || diskPartitionInfo == null) {
            _logger.error((Object)"Failed to retrieve host's datastoreSystem/diskPartitionInfo");
            throw new IllegalArgumentException(StorageStringUtil.getString("error.failedToRetrieveHostInfo"));
        }
        VmfsDatastoreOption[] options = datastoreSystem.queryVmfsDatastoreCreateOptions(spec.devicePath, Integer.valueOf(spec.vmfsMajorVersion));
        VmfsDatastoreOptionData result = VmfsDatastoreOptionDataFactory.newInstance(options, diskPartitionInfo);
        if (spec.vmfsMajorVersion == 6 && (configOptions = (VmfsVolume.ConfigOption[])(results = QueryExecutorUtil.requestProperties((QueryExecutor)this._queryExecutor, (Object)hostRef, (String[])new String[]{VMFS_CONFIG_OPTIONS})).get(VMFS_CONFIG_OPTIONS)) != null) {
            result.blockSizeOptions = VmfsBlockSizeOptionItem.getBlockSizeOptions((VmfsVolume.ConfigOption[])configOptions);
        }
        return result;
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastore", property="isForceMountedVmfsDatastore")
    public boolean getIsForceMountedVmfsDatastore(ManagedObjectReference dsRef) throws Exception {
        Datastore.Info dsInfo = (Datastore.Info)QueryServiceUtil.queryProperty((QueryService)this._queryService, (ManagedObjectReference)dsRef, (String)DATASTORE_INFO_PROPERTY);
        return StorageUtil.isForceMountedVMFSDatastore((Datastore.Info)dsInfo);
    }

    @ModelMetadata(type={"HostSystem", "Datacenter", "Folder", "ClusterComputeResource"}, propertyNamespace="datastore", property="datastoreInfoByDatastoreName")
    public Datastore.Info[] getDatastoreInfoByDatastoreName(ManagedObjectReference moRef, String datastoreName) throws Exception {
        Object dcConstraint = ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, Datacenter.class) ? this._querySpecBuilder.createObjectIdentityConstraint((Object)moRef) : this._querySpecBuilder.createConstraintForRelationship((Object)moRef, DATACENTER_RELATION, Datacenter.class.getSimpleName());
        RelationalConstraint datastoresInDcConstraint = this._querySpecBuilder.createRelationalConstraint(DATASTORE_RELATION, (Constraint)dcConstraint, Boolean.valueOf(true), Datastore.class.getSimpleName());
        PropertyConstraint datastoreNameConstraint = this._querySpecBuilder.createPropertyConstraint(Datastore.class.getSimpleName(), "name", Comparator.EQUALS, (Object)datastoreName);
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec(this._querySpecBuilder.combineIntoSingleConstraint(new Constraint[]{datastoresInDcConstraint, datastoreNameConstraint}, Conjoiner.AND), new String[]{DATASTORE_INFO_PROPERTY});
        com.vmware.vise.data.query.ResultSet resultSet = this._queryExecutor.getData(querySpec);
        ArrayList<Datastore.Info> datastoreInfos = new ArrayList<Datastore.Info>();
        if (resultSet != null && resultSet.items != null) {
            for (ResultItem resultItem : resultSet.items) {
                if (resultItem.properties == null) continue;
                for (PropertyValue propValue : resultItem.properties) {
                    if (!DATASTORE_INFO_PROPERTY.equals(propValue.propertyName)) continue;
                    datastoreInfos.add((Datastore.Info)propValue.value);
                }
            }
        }
        return datastoreInfos.toArray(new Datastore.Info[datastoreInfos.size()]);
    }

    @ModelMetadata(type={"HostSystem", "Datacenter", "Folder", "ClusterComputeResource"}, propertyNamespace="datastore", property="validateNfsNameAndConfiguration")
    public NfsNameAndConfigurationValidationResult getValidateNfsNameAndConfiguration(ManagedObjectReference moRef, NfsDatastoreConfigurationSpec spec) throws Exception {
        boolean emptyDatastoreConfiguration = StringUtils.isEmpty((CharSequence)spec.folderName) || ArrayUtils.isEmpty((Object[])spec.serverNames) || StringUtils.isEmpty((CharSequence)spec.serverNames[0]);
        boolean emptyDatastoreName = StringUtils.isEmpty((CharSequence)spec.datastoreName);
        if (emptyDatastoreName || emptyDatastoreConfiguration) {
            _logger.error((Object)"Invalid NfsDatastoreConfigurationSpec: empty datastore name, folder name, and server name.");
            throw new IllegalArgumentException("Invalid NfsDatastoreConfigurationSpec");
        }
        QuerySpec querySpec = this.buildValidationNfsQuerySpec(moRef);
        com.vmware.vise.data.query.ResultSet resultSet = this._queryExecutor.getData(querySpec);
        HashMap<ManagedObjectReference, Datastore.Info> dsInfos = new HashMap<ManagedObjectReference, Datastore.Info>();
        if (resultSet != null && !ArrayUtils.isEmpty((Object[])resultSet.items)) {
            for (ResultItem resultItem : resultSet.items) {
                Map mapProperties = QueryExecutorUtil.mapPropertyNamesToValues((PropertyValue[])resultItem.properties);
                dsInfos.put((ManagedObjectReference)resultItem.resourceObject, (Datastore.Info)mapProperties.get(DATASTORE_INFO_PROPERTY));
            }
        }
        return this.getValidationNfsNameAndConfigurationError(spec, dsInfos, moRef);
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastore", property="isStorageIoControlActionEnabled")
    public Boolean getIsStorageIoControlActionEnabled(ManagedObjectReference dsRef) {
        try {
            ResultSet resultSet = this._queryService.select(new String[]{"capability/storageIORMSupported", "summary/accessible", "storageIoControlPriv", "grantedPrivileges"}).from(new String[]{Datastore.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dsRef).fetch();
            ResourceItem dsResourceItem = (ResourceItem)resultSet.getItems().get(0);
            Boolean isIormSupported = (Boolean)dsResourceItem.get("capability/storageIORMSupported");
            Boolean isAccessible = (Boolean)dsResourceItem.get("summary/accessible");
            String[] storageIoControlPrivileges = (String[])dsResourceItem.get("storageIoControlPriv");
            Object[] grantedPrivileges = (String[])dsResourceItem.get("grantedPrivileges");
            TreeSet allGrantedPrivileges = Sets.newTreeSet((Iterable)Sets.newHashSet((Object[])grantedPrivileges));
            boolean isStorageIoControlPrivilegeGranted = true;
            if (storageIoControlPrivileges != null) {
                for (String privilege : storageIoControlPrivileges) {
                    isStorageIoControlPrivilegeGranted &= allGrantedPrivileges.contains(privilege);
                }
            } else {
                isStorageIoControlPrivilegeGranted = allGrantedPrivileges.contains("Datastore.Config");
            }
            return isStorageIoControlPrivilegeGranted && isIormSupported != false && isAccessible != false;
        }
        catch (Exception e) {
            _logger.error((Object)"Cannot compute 'datastore:isStorageIoControlActionEnabled'.", (Throwable)e);
            return true;
        }
    }

    private NfsNameAndConfigurationValidationResult getValidationNfsNameAndConfigurationError(NfsDatastoreConfigurationSpec spec, Map<ManagedObjectReference, Datastore.Info> dsInfos, ManagedObjectReference moRef) {
        if (dsInfos.isEmpty()) {
            return NfsNameAndConfigurationValidationResult.newInstanceValidationOk();
        }
        for (Map.Entry<ManagedObjectReference, Datastore.Info> dsInfoEntry : dsInfos.entrySet()) {
            Datastore.Info dsInfo = dsInfoEntry.getValue();
            if (dsInfo == null) continue;
            boolean isSameDatastoreName = dsInfo.getName().equals(spec.datastoreName);
            if (!(dsInfo instanceof NasDatastoreInfo)) {
                if (!isSameDatastoreName) continue;
                return NfsNameAndConfigurationValidationResult.newInstanceValidationError((String)StorageStringUtil.getString("validateNfsNameAndConfiguration.duplicateNameDifferentType"));
            }
            NasDatastoreInfo nasInfo = (NasDatastoreInfo)dsInfo;
            if (!nasInfo.nas.type.equalsIgnoreCase(spec.type) && isSameDatastoreName) {
                return NfsNameAndConfigurationValidationResult.newInstanceValidationError((String)StorageStringUtil.getString("validateNfsNameAndConfiguration.duplicateNameDifferentType"));
            }
            boolean isSameDatastoreConfiguration = this.isSameDatastoreConfiguration(spec, nasInfo);
            if (isSameDatastoreName && isSameDatastoreConfiguration) {
                Object[] dsHostMount;
                if (ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, HostSystem.class) && ArrayUtils.contains((Object[])(dsHostMount = (ManagedObjectReference[])QueryServiceUtil.queryProperty((QueryService)this._queryService, (ManagedObjectReference)dsInfoEntry.getKey(), (String)DS_MOUNTED_HOST_KEYS_PROP)), (Object)moRef)) {
                    return NfsNameAndConfigurationValidationResult.newInstanceExistingDatastore((ManagedObjectReference)dsInfoEntry.getKey(), (String)StorageStringUtil.getString("validateNfsNameAndConfiguration.datastoreAlreadyMountedToHost", dsInfo.getName()));
                }
                return NfsNameAndConfigurationValidationResult.newInstanceExistingDatastore((ManagedObjectReference)dsInfoEntry.getKey());
            }
            if (isSameDatastoreName) {
                return NfsNameAndConfigurationValidationResult.newInstanceValidationError((String)StorageStringUtil.getString("validateNfsNameAndConfiguration.duplicateNameDifferentSettings"));
            }
            if (!isSameDatastoreConfiguration) continue;
            return NfsNameAndConfigurationValidationResult.newInstanceValidationError((String)StorageStringUtil.getString("validateNfsNameAndConfiguration.differentNameSameSettings", dsInfo.getName()));
        }
        return NfsNameAndConfigurationValidationResult.newInstanceValidationOk();
    }

    private boolean isSameDatastoreConfiguration(NfsDatastoreConfigurationSpec spec, NasDatastoreInfo nasInfo) {
        if (!nasInfo.nas.remotePath.equals(spec.folderName)) {
            return false;
        }
        HashSet<String> specServers = new HashSet<String>();
        for (String server : spec.serverNames) {
            specServers.add(server);
        }
        HashSet<String> dsServers = new HashSet<String>();
        if (nasInfo.nas.remoteHostNames != null) {
            for (String server : nasInfo.nas.remoteHostNames) {
                dsServers.add(server);
            }
        } else {
            dsServers.add(nasInfo.nas.remoteHost);
        }
        return dsServers.equals(specServers);
    }

    private QuerySpec buildValidationNfsQuerySpec(ManagedObjectReference moRef) {
        Object dcConstraint = ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, Datacenter.class) ? this._querySpecBuilder.createObjectIdentityConstraint((Object)moRef) : this._querySpecBuilder.createConstraintForRelationship((Object)moRef, DATACENTER_RELATION, Datacenter.class.getSimpleName());
        RelationalConstraint datastoresInDcConstraint = this._querySpecBuilder.createRelationalConstraint(DATASTORE_RELATION, (Constraint)dcConstraint, Boolean.valueOf(true), Datastore.class.getSimpleName());
        return this._querySpecBuilder.buildQuerySpec((Constraint)datastoresInDcConstraint, new String[]{DATASTORE_INFO_PROPERTY});
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastore", property="datastoreIncreaseOptions")
    public VmfsDatastoreOptionData getVmfsDatastoreIncreaseOptions(ManagedObjectReference datastoreRef, DatastoreIncreaseOptionsQuerySpec spec) throws Exception {
        String INCREASE_OPTION_PROPERTY = "vmfsDatastoreIncreaseOptions";
        HashMap<String, Object> propertyParams = new HashMap<String, Object>();
        propertyParams.put(INCREASE_OPTION_PROPERTY, spec);
        Map result = QueryExecutorUtil.requestPropertiesWithParams((QueryExecutor)this._queryExecutor, (QuerySpecBuilder)this._querySpecBuilder, (Object)datastoreRef, (String[])new String[]{INCREASE_OPTION_PROPERTY}, propertyParams);
        VmfsDatastoreOption[] options = (VmfsDatastoreOption[])result.get(INCREASE_OPTION_PROPERTY);
        propertyParams.clear();
        propertyParams.put(DISK_PARTITION_INFO, spec.scsiDiskInfo.disk.devicePath);
        result = QueryExecutorUtil.requestPropertiesWithParams((QueryExecutor)this._queryExecutor, (QuerySpecBuilder)this._querySpecBuilder, (Object)spec.host, (String[])new String[]{DISK_PARTITION_INFO}, propertyParams);
        DiskPartitionInfo info = (DiskPartitionInfo)result.get(DISK_PARTITION_INFO);
        return VmfsDatastoreOptionDataFactory.newInstance(options, info);
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastore", property="increaseDatastoreDetailsData")
    public IncreaseDatastoreDetailsData getIncreaseDatastoreDetailsData(ManagedObjectReference dsRef) throws Exception {
        Map queryResult = QueryExecutorUtil.requestProperties((QueryExecutor)this._queryExecutor, (Object)dsRef, (String[])new String[]{DATASTORE_INFO_PROPERTY});
        Datastore.Info dsInfo = (Datastore.Info)queryResult.get(DATASTORE_INFO_PROPERTY);
        if (dsInfo == null || !(dsInfo instanceof VmfsDatastoreInfo)) {
            throw new IllegalArgumentException(String.format("Cannot retrieve vmfs data for datastore %s", dsRef));
        }
        return new IncreaseDatastoreDetailsData((VmfsDatastoreInfo)dsInfo);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="datastore", property="vmfsExtentsMultipathingInfo")
    public VmfsExtentMultipathingInfo[] getVmfsExtentsMultipathingInfo(ManagedObjectReference hostRef, ManagedObjectReference dsRef) throws Exception {
        DeviceMultipathingInfo[] deviceMultipathingInfos = (DeviceMultipathingInfo[])QueryExecutorUtil.requestPropertyWithParam((QueryExecutor)this._queryExecutor, (QuerySpecBuilder)this._querySpecBuilder, (Object)hostRef, (String)EXTENTS_MULTIPATHING_INFO, (Object)dsRef);
        if (deviceMultipathingInfos == null) {
            return new VmfsExtentMultipathingInfo[0];
        }
        ArrayList<VmfsExtentMultipathingInfo> result = new ArrayList<VmfsExtentMultipathingInfo>();
        for (DeviceMultipathingInfo deviceMultipathingInfo : deviceMultipathingInfos) {
            if (deviceMultipathingInfo == null) continue;
            result.add(VmfsExtentMultipathingInfo.newInstance((DeviceMultipathingInfo)deviceMultipathingInfo));
        }
        return result.toArray(new VmfsExtentMultipathingInfo[result.size()]);
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastore", property="nfsDeviceBackingData")
    public PropertyValueData[] getNfsDeviceBackingData(ManagedObjectReference dsRef) throws Exception {
        NasVolume nasDsInfo;
        Datastore.Info dsInfo = (Datastore.Info)this._queryExecutor.getProperty((Object)dsRef, DATASTORE_INFO_PROPERTY);
        if (dsInfo instanceof NasDatastoreInfo && (nasDsInfo = ((NasDatastoreInfo)dsInfo).getNas()) != null) {
            PropertyValueData[] result = new PropertyValueData[]{"NFS41".equals(nasDsInfo.type) ? PropertyValueData.newInstance((String)StorageStringUtil.getString("datastore.manage.deviceBacking.nfs.serverPluralColumnHeader"), (String)StringUtils.join((Object[])nasDsInfo.getRemoteHostNames(), (String)"\n")) : PropertyValueData.newInstance((String)StorageStringUtil.getString("datastore.manage.deviceBacking.nfs.serverColumnHeader"), (String)nasDsInfo.remoteHost), PropertyValueData.newInstance((String)StorageStringUtil.getString("datastore.manage.deviceBacking.nfs.folderColumnHeader"), (String)nasDsInfo.remotePath)};
            return result;
        }
        return new PropertyValueData[0];
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastore", property="haHeartbeatAffectedClusters")
    public ClusterInfoItem[] getHaHeartbeatAffectedClusters(ManagedObjectReference dsRef, HeartbeatDatastoreSpec heartbeatDatastoreSpec) throws Exception {
        List<ManagedObjectReference> hostRefsList;
        ArrayList<ClusterInfoItem> affectedClusters = new ArrayList<ClusterInfoItem>();
        ManagedObjectReference[] hostRefs = heartbeatDatastoreSpec.hostsToRemove;
        String[] dsPropertyNames = new String[]{LOCAL_DATASTORE_PROP, DATASTORE_TYPE_PROPERTY};
        ResultSet currentDsResultSet = this._queryService.select(dsPropertyNames).from(new String[]{Datastore.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dsRef).fetch();
        ResourceItem currentDsProperties = (ResourceItem)currentDsResultSet.getItems().get(0);
        String currentDsType = ((String)currentDsProperties.get(DATASTORE_TYPE_PROPERTY)).toLowerCase();
        Boolean isLocal = false;
        if (FileSystemVolume.FileSystemType.VMFS.toString().toLowerCase().equals(currentDsType)) {
            isLocal = (Boolean)currentDsProperties.get(LOCAL_DATASTORE_PROP);
        }
        if (isLocal != null && isLocal.booleanValue()) {
            return affectedClusters.toArray(new ClusterInfoItem[affectedClusters.size()]);
        }
        String[] clusterPropertyValues = new String[]{"name", CONFIGURATION_DAS_CONFIG};
        ResultSet clusterPropertiesResultSet = this._queryService.select(clusterPropertyValues).from(new String[]{ClusterComputeResource.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate(DATASTORE_RELATION, PropertyPredicate.ComparisonOperator.EQUAL, (Object)dsRef)}).fetch();
        List<ManagedObjectReference> clusterRefs = DatastorePropertyProvider.filterClustersWithDisabledHa(clusterPropertiesResultSet);
        if (clusterRefs.size() == 0) {
            return affectedClusters.toArray(new ClusterInfoItem[affectedClusters.size()]);
        }
        Map<ManagedObjectReference, List<ManagedObjectReference>> clusterHostsForCurrentDs = this.getClusterHostsForDs(this._queryService, dsRef, clusterRefs);
        if ((clusterRefs = DatastorePropertyProvider.filterClustersWithHaDsRemaining(clusterHostsForCurrentDs, hostRefsList = Arrays.asList(hostRefs))).size() == 0) {
            return affectedClusters.toArray(new ClusterInfoItem[affectedClusters.size()]);
        }
        HashMap<ManagedObjectReference, ResourceItem> clusterProps = new HashMap<ManagedObjectReference, ResourceItem>();
        for (ResourceItem clusterItem : clusterPropertiesResultSet.getItems()) {
            if (!clusterRefs.contains(clusterItem.getKey())) continue;
            clusterProps.put((ManagedObjectReference)clusterItem.getKey(), clusterItem);
        }
        ArrayList<HeartbeatRequirement> clustersHeartbeatReqirements = new ArrayList<HeartbeatRequirement>();
        DatastorePropertyProvider.filterClustersWithExplicitHearthbeatDs(clusterProps, clustersHeartbeatReqirements);
        if (clusterProps.size() != 0) {
            DatastorePropertyProvider.filterClustersWithAutoHearthbeatDs(this._queryService, clusterProps, clustersHeartbeatReqirements);
        }
        for (HeartbeatRequirement req : clustersHeartbeatReqirements) {
            if (!req.isHeartbeatAffected(dsRef)) continue;
            ClusterInfoItem clusterInfoItem = new ClusterInfoItem();
            clusterInfoItem.name = req.clusterName;
            affectedClusters.add(clusterInfoItem);
        }
        return affectedClusters.toArray(new ClusterInfoItem[affectedClusters.size()]);
    }

    @ModelMetadata(type={"Folder", "Datacenter", "ClusterComputeResource", "HostSystem"}, propertyNamespace="datastore", property="filteredStorageContainerInfos")
    public StorageContainerInfoItem[] getFilteredStorageContainerInfos(ManagedObjectReference moRef) {
        Object[] containers = (StorageContainerInfo[])QueryServiceUtil.queryProperty((QueryService)this._queryService, (ManagedObjectReference)moRef, (String)STORAGE_CONTAINERS_INFO);
        if (ArrayUtils.isEmpty((Object[])containers)) {
            return new StorageContainerInfoItem[0];
        }
        if (ArrayUtils.isEmpty((Object[])(containers = this.filterInapplicableContainers((StorageContainerInfo[])containers)))) {
            return new StorageContainerInfoItem[0];
        }
        HostData[] availableHosts = (HostData[])QueryServiceUtil.queryProperty((QueryService)this._queryService, (ManagedObjectReference)moRef, (String)STORAGE_AVAILABLE_HOSTS_FOR_CREATE_DATASTORE);
        ArrayList<StorageContainerInfoItem> filtered = new ArrayList<StorageContainerInfoItem>();
        for (Object storageContainer : containers) {
            if (this.isContainerMountedToAllHosts((StorageContainerInfo)storageContainer, availableHosts)) continue;
            filtered.add(StorageContainerInfoItem.getInstance((StorageContainerInfo)storageContainer));
        }
        return filtered.toArray(new StorageContainerInfoItem[filtered.size()]);
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastore", property="isMultipleFilesDownloadSupported")
    public boolean getIsMultipleFilesDownloadSupported(ManagedObjectReference datastore) throws Exception {
        Object[] hostMounts = (Datastore.HostMount[])QueryServiceUtil.queryProperty((QueryService)this._queryService, (ManagedObjectReference)datastore, (String)HOST_MOUNT_PROPERTY);
        return !ArrayUtils.isEmpty((Object[])hostMounts);
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastore", property="clusteredVmdkEnabledPoweredOnVMsInfo")
    public VirtualMachinesInVmdkClusterInfo getClusteredVmdkEnabledPoweredOnVMsInfo(ManagedObjectReference datastoreMor) throws Exception {
        VirtualMachinesInVmdkClusterInfo info = new VirtualMachinesInVmdkClusterInfo();
        ManagedObjectReference[] vms = this.getClusteredVmdkEnabledPoweredOnVMs(datastoreMor);
        info.vms = DatastorePropertyProvider.getVmdkVmInformation(this._queryExecutor, vms);
        info.hasPrivilegesForAllVms = vms.length == info.vms.length;
        return info;
    }

    private StorageContainerInfo[] filterInapplicableContainers(StorageContainerInfo[] containerInfos) {
        ArrayList<StorageContainerInfo> result = new ArrayList<StorageContainerInfo>();
        for (StorageContainerInfo containerInfo : containerInfos) {
            StorageContainer container = containerInfo.storageContainer;
            if (container == null || H5StorageUtil.isVsanContainer((StorageContainer)container) || H5StorageUtil.isIoFilterContainer((StorageContainer)container)) continue;
            result.add(containerInfo);
        }
        return result.toArray(new StorageContainerInfo[result.size()]);
    }

    private boolean isContainerMountedToAllHosts(StorageContainerInfo container, HostData[] availableHosts) {
        if (ArrayUtils.isEmpty((Object[])container.hosts)) {
            return false;
        }
        ArrayList<ManagedObjectReference> hostDataRefs = new ArrayList<ManagedObjectReference>(availableHosts.length);
        for (HostData host : availableHosts) {
            hostDataRefs.add(host.hostRef);
        }
        return Arrays.asList(container.hosts).containsAll(hostDataRefs);
    }

    private static void filterClustersWithExplicitHearthbeatDs(Map<ManagedObjectReference, ResourceItem> clusterProps, List<HeartbeatRequirement> clustersHeartbeatReqirements) {
        Iterator<Map.Entry<ManagedObjectReference, ResourceItem>> it = clusterProps.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ManagedObjectReference, ResourceItem> entry = it.next();
            DasConfigInfo dasConfigInfo = (DasConfigInfo)entry.getValue().get(CONFIGURATION_DAS_CONFIG);
            if (dasConfigInfo.heartbeatDatastore == null) continue;
            clustersHeartbeatReqirements.add(new HeartbeatRequirement(entry.getKey(), Arrays.asList(dasConfigInfo.heartbeatDatastore), dasConfigInfo, (String)entry.getValue().get("name")));
            it.remove();
        }
    }

    private static void filterClustersWithAutoHearthbeatDs(QueryService queryService, Map<ManagedObjectReference, ResourceItem> clusterProps, List<HeartbeatRequirement> clustersHeartbeatReqirements) {
        HashSet<ManagedObjectReference> dsClusterRefs = new HashSet<ManagedObjectReference>();
        Iterator<Map.Entry<ManagedObjectReference, ResourceItem>> it = clusterProps.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ManagedObjectReference, ResourceItem> entry = it.next();
            DasConfigInfo dasConfigInfo = (DasConfigInfo)entry.getValue().get(CONFIGURATION_DAS_CONFIG);
            if (dasConfigInfo.heartbeatDatastore != null) continue;
            dsClusterRefs.add(entry.getKey());
            it.remove();
        }
        HashMap<ManagedObjectReference, HeartbeatRequirement> heartbeatRequirementMap = new HashMap<ManagedObjectReference, HeartbeatRequirement>();
        ResultSet allClusterDatastoresResultSet = queryService.select(new String[]{DATASTORE_RELATION, CONFIGURATION_DAS_CONFIG, "name"}).from(new String[]{ClusterComputeResource.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, dsClusterRefs)}).fetch();
        HashSet<ManagedObjectReference> allClusterDatastoresMors = new HashSet<ManagedObjectReference>();
        HashMap<ManagedObjectReference, ResourceItem> clusterResourceItems = new HashMap<ManagedObjectReference, ResourceItem>();
        for (ResourceItem resourceItem : allClusterDatastoresResultSet.getItems()) {
            clusterResourceItems.put((ManagedObjectReference)resourceItem.getKey(), resourceItem);
            allClusterDatastoresMors.addAll(Arrays.asList((ManagedObjectReference[])resourceItem.get(DATASTORE_RELATION)));
        }
        ResultSet nonLocalDatastores = queryService.select(new String[]{"cluster", DATASTORE_TYPE_PROPERTY, LOCAL_DATASTORE_PROP}).from(new String[]{Datastore.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, allClusterDatastoresMors)}).fetch();
        for (ResourceItem resourceItem : nonLocalDatastores.getItems()) {
            ManagedObjectReference[] clusterRefs = (ManagedObjectReference[])resourceItem.get("cluster");
            if (clusterRefs == null) continue;
            for (ManagedObjectReference clusterRef : clusterRefs) {
                ResourceItem clusterResourceItem = (ResourceItem)clusterResourceItems.get(clusterRef);
                if (clusterResourceItem == null) continue;
                String datastoreType = (String)resourceItem.get(DATASTORE_TYPE_PROPERTY);
                datastoreType = datastoreType.toLowerCase();
                Boolean isLocal = false;
                if (resourceItem.get(LOCAL_DATASTORE_PROP) != null) {
                    isLocal = (Boolean)resourceItem.get(LOCAL_DATASTORE_PROP);
                }
                if (isLocal.booleanValue() || !FileSystemVolume.FileSystemType.VMFS.toString().toLowerCase().equals(datastoreType) && !FileSystemVolume.FileSystemType.NFS.toString().toLowerCase().equals(datastoreType) && !FileSystemVolume.FileSystemType.NFS41.toString().toLowerCase().equals(datastoreType) && !FileSystemVolume.FileSystemType.VVOL.toString().toLowerCase().equals(datastoreType)) continue;
                HeartbeatRequirement req = new HeartbeatRequirement(clusterRef, new ArrayList(), (DasConfigInfo)clusterResourceItem.get(CONFIGURATION_DAS_CONFIG), (String)clusterResourceItem.get("name"));
                if (heartbeatRequirementMap.get(clusterRef) == null) {
                    heartbeatRequirementMap.put(clusterRef, req);
                }
                ((HeartbeatRequirement)heartbeatRequirementMap.get((Object)clusterRef)).heartbeatDatastores.add((ManagedObjectReference)resourceItem.getKey());
            }
        }
        clustersHeartbeatReqirements.addAll(heartbeatRequirementMap.values());
    }

    private static List<ManagedObjectReference> filterClustersWithDisabledHa(ResultSet clustersResultSet) {
        ArrayList<ManagedObjectReference> result = new ArrayList<ManagedObjectReference>();
        for (ResourceItem clusterItem : clustersResultSet.getItems()) {
            DasConfigInfo configInfo = (DasConfigInfo)clusterItem.get(CONFIGURATION_DAS_CONFIG);
            if (configInfo == null || !configInfo.enabled.booleanValue()) continue;
            result.add((ManagedObjectReference)clusterItem.getKey());
        }
        return result;
    }

    private static List<ManagedObjectReference> filterClustersWithHaDsRemaining(Map<ManagedObjectReference, List<ManagedObjectReference>> clusterHostsForCurrentDs, List<ManagedObjectReference> hostRefsList) {
        ArrayList<ManagedObjectReference> result = new ArrayList<ManagedObjectReference>();
        for (Map.Entry<ManagedObjectReference, List<ManagedObjectReference>> entry : clusterHostsForCurrentDs.entrySet()) {
            List<ManagedObjectReference> clusterHosts = entry.getValue();
            boolean containsAllHosts = hostRefsList.containsAll(clusterHosts);
            if (!containsAllHosts) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private Map<ManagedObjectReference, List<ManagedObjectReference>> getClusterHostsForDs(QueryService queryService, ManagedObjectReference dsRef, List<ManagedObjectReference> clusterRefs) {
        HashMap<ManagedObjectReference, List<ManagedObjectReference>> result = new HashMap<ManagedObjectReference, List<ManagedObjectReference>>();
        ResultSet rs = queryService.select(new String[]{"@modelKey", "parent"}).from(new String[]{HostSystem.class.getSimpleName()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate("parent", PropertyPredicate.ComparisonOperator.IN, clusterRefs), new PropertyPredicate(DATASTORE_RELATION, PropertyPredicate.ComparisonOperator.EQUAL, (Object)dsRef)}).fetch();
        ArrayList<ManagedObjectReference> allClusterHostsForDs = new ArrayList<ManagedObjectReference>();
        for (ResourceItem resourceItem : rs.getItems()) {
            allClusterHostsForDs.add((ManagedObjectReference)resourceItem.getKey());
        }
        ResultSet rs2 = queryService.select(new String[]{"host"}).from(new String[]{Datastore.class.getSimpleName()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dsRef), new PropertyPredicate(DS_MOUNTED_HOST_KEYS_PROP, PropertyPredicate.ComparisonOperator.IN, allClusterHostsForDs)}).fetch();
        ArrayList<ManagedObjectReference> filteredHosts = new ArrayList<ManagedObjectReference>();
        for (ResourceItem resourceItem : rs2.getItems()) {
            Datastore.HostMount[] hostMounts;
            for (Datastore.HostMount currentHostMount : hostMounts = (Datastore.HostMount[])resourceItem.getPropertyValues().get(0)) {
                if (!currentHostMount.getMountInfo().getAccessible().booleanValue() || !currentHostMount.getMountInfo().getMounted().booleanValue()) continue;
                filteredHosts.add(currentHostMount.getKey());
            }
        }
        for (ResourceItem resourceItem : rs.getItems()) {
            ManagedObjectReference currentHostRef;
            ManagedObjectReference clusterRef = (ManagedObjectReference)resourceItem.get("parent");
            if (result.get(clusterRef) == null) {
                result.put(clusterRef, new ArrayList());
            }
            if (!filteredHosts.contains(currentHostRef = (ManagedObjectReference)resourceItem.getKey())) continue;
            ((List)result.get(clusterRef)).add(currentHostRef);
        }
        return result;
    }

    private Map<String, Object> getDatastoreSystemAndPartitionInfo(ManagedObjectReference hostRef, String devicePath) throws Exception {
        HashMap<String, String> propertyParams = new HashMap<String, String>();
        propertyParams.put(DISK_PARTITION_INFO, devicePath);
        Map hostProperties = QueryExecutorUtil.requestPropertiesWithParams((QueryExecutor)this._queryExecutor, (QuerySpecBuilder)this._querySpecBuilder, (Object)hostRef, (String[])new String[]{HOST_DATASTORE_SYSTEM, DISK_PARTITION_INFO}, propertyParams);
        return hostProperties;
    }

    private ManagedObjectReference[] getClusteredVmdkEnabledPoweredOnVMs(ManagedObjectReference datastoreRef) throws Exception {
        ManagedObjectReference[] vms = (ManagedObjectReference[])QueryExecutorUtil.requestProperty((QueryExecutor)this._queryExecutor, (Object)datastoreRef, (String)CLUSTERED_VMDK_VMS_PROPERTY);
        if (vms == null) {
            return new ManagedObjectReference[0];
        }
        return vms;
    }

    private static VmdkVirtualMachineInfo[] getVmdkVmInformation(QueryExecutor queryExecutor, ManagedObjectReference[] vms) {
        if (vms == null || vms.length == 0) {
            return new VmdkVirtualMachineInfo[0];
        }
        ArrayList<VmdkVirtualMachineInfo> vmInfos = new ArrayList<VmdkVirtualMachineInfo>();
        try {
            Map vmNamesByMor = QueryExecutorUtil.requestPropertyForMultipleObjects((QueryExecutor)queryExecutor, (Object[])vms, (String)"name");
            for (Map.Entry vmAndNamePair : vmNamesByMor.entrySet()) {
                vmInfos.add(new VmdkVirtualMachineInfo((String)vmAndNamePair.getValue()));
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Error while querying virtual machines", (Throwable)e);
        }
        return vmInfos.toArray(new VmdkVirtualMachineInfo[0]);
    }
}

