/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.cis.data.model.DerivedProperty;
import com.vmware.cis.data.model.SourceProperty;
import com.vmware.vim.binding.vim.HostSystem;

public class HostExtendedDataModel {
    @DerivedProperty(value="HostSystem/isAddSoftwareAdapterActionAvailable")
    public static boolean isAddSoftwareAdapterActionAvailable(@SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState, @SourceProperty(value="HostSystem/config/storageDevice/softwareInternetScsiEnabled") Boolean softwareInternetScsiEnabled, @SourceProperty(value="HostSystem/fcoeCapablePnics") Object[] fcoeCapablePnics, @SourceProperty(value="HostSystem/config/network/rdmaDevice") Object[] rdmaDevices) {
        boolean canAddIscsiAdapter = Boolean.FALSE.equals(softwareInternetScsiEnabled);
        boolean canAddFcoeAdapter = fcoeCapablePnics != null && fcoeCapablePnics.length > 0;
        boolean canAddRdmaAdapter = rdmaDevices != null && rdmaDevices.length > 0;
        return HostExtendedDataModel.isHostConnected(connectionState) && (canAddIscsiAdapter || canAddFcoeAdapter || canAddRdmaAdapter);
    }

    @DerivedProperty(value="HostSystem/isAddIscsiSoftwareAdapterActionAvailable")
    public static boolean isAddIscsiSoftwareAdapterActionAvailable(@SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState, @SourceProperty(value="HostSystem/config/storageDevice/softwareInternetScsiEnabled") Boolean softwareInternetScsiEnabled) {
        boolean canAddIscsiAdapter = Boolean.FALSE.equals(softwareInternetScsiEnabled);
        return HostExtendedDataModel.isHostConnected(connectionState) && canAddIscsiAdapter;
    }

    @DerivedProperty(value="HostSystem/isAddFcoeSoftwareAdapterActionAvailable")
    public static boolean isAddFcoeSoftwareAdapterActionAvailable(@SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState, @SourceProperty(value="HostSystem/fcoeCapablePnics") Object[] fcoeCapablePnics) {
        boolean canAddFcoeAdapter = fcoeCapablePnics != null && fcoeCapablePnics.length > 0;
        return HostExtendedDataModel.isHostConnected(connectionState) && canAddFcoeAdapter;
    }

    @DerivedProperty(value="HostSystem/isAddNvmeOverRdmaSoftwareAdapterActionAvailable")
    public static boolean isAddNvmeOverRdmaSoftwareAdapterActionAvailable(@SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState, @SourceProperty(value="HostSystem/config/network/rdmaDevice") Object[] rdmaDevices) {
        boolean canAddNvmeOverRdmaAdapter = rdmaDevices != null && rdmaDevices.length > 0;
        return HostExtendedDataModel.isHostConnected(connectionState) && canAddNvmeOverRdmaAdapter;
    }

    @DerivedProperty(value="HostSystem/isAddNvmeOverTcpSoftwareAdapterActionAvailable")
    public static boolean isAddNvmeOverTcpSoftwareAdapterActionAvailable(@SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState, @SourceProperty(value="HostSystem/capability/nvmeOverTcpSupported") Boolean nvmeOverTcpSupported) {
        boolean canAddNvmeOverTcpAdapter = Boolean.TRUE.equals(nvmeOverTcpSupported);
        return HostExtendedDataModel.isHostConnected(connectionState) && canAddNvmeOverTcpAdapter;
    }

    @DerivedProperty(value="HostSystem/markAsSsdActionsAvailable")
    public static boolean markAsSsdActionsAvailable(@SourceProperty(value="HostSystem/capability/markAsSsdSupported") Boolean markAsSsdSupported, @SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState) {
        return HostExtendedDataModel.isHostConnected(connectionState) && markAsSsdSupported != false;
    }

    @DerivedProperty(value="HostSystem/markAsLocalActionsAvailable")
    public static boolean markAsLocalActionsAvailable(@SourceProperty(value="HostSystem/capability/markAsLocalSupported") Boolean markAsLocalSupported, @SourceProperty(value="HostSystem/runtime/connectionState") HostSystem.ConnectionState connectionState) {
        return HostExtendedDataModel.isHostConnected(connectionState) && markAsLocalSupported != false;
    }

    @DerivedProperty(value="HostSystem/markPerenniallyReservedActionAvailable")
    public static boolean markPerenniallyReservedActionAvailable(@SourceProperty(value="HostSystem/capability/markPerenniallyReservedSupported") Boolean markPerenniallyReservedSupported, @SourceProperty(value="HostSystem/isHostConnectedAndPoweredOn") Boolean isHostConnectedAndPoweredOn) {
        return isHostConnectedAndPoweredOn != false && markPerenniallyReservedSupported != false;
    }

    private static boolean isHostConnected(HostSystem.ConnectionState connectionState) {
        return HostSystem.ConnectionState.connected.equals((Object)connectionState);
    }
}

