/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.FibreChannelHba;
import com.vmware.vim.binding.vim.host.FibreChannelOverEthernetHba;
import com.vmware.vim.binding.vim.host.HostBusAdapter;
import com.vmware.vim.binding.vim.host.InternetScsiHba;
import com.vmware.vim.binding.vim.host.MultipathStateInfo;
import com.vmware.vim.binding.vim.host.NvmeController;
import com.vmware.vim.binding.vim.host.NvmeNamespace;
import com.vmware.vim.binding.vim.host.NvmeTopology;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.PlugStoreTopology;
import com.vmware.vim.binding.vim.host.RdmaDevice;
import com.vmware.vim.binding.vim.host.RdmaHba;
import com.vmware.vim.binding.vim.host.StorageDeviceInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vsphere.client.commonservice.util.QueryExecutorUtil;
import com.vmware.vsphere.client.h5.storage.data.adapters.FcoeConfigData;
import com.vmware.vsphere.client.h5.storage.data.adapters.FibreChannelOverEthernetStorageAdapterData;
import com.vmware.vsphere.client.h5.storage.data.adapters.FibreChannelStorageAdapterData;
import com.vmware.vsphere.client.h5.storage.data.adapters.HostNvmeControllerData;
import com.vmware.vsphere.client.h5.storage.data.adapters.HostNvmeNamespaceData;
import com.vmware.vsphere.client.h5.storage.data.adapters.HostStorageAdaptersData;
import com.vmware.vsphere.client.h5.storage.data.adapters.IscsiStorageAdapterData;
import com.vmware.vsphere.client.h5.storage.data.adapters.NetworkSettingsItem;
import com.vmware.vsphere.client.h5.storage.data.adapters.RdmaDeviceData;
import com.vmware.vsphere.client.h5.storage.data.adapters.RdmaStorageAdapterData;
import com.vmware.vsphere.client.h5.storage.data.adapters.StorageAdapterData;
import com.vmware.vsphere.client.h5.storage.data.multipathing.AdapterStoragePath;
import com.vmware.vsphere.client.h5.storage.util.H5StorageUtil;
import com.vmware.vsphere.client.h5.storage.util.internal.StorageStringUtil;
import com.vmware.vsphere.client.storage.adapters.StorageAdapterTopologyCountData;
import com.vmware.vsphere.client.storage.adapters.StorageAdapterType;
import com.vmware.vsphere.client.storage.adapters.StoragePathData;
import com.vmware.vsphere.client.storage.util.HostStoragePropertyCache;
import com.vmware.vsphere.client.storage.util.StorageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostStorageAdaptersPropertyProvider
implements PropertyProviderBean {
    private static final String STORAGE_DEVICE_INFO_PROPERTY = "config/storageDevice";
    private static final String STORAGE_MULTIPATH_INFO_PROPERTY = "config/multipathState";
    private static final String HOST_PNIC_PROPERTY = "config/network/pnic";
    private static final String HOST_STORAGE_PRIVILEGE = "Host.Config.Storage";
    private static final String HOST_PRIVILEGES_PROPERTY = "grantedPrivileges";
    private static final String HOST_RUNTIME_CONNECTION_STATE_PROPERTY = "runtime/connectionState";
    private static final String HOST_BUS_ADAPTER_PROPERTY = "hostBusAdapter";
    private static final String NVME_TOPOLOGY_PROPERTY = "config/storageDevice/nvmeTopology";
    private static final String RDMA_ADAPTERS_PROPERTY = "config/network/rdmaDevice";
    private static final int INVALID_LUN_NUMBER = -1;
    private static Log _logger = LogFactory.getLog(HostStorageAdaptersPropertyProvider.class);
    private QueryExecutor _queryExecutor;
    private QuerySpecBuilder _querySpecBuilder;

    public HostStorageAdaptersPropertyProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storageadapter", property="hostStorageAdapters")
    public HostStorageAdaptersData getHostStorageAdapters(ManagedObjectReference hostRef) throws Exception {
        HostStorageAdaptersData result = new HostStorageAdaptersData();
        result.adapters = new StorageAdapterData[0];
        if (hostRef == null) {
            _logger.error((Object)"Host is null.");
            return result;
        }
        Map properties = QueryExecutorUtil.requestProperties((QueryExecutor)this._queryExecutor, (Object)hostRef, (String[])new String[]{STORAGE_DEVICE_INFO_PROPERTY});
        if (properties.isEmpty()) {
            _logger.error((Object)String.format("Cannot fetch '%s' for '%s'.", STORAGE_DEVICE_INFO_PROPERTY, hostRef));
            return result;
        }
        StorageDeviceInfo storageDeviceInfo = (StorageDeviceInfo)properties.get(STORAGE_DEVICE_INFO_PROPERTY);
        if (storageDeviceInfo == null) {
            _logger.error((Object)String.format("Cannot fetch '%s' for '%s'", STORAGE_DEVICE_INFO_PROPERTY, hostRef));
            return result;
        }
        result.isIScsiEnabledOnHost = storageDeviceInfo.softwareInternetScsiEnabled;
        if (storageDeviceInfo.hostBusAdapter == null) {
            return result;
        }
        StorageAdapterTopologyCountData[] adaptersCountData = StorageUtil.getStorageAdapterTopologyCountData((StorageDeviceInfo)storageDeviceInfo);
        result.adapters = this.buildAdapters(storageDeviceInfo.hostBusAdapter, adaptersCountData);
        return result;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storageadapter", property="hostStorageAdapterPaths")
    public AdapterStoragePath[] getHostStorageAdapterPaths(ManagedObjectReference hostRef, String adapterKey) throws Exception {
        if (hostRef == null) {
            _logger.error((Object)"Host is null");
            return new AdapterStoragePath[0];
        }
        Map properties = QueryExecutorUtil.requestProperties((QueryExecutor)this._queryExecutor, (Object)hostRef, (String[])new String[]{STORAGE_DEVICE_INFO_PROPERTY, STORAGE_MULTIPATH_INFO_PROPERTY});
        if (properties.isEmpty()) {
            _logger.error((Object)String.format("Cannot fetch '[%s, %s]' for '%s'", STORAGE_DEVICE_INFO_PROPERTY, STORAGE_MULTIPATH_INFO_PROPERTY, hostRef));
            return new AdapterStoragePath[0];
        }
        StorageDeviceInfo sdi = (StorageDeviceInfo)properties.get(STORAGE_DEVICE_INFO_PROPERTY);
        if (sdi == null) {
            _logger.error((Object)("StorageDeviceInfo for host [" + hostRef + "] is null"));
            return new AdapterStoragePath[0];
        }
        MultipathStateInfo msi = (MultipathStateInfo)properties.get(STORAGE_MULTIPATH_INFO_PROPERTY);
        if (msi == null) {
            _logger.error((Object)("MultipathStateInfo for host [" + hostRef + "] is null"));
            return new AdapterStoragePath[0];
        }
        HostStoragePropertyCache cache = new HostStoragePropertyCache(sdi, msi);
        PlugStoreTopology.Adapter pstAdapter = cache.getPstAdapterFromHbaKey(adapterKey);
        if (pstAdapter == null) {
            _logger.error((Object)("Invalid adapterKey passed:[" + adapterKey + "]"));
            String[] params = new String[]{adapterKey};
            throw new IllegalArgumentException(StorageStringUtil.getString("error.invalidAdapter", params));
        }
        PlugStoreTopology.Plugin[] pstPluginsArray = cache.pstPlugins.values().toArray(new PlugStoreTopology.Plugin[cache.pstPlugins.size()]);
        ArrayList<AdapterStoragePath> dtos = new ArrayList<AdapterStoragePath>();
        if (!ArrayUtils.isEmpty((Object[])pstAdapter.path)) {
            for (String pathKey : pstAdapter.path) {
                if (StorageUtil.isPathMasked((String)pathKey, (PlugStoreTopology.Plugin[])pstPluginsArray)) continue;
                StoragePathData storagePathData = StorageUtil.buildStoragePathData((String)pathKey, (HostStoragePropertyCache)cache);
                dtos.add(AdapterStoragePath.newInstance((StoragePathData)storagePathData));
            }
        }
        return dtos.toArray(new AdapterStoragePath[dtos.size()]);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storageadapter", property="fcoeConfig")
    public FcoeConfigData getFcoeConfig(ManagedObjectReference hostRef, String fcoePnicName) throws Exception {
        PhysicalNic[] physicalNics;
        FcoeConfigData result = new FcoeConfigData();
        Map hostPnicResponse = QueryExecutorUtil.requestProperties((QueryExecutor)this._queryExecutor, (Object)hostRef, (String[])new String[]{HOST_PNIC_PROPERTY});
        if (hostPnicResponse.get(HOST_PNIC_PROPERTY) == null) {
            _logger.error((Object)String.format("Cannot fetch '%s' for '%s'", HOST_PNIC_PROPERTY, hostRef));
            return result;
        }
        for (PhysicalNic currentNic : physicalNics = (PhysicalNic[])hostPnicResponse.get(HOST_PNIC_PROPERTY)) {
            if (!currentNic.device.equals(fcoePnicName) || currentNic.fcoeConfiguration == null) continue;
            result.priorityClass = currentNic.fcoeConfiguration.priorityClass;
            break;
        }
        return result;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storageadapter", property="networkSettings")
    public NetworkSettingsItem getNetworkSettings(ManagedObjectReference hostRef, String iscsiAdapterKey) throws Exception {
        HashMap<String, String> propertyParams = new HashMap<String, String>(1);
        propertyParams.put(HOST_BUS_ADAPTER_PROPERTY, iscsiAdapterKey);
        Map hbaResponse = QueryExecutorUtil.requestPropertiesWithParams((QueryExecutor)this._queryExecutor, (QuerySpecBuilder)this._querySpecBuilder, (Object)hostRef, (String[])new String[]{HOST_BUS_ADAPTER_PROPERTY}, propertyParams);
        HostBusAdapter hbaAdapter = (HostBusAdapter)hbaResponse.get(HOST_BUS_ADAPTER_PROPERTY);
        if (hbaAdapter == null) {
            _logger.error((Object)String.format("Can not fetch data for hba %s on host %s", iscsiAdapterKey, hostRef));
            return null;
        }
        if (!(hbaAdapter instanceof InternetScsiHba)) {
            _logger.error((Object)String.format("Hba %s is of type %s which is not compatible with %s on host %s", iscsiAdapterKey, hbaAdapter.getClass().getCanonicalName(), InternetScsiHba.class.getCanonicalName(), hostRef));
            return null;
        }
        InternetScsiHba iHbaAdapter = (InternetScsiHba)hbaAdapter;
        return NetworkSettingsItem.getInstance((InternetScsiHba)iHbaAdapter);
    }

    @ModelMetadata(type={"Datacenter", "Folder", "ClusterComputeResource"}, propertyNamespace="storageadapter", property="getHostsApplicableForRescan")
    public ManagedObjectReference[] getHostsApplicableForRescan(ManagedObjectReference moRef) throws Exception {
        ArrayList<ManagedObjectReference> hostRefs = new ArrayList<ManagedObjectReference>();
        if (moRef == null) {
            return hostRefs.toArray(new ManagedObjectReference[hostRefs.size()]);
        }
        RelationalConstraint hostsOfAContainer = QueryUtil.createRelationalConstraint((String)"host", (Constraint)QueryUtil.createObjectIdentityConstraint((Object)moRef), (Boolean)true, (String)HostSystem.class.getSimpleName());
        ResultSet resultSet = this._queryExecutor.getData(this._querySpecBuilder.buildQuerySpec((Constraint)hostsOfAContainer, new String[]{HOST_RUNTIME_CONNECTION_STATE_PROPERTY, HOST_PRIVILEGES_PROPERTY}));
        if (resultSet.error != null) {
            _logger.error((Object)String.format("Error occurred while fetching data about hosts under %s", moRef), (Throwable)resultSet.error);
            return hostRefs.toArray(new ManagedObjectReference[hostRefs.size()]);
        }
        for (ResultItem item : resultSet.items) {
            Map properties = QueryExecutorUtil.mapPropertyNamesToValues((PropertyValue[])item.properties);
            boolean isHostConnected = properties.get(HOST_RUNTIME_CONNECTION_STATE_PROPERTY).equals(HostSystem.ConnectionState.connected);
            List<String> hostPrivileges = Arrays.asList((String[])properties.get(HOST_PRIVILEGES_PROPERTY));
            boolean neededPrivilegeMet = hostPrivileges.contains(HOST_STORAGE_PRIVILEGE);
            if (!isHostConnected || !neededPrivilegeMet) continue;
            hostRefs.add((ManagedObjectReference)item.resourceObject);
        }
        return hostRefs.toArray(new ManagedObjectReference[hostRefs.size()]);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storageadapter", property="nvmeControllers")
    public HostNvmeControllerData[] getNvmeControllers(ManagedObjectReference hostRef, String nvmeAdapterKey) throws Exception {
        HostNvmeControllerData[] result = new HostNvmeControllerData[]{};
        NvmeTopology.Interface nvmeTopologyInterface = this.getNvmeTopologyInterface(hostRef, nvmeAdapterKey);
        if (nvmeTopologyInterface == null) {
            _logger.error((Object)"NVME topology interface is null.");
            return result;
        }
        ArrayList<HostNvmeControllerData> controllers = new ArrayList<HostNvmeControllerData>();
        if (nvmeTopologyInterface.getConnectedController() != null) {
            for (NvmeController controller : nvmeTopologyInterface.getConnectedController()) {
                HostNvmeControllerData controllerData = new HostNvmeControllerData();
                controllerData.adapter = nvmeTopologyInterface.getAdapter();
                controllerData.name = controller.getName();
                controllerData.controllerNumber = controller.getControllerNumber();
                controllerData.subsystemNQN = controller.getSubnqn();
                controllerData.transportType = controller.getTransportType();
                controllerData.fusedOperationSupported = controller.isFusedOperationSupported();
                controllerData.model = controller.getModel();
                controllerData.firmwareVersion = controller.getFirmwareVersion();
                controllerData.serialNumber = controller.getSerialNumber();
                controllers.add(controllerData);
            }
            result = controllers.toArray(new HostNvmeControllerData[controllers.size()]);
        }
        return result;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storageadapter", property="nvmeNamespaces")
    public HostNvmeNamespaceData[] getNvmeNamespaces(ManagedObjectReference hostRef, String nvmeAdapterKey) throws Exception {
        HostNvmeNamespaceData[] result = new HostNvmeNamespaceData[]{};
        NvmeTopology.Interface nvmeTopologyInterface = this.getNvmeTopologyInterface(hostRef, nvmeAdapterKey);
        if (nvmeTopologyInterface == null) {
            _logger.error((Object)"NVME topology interface is null.");
            return result;
        }
        HashMap<String, HostNvmeNamespaceData> namespaces = new HashMap<String, HostNvmeNamespaceData>();
        NvmeController[] controllers = nvmeTopologyInterface.getConnectedController();
        if (controllers != null) {
            for (NvmeController controller : controllers) {
                if (controller.getAttachedNamespace() == null) continue;
                for (NvmeNamespace namespace : controller.getAttachedNamespace()) {
                    HostNvmeNamespaceData namespaceData = new HostNvmeNamespaceData();
                    namespaceData.adapter = nvmeTopologyInterface.getAdapter();
                    namespaceData.name = namespace.getName();
                    namespaceData.blockSize = namespace.getBlockSize();
                    namespaceData.capacityInBlocks = namespace.getCapacityInBlocks();
                    namespaces.put(namespaceData.name, namespaceData);
                }
            }
        }
        result = namespaces.values().toArray(new HostNvmeNamespaceData[namespaces.size()]);
        return result;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storageadapter", property="freeRdmaDevices")
    public RdmaDeviceData[] getFreeRdmaDevices(ManagedObjectReference hostRef) throws Exception {
        RdmaDeviceData[] result = new RdmaDeviceData[]{};
        if (hostRef == null) {
            _logger.error((Object)"Host is null.");
            return result;
        }
        Map properties = QueryExecutorUtil.requestProperties((QueryExecutor)this._queryExecutor, (Object)hostRef, (String[])new String[]{RDMA_ADAPTERS_PROPERTY, STORAGE_DEVICE_INFO_PROPERTY});
        StorageDeviceInfo storageDeviceInfo = (StorageDeviceInfo)properties.get(STORAGE_DEVICE_INFO_PROPERTY);
        if (storageDeviceInfo == null) {
            _logger.error((Object)String.format("Cannot fetch '%s' for '%s'", STORAGE_DEVICE_INFO_PROPERTY, hostRef));
            return result;
        }
        RdmaDevice[] rdmaDevices = (RdmaDevice[])properties.get(RDMA_ADAPTERS_PROPERTY);
        if (rdmaDevices == null) {
            _logger.error((Object)String.format("Cannot fetch '%s' for '%s'", RDMA_ADAPTERS_PROPERTY, hostRef));
            return result;
        }
        List<RdmaDeviceData> freeDevices = this.buildFreeRdmaDevices(storageDeviceInfo.hostBusAdapter, rdmaDevices);
        result = freeDevices.toArray(new RdmaDeviceData[freeDevices.size()]);
        return result;
    }

    private NvmeTopology.Interface getNvmTopology(NvmeTopology nvmeTopology, String nvmeAdapterKey) {
        NvmeTopology.Interface nvmeTopologyInrface = null;
        if (nvmeTopology.getAdapter() != null) {
            for (NvmeTopology.Interface nvmeInterface : nvmeTopology.getAdapter()) {
                if (nvmeInterface.getAdapter() == null || !nvmeInterface.getAdapter().equals(nvmeAdapterKey)) continue;
                nvmeTopologyInrface = nvmeInterface;
                break;
            }
        }
        return nvmeTopologyInrface;
    }

    private StorageAdapterData[] buildAdapters(HostBusAdapter[] hostBusAdapters, StorageAdapterTopologyCountData[] adaptersCountData) {
        StorageAdapterData[] adapters = new StorageAdapterData[hostBusAdapters.length];
        HashMap<String, StorageAdapterTopologyCountData> adaptersCountsByKey = new HashMap<String, StorageAdapterTopologyCountData>();
        if (adaptersCountData != null) {
            for (StorageAdapterTopologyCountData countData : adaptersCountData) {
                adaptersCountsByKey.put(countData.adapterKey, countData);
            }
        }
        for (int i = 0; i < hostBusAdapters.length; ++i) {
            adapters[i] = this.createAdapterData(hostBusAdapters[i]);
            StorageAdapterTopologyCountData countData = (StorageAdapterTopologyCountData)adaptersCountsByKey.get(adapters[i].key);
            if (countData == null) continue;
            adapters[i].numberOfTargets = countData.numberOfTargets;
            adapters[i].numberOfDevices = countData.numberOfDevices;
            adapters[i].numberOfPaths = countData.numberOfPaths;
        }
        return adapters;
    }

    private StorageAdapterData createAdapterData(HostBusAdapter hba) {
        StorageAdapterData result;
        StorageAdapterType adapterType = StorageAdapterType.getType((HostBusAdapter)hba);
        if (StorageAdapterType.ISCSI.equals((Object)adapterType)) {
            IscsiStorageAdapterData iscsiStorageAdapterData = new IscsiStorageAdapterData();
            InternetScsiHba iscsiHba = (InternetScsiHba)hba;
            IscsiStorageAdapterData.populateIscsiStorageAdapterData((IscsiStorageAdapterData)iscsiStorageAdapterData, (InternetScsiHba)iscsiHba);
            result = iscsiStorageAdapterData;
        } else if (hba instanceof FibreChannelHba) {
            FibreChannelStorageAdapterData fcAdapterData;
            if (StorageAdapterType.FCOE.equals((Object)adapterType)) {
                FibreChannelOverEthernetStorageAdapterData fcoeAdapterData = new FibreChannelOverEthernetStorageAdapterData();
                FibreChannelOverEthernetHba fcoeHba = (FibreChannelOverEthernetHba)hba;
                fcoeAdapterData.isMarkedForRemoval = fcoeHba.markedForRemoval;
                fcoeAdapterData.underlyingNic = fcoeHba.underlyingNic;
                fcoeAdapterData.linkInfo = fcoeHba.linkInfo;
                fcAdapterData = fcoeAdapterData;
            } else {
                fcAdapterData = new FibreChannelStorageAdapterData();
            }
            FibreChannelHba fcHba = (FibreChannelHba)hba;
            fcAdapterData.formattedNodeWorldWideName = H5StorageUtil.formatWWPN((long)fcHba.nodeWorldWideName);
            fcAdapterData.formattedPortWorldWideName = H5StorageUtil.formatWWPN((long)fcHba.portWorldWideName);
            result = fcAdapterData;
        } else if (hba instanceof RdmaHba) {
            RdmaStorageAdapterData rdmaStorageAdapterData = new RdmaStorageAdapterData();
            RdmaHba rdmaHba = (RdmaHba)hba;
            rdmaStorageAdapterData.associatedRdmaDevice = rdmaHba.associatedRdmaDevice;
            result = rdmaStorageAdapterData;
        } else {
            result = new StorageAdapterData();
        }
        result.key = hba.key;
        result.device = hba.device;
        result.status = hba.status;
        result.model = hba.model;
        result.type = adapterType;
        result.storageProtocol = hba.storageProtocol;
        result.identifier = H5StorageUtil.formatHostStorageAdapterIdentifier((HostBusAdapter)hba);
        return result;
    }

    private List<RdmaDeviceData> buildFreeRdmaDevices(HostBusAdapter[] hostBusAdapters, RdmaDevice[] rdmaDevices) {
        ArrayList<RdmaDeviceData> freeRdmaDevices = new ArrayList<RdmaDeviceData>();
        if (rdmaDevices != null && hostBusAdapters != null) {
            for (RdmaDevice device : rdmaDevices) {
                boolean isDeviceInUse = false;
                for (HostBusAdapter adapter : hostBusAdapters) {
                    if (!(adapter instanceof RdmaHba)) continue;
                    RdmaHba hba = (RdmaHba)adapter;
                    if (hba.associatedRdmaDevice == null || !hba.associatedRdmaDevice.equals(device.device)) continue;
                    isDeviceInUse = true;
                    break;
                }
                if (isDeviceInUse) continue;
                RdmaDeviceData rdmaDevice = new RdmaDeviceData();
                rdmaDevice.device = device.getDevice();
                rdmaDevice.deviceName = String.format("%s/%s", rdmaDevice.device, device.getDescription());
                freeRdmaDevices.add(rdmaDevice);
            }
        }
        return freeRdmaDevices;
    }

    private NvmeTopology.Interface getNvmeTopologyInterface(ManagedObjectReference hostRef, String nvmeAdapterKey) throws Exception {
        if (hostRef == null) {
            _logger.error((Object)"Host is null.");
            return null;
        }
        if (nvmeAdapterKey == null || nvmeAdapterKey.isEmpty()) {
            _logger.error((Object)"Adapter is null or empty.");
            return null;
        }
        Map properties = QueryExecutorUtil.requestProperties((QueryExecutor)this._queryExecutor, (Object)hostRef, (String[])new String[]{NVME_TOPOLOGY_PROPERTY});
        NvmeTopology nvmeTopology = (NvmeTopology)properties.get(NVME_TOPOLOGY_PROPERTY);
        if (nvmeTopology == null) {
            _logger.error((Object)String.format("Cannot fetch '%s' for '%s'", NVME_TOPOLOGY_PROPERTY, hostRef));
            return null;
        }
        NvmeTopology.Interface nvmeTopologyInterface = this.getNvmTopology(nvmeTopology, nvmeAdapterKey);
        return nvmeTopologyInterface;
    }
}

