/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.google.common.base.Strings;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.host.DiskDimensions;
import com.vmware.vim.binding.vim.host.DiskPartitionInfo;
import com.vmware.vim.binding.vim.host.FileSystemMountInfo;
import com.vmware.vim.binding.vim.host.MultipathInfo;
import com.vmware.vim.binding.vim.host.ScsiDisk;
import com.vmware.vim.binding.vim.host.ScsiLun;
import com.vmware.vim.binding.vim.host.VmfsVolume;
import com.vmware.vim.binding.vim.vsan.host.DiskMapInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vsphere.client.commonservice.util.QueryExecutorUtil;
import com.vmware.vsphere.client.h5.storage.data.datastore.DatastoreItem;
import com.vmware.vsphere.client.h5.storage.data.datastore.StorageDeviceMultipathingInfo;
import com.vmware.vsphere.client.h5.storage.data.datastore.StorageDeviceMultipathingInfoWithPaths;
import com.vmware.vsphere.client.h5.storage.data.datastore.factory.HostStorageDevicePartitionDetailsItemFactory;
import com.vmware.vsphere.client.h5.storage.data.devices.HostStorageDevicePartitionDetailsItem;
import com.vmware.vsphere.client.h5.storage.data.devices.StorageDeviceItemData;
import com.vmware.vsphere.client.h5.storage.data.multipathing.BaseStoragePath;
import com.vmware.vsphere.client.h5.storage.data.multipathing.DeviceStoragePath;
import com.vmware.vsphere.client.h5.storage.data.multipathing.ProtocolEndpointPath;
import com.vmware.vsphere.client.h5.storage.data.wizard.DatastoreStorageDevice;
import com.vmware.vsphere.client.h5.storage.impl.HostStorageDevicesSpec;
import com.vmware.vsphere.client.h5.storage.util.H5StorageUtil;
import com.vmware.vsphere.client.h5.storage.util.internal.StorageStringUtil;
import com.vmware.vsphere.client.storage.DeviceMultipathingInfo;
import com.vmware.vsphere.client.storage.ScsiDiskInfo;
import com.vmware.vsphere.client.storage.adapters.StorageDeviceData;
import com.vmware.vsphere.client.storage.adapters.StorageDeviceTransport;
import com.vmware.vsphere.client.storage.adapters.StoragePathData;
import com.vmware.vsphere.client.storage.util.StorageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class HostStorageDevicesPropertyProvider
implements PropertyProviderBean {
    private static final String STORAGE_DEVICES_PROPERTY = "storageAdapterDevices";
    private static final String DATASTORE_CONNECTED_HOST = "connectedHost";
    private static final String AVAILABLE_DISK_FOR_VMFS = "availableDisksForVmfs";
    private static final String DISK_PARTITION_INFO = "diskPartitionInfo";
    private static Log _logger = LogFactory.getLog(HostStorageDevicesPropertyProvider.class);
    private static final String STORAGE_DEVICE_MULTIPATHING_INFO_PROPERTY = "deviceMultipathingInfo";
    private static final String FILE_SYSTEM_MOUNT_INFO_PROPERTY = "config.fileSystemVolume.mountInfo";
    private static final String VSAN_DISK_MAP_INFO_PROPERTY = "config/vsanHostConfig/storageInfo/diskMapInfo";
    private static final String VMFS_VOLUME_UUID_PROPERTY = "info/vmfs/uuid";
    private static final String DATASTORE_NAME_PROPERTY = "info/name";
    private static final String DS_TYPE_PROPERTY = "summary/type";
    private static final String HOST_KEY_PROPERTY = "hostKey";
    private static final String VMFS_TYPE = "VMFS";
    private static final String VSAN_TYPE = "vsan";
    private QueryExecutor _queryExecutor;
    private QuerySpecBuilder _querySpecBuilder;
    private QueryService _queryService;
    private ThreadPoolExecutor _threadPoolExecutor;

    public HostStorageDevicesPropertyProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, QueryServiceFactory queryServiceFactory, ThreadPoolExecutor threadPoolExecutor) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
        this._queryService = queryServiceFactory.getQueryService();
        this._threadPoolExecutor = threadPoolExecutor;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storagedevice", property="hostStorageDevices")
    public StorageDeviceItemData[] getHostStorageDevices(final ManagedObjectReference hostRef, HostStorageDevicesSpec spec) throws Exception {
        String _adapterKey = null;
        HashSet<String> vSanEsaDiskIds = Collections.EMPTY_SET;
        if (spec != null) {
            _adapterKey = spec.adapterKey;
            if (CollectionUtils.isNotEmpty(spec.vsanEsaDiskIds)) {
                vSanEsaDiskIds = new HashSet<String>(spec.vsanEsaDiskIds);
            }
        }
        final String adapterKey = _adapterKey;
        ArrayList<StorageDeviceItemData> result = new ArrayList<StorageDeviceItemData>();
        ArrayList<Callable<Object>> propRequests = new ArrayList<Callable<Object>>();
        final HttpServletRequest threadContext = SessionUtil.getHttpRequest();
        if (adapterKey == null) {
            propRequests.add(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                    return QueryExecutorUtil.requestProperties((QueryExecutor)HostStorageDevicesPropertyProvider.this._queryExecutor, (Object)hostRef, (String[])new String[]{HostStorageDevicesPropertyProvider.STORAGE_DEVICES_PROPERTY, HostStorageDevicesPropertyProvider.FILE_SYSTEM_MOUNT_INFO_PROPERTY, HostStorageDevicesPropertyProvider.VSAN_DISK_MAP_INFO_PROPERTY});
                }
            });
        } else {
            propRequests.add(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                    HashMap<String, String> propertyParams = new HashMap<String, String>();
                    propertyParams.put(HostStorageDevicesPropertyProvider.STORAGE_DEVICES_PROPERTY, adapterKey);
                    return QueryExecutorUtil.requestPropertiesWithParams((QueryExecutor)HostStorageDevicesPropertyProvider.this._queryExecutor, (QuerySpecBuilder)HostStorageDevicesPropertyProvider.this._querySpecBuilder, (Object)hostRef, (String[])new String[]{HostStorageDevicesPropertyProvider.STORAGE_DEVICES_PROPERTY, HostStorageDevicesPropertyProvider.FILE_SYSTEM_MOUNT_INFO_PROPERTY, HostStorageDevicesPropertyProvider.VSAN_DISK_MAP_INFO_PROPERTY}, propertyParams);
                }
            });
        }
        propRequests.add(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                return HostStorageDevicesPropertyProvider.this._queryService.select(new String[]{HostStorageDevicesPropertyProvider.VMFS_VOLUME_UUID_PROPERTY, HostStorageDevicesPropertyProvider.DATASTORE_NAME_PROPERTY, HostStorageDevicesPropertyProvider.DS_TYPE_PROPERTY}).from(new String[]{Datastore.class.getSimpleName()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate(HostStorageDevicesPropertyProvider.DS_TYPE_PROPERTY, PropertyPredicate.ComparisonOperator.IN, Arrays.asList(HostStorageDevicesPropertyProvider.VMFS_TYPE, HostStorageDevicesPropertyProvider.VSAN_TYPE, "vsanD")), new PropertyPredicate(HostStorageDevicesPropertyProvider.HOST_KEY_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)hostRef)}).fetch();
            }
        });
        List propResults = this._threadPoolExecutor.invokeAll(propRequests);
        Map devicesProperties = (Map)propResults.get(0).get();
        if (devicesProperties.get(STORAGE_DEVICES_PROPERTY) == null) {
            return result.toArray(new StorageDeviceItemData[result.size()]);
        }
        if (devicesProperties.get(FILE_SYSTEM_MOUNT_INFO_PROPERTY) == null) {
            return result.toArray(new StorageDeviceItemData[result.size()]);
        }
        StorageDeviceData[] storageDevices = (StorageDeviceData[])devicesProperties.get(STORAGE_DEVICES_PROPERTY);
        FileSystemMountInfo[] fileSystemMountInfos = (FileSystemMountInfo[])devicesProperties.get(FILE_SYSTEM_MOUNT_INFO_PROPERTY);
        DiskMapInfo[] vsanDiskMappings = (DiskMapInfo[])devicesProperties.get(VSAN_DISK_MAP_INFO_PROPERTY);
        LinkedMultiValueMap diskToDsUuid = new LinkedMultiValueMap();
        for (FileSystemMountInfo info : fileSystemMountInfos) {
            if (!(info.getVolume() instanceof VmfsVolume)) continue;
            for (ScsiDisk.Partition extent : ((VmfsVolume)info.getVolume()).getExtent()) {
                diskToDsUuid.add((Object)extent.getDiskName(), (Object)((VmfsVolume)info.getVolume()).getUuid());
            }
        }
        HashMap<String, ResourceItem> dsUuidToDatastore = new HashMap<String, ResourceItem>();
        DatastoreItem vsanDsItem = null;
        ResultSet resultSet = (ResultSet)propResults.get(1).get();
        if (resultSet == null) {
            return result.toArray(new StorageDeviceItemData[0]);
        }
        for (ResourceItem item : resultSet.getItems()) {
            String dsType = (String)item.get(DS_TYPE_PROPERTY);
            if (VMFS_TYPE.equals(dsType) || H5StorageUtil.isVsanDirectDatastore((String)dsType)) {
                dsUuidToDatastore.put((String)item.getPropertyValues().get(0), item);
                continue;
            }
            if (!VSAN_TYPE.equals(item.get(DS_TYPE_PROPERTY))) continue;
            vsanDsItem = new DatastoreItem((ManagedObjectReference)item.getKey(), (String)item.get(DATASTORE_NAME_PROPERTY), (String)item.get(DS_TYPE_PROPERTY));
        }
        if (storageDevices != null) {
            for (StorageDeviceData storageDeviceData : storageDevices) {
                if (storageDeviceData == null || storageDeviceData.underlyingLun == null) continue;
                DatastoreItem datastoreItem = null;
                datastoreItem = HostStorageDevicesPropertyProvider.isDiskUsedByVsan(storageDeviceData.underlyingLun, vsanDiskMappings, vSanEsaDiskIds) ? vsanDsItem : HostStorageDevicesPropertyProvider.createDatastoreItem(dsUuidToDatastore, (MultiValueMap<String, String>)diskToDsUuid, storageDeviceData.underlyingLun);
                result.add(HostStorageDevicesPropertyProvider.buildStorageDevice(storageDeviceData, datastoreItem));
            }
        }
        return result.toArray(new StorageDeviceItemData[0]);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storagedevice", property="hostStorageDevicePaths")
    public DeviceStoragePath[] getHostStorageDevicePaths(ManagedObjectReference hostRef, String deviceName) throws Exception {
        DeviceMultipathingInfo deviceInfo = this.getDeviceMultipathingInfo(hostRef, deviceName);
        if (deviceInfo == null || ArrayUtils.isEmpty((Object[])deviceInfo.paths)) {
            return new DeviceStoragePath[0];
        }
        String preferredPathName = BaseStoragePath.getPreferredPathName((MultipathInfo.LogicalUnitPolicy)deviceInfo.pathSelectionPolicy);
        ArrayList<DeviceStoragePath> devicePaths = new ArrayList<DeviceStoragePath>();
        for (StoragePathData path : deviceInfo.paths) {
            devicePaths.add(DeviceStoragePath.newInstance((StoragePathData)path, (String)preferredPathName));
        }
        return devicePaths.toArray(new DeviceStoragePath[devicePaths.size()]);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storagedevice", property="hostStoragePEPaths")
    public List<ProtocolEndpointPath> getHostStoragePEPaths(ManagedObjectReference hostRef, String endpointIdentifier) throws Exception {
        DeviceMultipathingInfo deviceInfo = this.getDeviceMultipathingInfo(hostRef, endpointIdentifier);
        if (deviceInfo == null || ArrayUtils.isEmpty((Object[])deviceInfo.paths)) {
            return Collections.emptyList();
        }
        String preferredPathName = BaseStoragePath.getPreferredPathName((MultipathInfo.LogicalUnitPolicy)deviceInfo.pathSelectionPolicy);
        ArrayList<ProtocolEndpointPath> endpointPaths = new ArrayList<ProtocolEndpointPath>();
        for (StoragePathData path : deviceInfo.paths) {
            endpointPaths.add(ProtocolEndpointPath.newInstance((StoragePathData)path, (String)preferredPathName));
        }
        return endpointPaths;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storagedevice", property="hostStorageDeviceMultipathingInfo")
    public StorageDeviceMultipathingInfo getHostStorageDeviceMultipathingInfo(ManagedObjectReference hostRef, String deviceName) throws Exception {
        DeviceMultipathingInfo deviceInfo = this.getDeviceMultipathingInfo(hostRef, deviceName);
        if (deviceInfo == null) {
            return null;
        }
        StorageDeviceMultipathingInfo result = new StorageDeviceMultipathingInfo();
        result.pathSelectionPolicy = deviceInfo.pathSelectionPolicy;
        result.storageArrayTypePolicy = deviceInfo.storageArrayTypePolicy;
        return result;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storagedevice", property="hostStorageDeviceMultipathingInfoWithPaths")
    public StorageDeviceMultipathingInfoWithPaths getHostStorageDeviceMultipathingInfoWithPaths(ManagedObjectReference hostRef, String deviceName) throws Exception {
        DeviceMultipathingInfo deviceInfo = this.getDeviceMultipathingInfo(hostRef, deviceName);
        if (deviceInfo == null) {
            return null;
        }
        return StorageDeviceMultipathingInfoWithPaths.newInstance((DeviceMultipathingInfo)deviceInfo);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="storagedevice", property="partitionDetails")
    public HostStorageDevicePartitionDetailsItem getDatastoreStorageDevicePartitionDetails(ManagedObjectReference hostRef, String devicePath) throws Exception {
        if (Strings.isNullOrEmpty((String)devicePath)) {
            return new HostStorageDevicePartitionDetailsItem();
        }
        HashMap<String, String> propertyParams = new HashMap<String, String>();
        propertyParams.put(DISK_PARTITION_INFO, devicePath);
        Map result = QueryExecutorUtil.requestPropertiesWithParams((QueryExecutor)this._queryExecutor, (QuerySpecBuilder)this._querySpecBuilder, (Object)hostRef, (String[])new String[]{DISK_PARTITION_INFO}, propertyParams);
        DiskPartitionInfo info = (DiskPartitionInfo)result.get(DISK_PARTITION_INFO);
        if (info == null) {
            _logger.error((Object)String.format("Fetched null for property %s for host %s", DISK_PARTITION_INFO, hostRef));
            return new HostStorageDevicePartitionDetailsItem();
        }
        HostStorageDevicePartitionDetailsItem formattedResult = HostStorageDevicePartitionDetailsItemFactory.newInstance(info);
        return formattedResult;
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="storagedevice", property="datastoreStorageDevices")
    public DatastoreStorageDevice getDatastoreStorageDevices(ManagedObjectReference datastoreRef) throws Exception {
        DatastoreStorageDevice result = new DatastoreStorageDevice();
        ManagedObjectReference connectedHost = (ManagedObjectReference)this._queryExecutor.getProperty((Object)datastoreRef, DATASTORE_CONNECTED_HOST);
        if (connectedHost == null) {
            _logger.error((Object)String.format("Connected host for datastore %s is null.", datastoreRef));
            return result;
        }
        result.connectedHost = connectedHost;
        HashMap<String, ManagedObjectReference> propertyParams = new HashMap<String, ManagedObjectReference>();
        propertyParams.put(AVAILABLE_DISK_FOR_VMFS, datastoreRef);
        Map devicesForSingleAdapter = QueryExecutorUtil.requestPropertiesWithParams((QueryExecutor)this._queryExecutor, (QuerySpecBuilder)this._querySpecBuilder, (Object)connectedHost, (String[])new String[]{AVAILABLE_DISK_FOR_VMFS}, propertyParams);
        result.scsiDiskInfos = (ScsiDiskInfo[])devicesForSingleAdapter.get(AVAILABLE_DISK_FOR_VMFS);
        return result;
    }

    private DeviceMultipathingInfo getDeviceMultipathingInfo(ManagedObjectReference hostRef, String deviceCanonicalName) throws Exception {
        if (hostRef == null || deviceCanonicalName == null) {
            return null;
        }
        return (DeviceMultipathingInfo)QueryExecutorUtil.requestPropertyWithParam((QueryExecutor)this._queryExecutor, (QuerySpecBuilder)this._querySpecBuilder, (Object)hostRef, (String)STORAGE_DEVICE_MULTIPATHING_INFO_PROPERTY, (Object)deviceCanonicalName);
    }

    private static StorageDeviceItemData buildStorageDevice(StorageDeviceData deviceData, DatastoreItem datastoreItem) {
        StorageDeviceItemData itemData = new StorageDeviceItemData();
        ScsiLun lun = deviceData.underlyingLun;
        itemData.name = HostStorageDevicesPropertyProvider.getScsiLunName(lun);
        itemData.identifier = StorageStringUtil.getEmptyIfNull(lun.canonicalName);
        itemData.lunUuid = StorageStringUtil.getEmptyIfNull(lun.uuid);
        itemData.lunNumber = deviceData.lunNumber;
        itemData.type = lun.deviceType;
        itemData.isScsiDisk = lun instanceof ScsiDisk;
        itemData.protocolEndpoint = lun.protocolEndpoint;
        itemData.applicationProtocol = lun.applicationProtocol;
        itemData.hardwareAcceleration = HostStorageDevicesPropertyProvider.getHardwareAcceleration(lun);
        itemData.operationalState = H5StorageUtil.getOperationalState((String[])lun.operationalState);
        itemData.ownerPlugin = deviceData.ownerPlugin;
        itemData.adapter = deviceData.adapter;
        itemData.transport = StorageUtil.getTransport((StorageDeviceTransport[])deviceData.transport);
        itemData.physicalLocation = HostStorageDevicesPropertyProvider.getPhysicalLocation(lun);
        itemData.devicePath = HostStorageDevicesPropertyProvider.getDevicePath(lun);
        itemData.isFlash = HostStorageDevicesPropertyProvider.isFlashDevice(lun);
        itemData.isLocal = HostStorageDevicesPropertyProvider.isLocalDisk(lun);
        itemData.perenniallyReserved = lun.perenniallyReserved;
        itemData.capacity = HostStorageDevicesPropertyProvider.getCapacity(lun);
        itemData.sectorFormat = H5StorageUtil.getSectorFormatByScsiLun((ScsiLun)lun);
        itemData.isDispersed = lun.dispersedNs;
        itemData.subnqn = deviceData.subnqn;
        itemData.isRenameSupported = lun.capabilities != null && lun.capabilities.updateDisplayNameSupported;
        itemData.datastoreItem = datastoreItem;
        return itemData;
    }

    private static String getScsiLunName(ScsiLun scsiLun) {
        if (StringUtils.isNotEmpty((CharSequence)scsiLun.displayName)) {
            return scsiLun.displayName;
        }
        return StorageStringUtil.getEmptyIfNull(scsiLun.canonicalName);
    }

    private static String[] getPhysicalLocation(ScsiLun scsiLun) {
        if (scsiLun instanceof ScsiDisk) {
            return ((ScsiDisk)scsiLun).physicalLocation;
        }
        return new String[0];
    }

    private static String getDevicePath(ScsiLun scsiLun) {
        if (scsiLun instanceof ScsiDisk) {
            return ((ScsiDisk)scsiLun).devicePath;
        }
        return "";
    }

    private static boolean isFlashDevice(ScsiLun scsiLun) {
        Boolean ssd;
        if (scsiLun instanceof ScsiDisk && (ssd = ((ScsiDisk)scsiLun).ssd) != null) {
            return ssd;
        }
        return false;
    }

    private static boolean isLocalDisk(ScsiLun scsiLun) {
        Boolean isLocalDisk;
        if (scsiLun instanceof ScsiDisk && (isLocalDisk = ((ScsiDisk)scsiLun).localDisk) != null) {
            return isLocalDisk;
        }
        return true;
    }

    private static long getCapacity(ScsiLun scsiLun) {
        if (scsiLun instanceof ScsiDisk) {
            return H5StorageUtil.lbaToBytes((DiskDimensions.Lba)((ScsiDisk)scsiLun).capacity);
        }
        return 0L;
    }

    private static String getHardwareAcceleration(ScsiLun scsiLun) {
        ScsiLun.VStorageSupportStatus vStorageSupportStatus = ScsiLun.VStorageSupportStatus.vStorageUnknown;
        if (scsiLun.vStorageSupport != null) {
            vStorageSupportStatus = ScsiLun.VStorageSupportStatus.valueOf((String)scsiLun.vStorageSupport);
        }
        return StorageStringUtil.getString("vStorage." + vStorageSupportStatus.toString());
    }

    private static DatastoreItem createDatastoreItem(Map<String, ResourceItem> dsUuidToDatastore, MultiValueMap<String, String> diskToDsUuid, ScsiLun underlyingLun) {
        if (dsUuidToDatastore.values().size() == 0 || diskToDsUuid.values().size() == 0) {
            return null;
        }
        String diskName = underlyingLun.getCanonicalName();
        if (diskName == null) {
            return null;
        }
        List datastoreUuids = (List)diskToDsUuid.get((Object)diskName);
        if (datastoreUuids == null) {
            return null;
        }
        for (String datastoreUuid : datastoreUuids) {
            ResourceItem datastore = dsUuidToDatastore.get(datastoreUuid);
            if (datastore == null) continue;
            return new DatastoreItem((ManagedObjectReference)datastore.getKey(), (String)datastore.get(DATASTORE_NAME_PROPERTY), (String)datastore.get(DS_TYPE_PROPERTY));
        }
        return null;
    }

    private static boolean isDiskUsedByVsan(ScsiLun scsiLun, DiskMapInfo[] vsanDiskMappings, Set<String> vsanEsaDiskIds) {
        if (vsanDiskMappings == null && vsanEsaDiskIds.isEmpty() || scsiLun == null || scsiLun.uuid == null) {
            return false;
        }
        if (vsanEsaDiskIds.contains(scsiLun.canonicalName)) {
            return true;
        }
        for (DiskMapInfo diskMapInfo : vsanDiskMappings) {
            if (diskMapInfo.mapping == null) continue;
            if (diskMapInfo.mapping.ssd != null && scsiLun.uuid.equals(diskMapInfo.mapping.ssd.uuid)) {
                return true;
            }
            if (diskMapInfo.mapping.nonSsd == null) continue;
            for (ScsiDisk nonSsd : diskMapInfo.mapping.nonSsd) {
                if (!scsiLun.uuid.equals(nonSsd.uuid)) continue;
                return true;
            }
        }
        return false;
    }
}

