/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl.cluster;

import com.google.common.collect.ImmutableMap;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.MultipathInfo;
import com.vmware.vim.binding.vim.host.PlugStoreTopology;
import com.vmware.vim.binding.vim.host.ScsiLun;
import com.vmware.vim.binding.vim.host.StorageDeviceInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vsphere.client.h5.storage.data.cluster.ClusterStorageAdaptersOverviewData;
import com.vmware.vsphere.client.h5.storage.util.H5StorageUtil;
import com.vmware.vsphere.client.h5.storage.util.internal.StorageStringUtil;
import com.vmware.vsphere.client.storage.adapters.StorageAdapterTopologyCountData;
import com.vmware.vsphere.client.storage.util.StorageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterStorageAdapterPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final String CLUSTER_STORAGE_ADAPTERS_OVERVIEW = "clusterStorageAdaptersOverview";
    private static final String CLUSTER_STORAGE_ADAPTERS_DEVICE_INFO = "clusterStorageAdaptersDeviceInfo";
    private static final String STORAGE_DEVICE_INFO_PROPERTY = "config/storageDevice";
    private static final String NUMBER_OF_DATASTORES = "datastore/length";
    private static final String PARENT_PROPERTY = "parent";
    private static final String NAME_PROPERTY = "name";
    private static final String ICON_PROPERTY = "primaryIconId";
    private static final String LABEL_IDS_PROPERTY = "labelIds";
    private static final Map<String, List<String>> propertyToBasePropertyMap = ImmutableMap.of((Object)"clusterStorageAdaptersOverview", Arrays.asList("name", "datastore/length", "primaryIconId", "labelIds"), (Object)"clusterStorageAdaptersDeviceInfo", Arrays.asList("config/storageDevice"));
    private final QueryService _queryService;

    public ClusterStorageAdapterPropertyProviderAdapter(QueryServiceFactory queryServiceFactory, DataServiceExtensionRegistry registry) {
        this._queryService = queryServiceFactory.getQueryService();
        registry.registerDataAdapter((PropertyProviderAdapter)this, ClusterStorageAdapterPropertyProviderAdapter.getProvidedTypeInfos());
    }

    public com.vmware.vise.data.query.ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        com.vmware.vise.data.query.ResultSet resultSet = new com.vmware.vise.data.query.ResultSet();
        if (propertyRequest == null) {
            return resultSet;
        }
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        for (Object sourceObject : propertyRequest.objects) {
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = sourceObject;
            resultItem.properties = this.computePropertyValues(sourceObject, propertyRequest);
            resultItems.add(resultItem);
        }
        resultSet.items = resultItems.toArray(new ResultItem[resultItems.size()]);
        return resultSet;
    }

    private static TypeInfo[] getProvidedTypeInfos() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = ClusterComputeResource.class.getSimpleName();
        typeInfo.properties = new String[]{CLUSTER_STORAGE_ADAPTERS_OVERVIEW, CLUSTER_STORAGE_ADAPTERS_DEVICE_INFO};
        return new TypeInfo[]{typeInfo};
    }

    private PropertyValue[] computePropertyValues(Object sourceObject, PropertyRequestSpec propertyRequest) {
        Set<String> requestProperties = ClusterStorageAdapterPropertyProviderAdapter.getRequestProperties(propertyRequest);
        ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>();
        if (sourceObject instanceof ManagedObjectReference && ((ManagedObjectReference)sourceObject).getType().equals(ClusterComputeResource.class.getSimpleName())) {
            if (requestProperties.contains(CLUSTER_STORAGE_ADAPTERS_OVERVIEW)) {
                propertyValues.addAll(this.processClusterStorageAdaptersOverview((ManagedObjectReference)sourceObject));
            }
            if (requestProperties.contains(CLUSTER_STORAGE_ADAPTERS_DEVICE_INFO)) {
                propertyValues.addAll(this.processClusterStorageAdaptersDeviceInfo((ManagedObjectReference)sourceObject));
            }
        }
        return propertyValues.toArray(new PropertyValue[propertyValues.size()]);
    }

    private static Set<String> getRequestProperties(PropertyRequestSpec propertyRequest) {
        HashSet<String> requestProperties = new HashSet<String>();
        for (PropertySpec propertySpec : propertyRequest.properties) {
            for (String propertyName : propertySpec.propertyNames) {
                requestProperties.add(propertyName);
            }
        }
        return requestProperties;
    }

    private List<PropertyValue> processClusterStorageAdaptersOverview(ManagedObjectReference clusterRef) {
        ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>();
        ResultSet resultSet = this.getClusterStorageAdaptersResultSet(CLUSTER_STORAGE_ADAPTERS_OVERVIEW, clusterRef);
        ArrayList<ClusterStorageAdaptersOverviewData.HostAdapterData> clusterHostsData = new ArrayList<ClusterStorageAdaptersOverviewData.HostAdapterData>();
        for (ResourceItem ri : resultSet.getItems()) {
            ClusterStorageAdaptersOverviewData.HostAdapterData hostData = new ClusterStorageAdaptersOverviewData.HostAdapterData();
            hostData.name = (String)ri.get(NAME_PROPERTY);
            hostData.hostRef = (ManagedObjectReference)ri.getKey();
            hostData.labelIds = (String)ri.get(LABEL_IDS_PROPERTY);
            hostData.iconId = (String)ri.get(ICON_PROPERTY);
            hostData.numberOfDatastores = (Integer)ri.get(NUMBER_OF_DATASTORES);
            clusterHostsData.add(hostData);
        }
        ClusterStorageAdaptersOverviewData result = new ClusterStorageAdaptersOverviewData();
        result.hostStorageAdaptersData = clusterHostsData.toArray(new ClusterStorageAdaptersOverviewData.HostAdapterData[clusterHostsData.size()]);
        PropertyValue propertyValue = ClusterStorageAdapterPropertyProviderAdapter.createPropertyValue(CLUSTER_STORAGE_ADAPTERS_OVERVIEW, result, clusterRef);
        propertyValues.add(propertyValue);
        return propertyValues;
    }

    private List<PropertyValue> processClusterStorageAdaptersDeviceInfo(ManagedObjectReference clusterRef) {
        ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>();
        ResultSet resultSet = this.getClusterStorageAdaptersResultSet(CLUSTER_STORAGE_ADAPTERS_DEVICE_INFO, clusterRef);
        ArrayList<ClusterStorageAdaptersOverviewData.HostAdapterData> clusterHostsData = new ArrayList<ClusterStorageAdaptersOverviewData.HostAdapterData>();
        for (ResourceItem resourceItem : resultSet.getItems()) {
            ClusterStorageAdaptersOverviewData.HostAdapterData hostData = new ClusterStorageAdaptersOverviewData.HostAdapterData();
            StorageDeviceInfo storageDeviceInfo = (StorageDeviceInfo)resourceItem.get(STORAGE_DEVICE_INFO_PROPERTY);
            hostData.hostRef = (ManagedObjectReference)resourceItem.getKey();
            if (storageDeviceInfo != null) {
                ClusterStorageAdapterPropertyProviderAdapter.populateDeviceCounts(storageDeviceInfo, hostData);
                hostData.numberOfStorageAdapters = storageDeviceInfo.hostBusAdapter != null ? storageDeviceInfo.hostBusAdapter.length : 0;
                ClusterStorageAdapterPropertyProviderAdapter.populateTargetCounts(storageDeviceInfo, hostData);
                ClusterStorageAdapterPropertyProviderAdapter.populatePathCounts(storageDeviceInfo, hostData);
            }
            clusterHostsData.add(hostData);
        }
        ClusterStorageAdaptersOverviewData result = new ClusterStorageAdaptersOverviewData();
        result.hostStorageAdaptersData = clusterHostsData.toArray(new ClusterStorageAdaptersOverviewData.HostAdapterData[clusterHostsData.size()]);
        PropertyValue propertyValue = ClusterStorageAdapterPropertyProviderAdapter.createPropertyValue(CLUSTER_STORAGE_ADAPTERS_DEVICE_INFO, result, clusterRef);
        propertyValues.add(propertyValue);
        return propertyValues;
    }

    private ResultSet getClusterStorageAdaptersResultSet(String forRequestProperty, ManagedObjectReference clusterRef) {
        return this._queryService.select(propertyToBasePropertyMap.get(forRequestProperty)).from(new String[]{HostSystem.class.getSimpleName()}).where(PARENT_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)clusterRef).fetch();
    }

    private static PropertyValue createPropertyValue(String name, Object value, Object resourceObject) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.propertyName = name;
        propertyValue.value = value;
        propertyValue.resourceObject = resourceObject;
        return propertyValue;
    }

    private static void populateTargetCounts(StorageDeviceInfo storageDeviceInfo, ClusterStorageAdaptersOverviewData.HostAdapterData hostData) {
        StorageAdapterTopologyCountData[] adaptersCountData = StorageUtil.getStorageAdapterTopologyCountData((StorageDeviceInfo)storageDeviceInfo);
        hostData.numberOfTargets = 0;
        if (adaptersCountData != null) {
            for (StorageAdapterTopologyCountData countData : adaptersCountData) {
                hostData.numberOfTargets += countData.numberOfTargets;
            }
        }
    }

    private static void populateDeviceCounts(StorageDeviceInfo storageDeviceInfo, ClusterStorageAdaptersOverviewData.HostAdapterData hostData) {
        ArrayList<ClusterStorageAdaptersOverviewData.StatusCountData> devicesCountByStatus = new ArrayList<ClusterStorageAdaptersOverviewData.StatusCountData>();
        devicesCountByStatus.add(ClusterStorageAdaptersOverviewData.StatusCountData.newInstance((String)ClusterStorageAdapterPropertyProviderAdapter.localizeDeviceState(ScsiLun.State.ok), (int)0));
        hostData.numberOfAttachedDevices = 0;
        if (storageDeviceInfo.scsiLun != null) {
            hostData.totalNumberOfDevices = storageDeviceInfo.scsiLun.length;
            for (ScsiLun scsiLun : storageDeviceInfo.scsiLun) {
                ScsiLun.State lunState = H5StorageUtil.getOperationalState((String[])scsiLun.operationalState);
                if (ScsiLun.State.ok == lunState) {
                    ++hostData.numberOfAttachedDevices;
                }
                ClusterStorageAdapterPropertyProviderAdapter.incStatusCount(devicesCountByStatus, ClusterStorageAdapterPropertyProviderAdapter.localizeDeviceState(lunState));
            }
        } else {
            hostData.totalNumberOfDevices = 0;
        }
        hostData.devicesCountByStatus = devicesCountByStatus.toArray(new ClusterStorageAdaptersOverviewData.StatusCountData[devicesCountByStatus.size()]);
    }

    private static void populatePathCounts(StorageDeviceInfo storageDeviceInfo, ClusterStorageAdaptersOverviewData.HostAdapterData hostData) {
        HashMap<String, MultipathInfo.Path> multipathInfoPathsByName = new HashMap<String, MultipathInfo.Path>();
        if (storageDeviceInfo.multipathInfo != null && storageDeviceInfo.multipathInfo.lun != null) {
            for (MultipathInfo.LogicalUnit logicalUnit : storageDeviceInfo.multipathInfo.lun) {
                if (logicalUnit.path == null) continue;
                for (MultipathInfo.Path path : logicalUnit.path) {
                    multipathInfoPathsByName.put(path.name, path);
                }
            }
        }
        hostData.totalNumberOfPaths = 0;
        hostData.numberOfActivePaths = 0;
        ArrayList<ClusterStorageAdaptersOverviewData.StatusCountData> pathsCountByStatus = new ArrayList<ClusterStorageAdaptersOverviewData.StatusCountData>();
        pathsCountByStatus.add(ClusterStorageAdaptersOverviewData.StatusCountData.newInstance((String)ClusterStorageAdapterPropertyProviderAdapter.localizePathState(MultipathInfo.PathState.active.toString()), (int)0));
        if (storageDeviceInfo.plugStoreTopology != null && storageDeviceInfo.plugStoreTopology.path != null) {
            for (PlugStoreTopology.Path pstPath : storageDeviceInfo.plugStoreTopology.path) {
                if (StorageUtil.isPathMasked((String)pstPath.key, (PlugStoreTopology.Plugin[])storageDeviceInfo.plugStoreTopology.plugin)) continue;
                ++hostData.totalNumberOfPaths;
                MultipathInfo.Path mpiPath = (MultipathInfo.Path)multipathInfoPathsByName.get(pstPath.name);
                if (mpiPath == null) continue;
                if (MultipathInfo.PathState.active.toString().equals(mpiPath.state)) {
                    ++hostData.numberOfActivePaths;
                }
                ClusterStorageAdapterPropertyProviderAdapter.incStatusCount(pathsCountByStatus, ClusterStorageAdapterPropertyProviderAdapter.localizePathState(mpiPath.state));
            }
        }
        hostData.pathsCountByStatus = pathsCountByStatus.toArray(new ClusterStorageAdaptersOverviewData.StatusCountData[pathsCountByStatus.size()]);
    }

    private static void incStatusCount(List<ClusterStorageAdaptersOverviewData.StatusCountData> statusCountData, String statusName) {
        for (ClusterStorageAdaptersOverviewData.StatusCountData countData : statusCountData) {
            if (!countData.statusName.equals(statusName)) continue;
            ++countData.count;
            return;
        }
        statusCountData.add(ClusterStorageAdaptersOverviewData.StatusCountData.newInstance((String)statusName, (int)1));
    }

    private static String localizePathState(String state) {
        return StorageStringUtil.getString("storage.adapters.paths.state." + state);
    }

    private static String localizeDeviceState(ScsiLun.State state) {
        return StorageStringUtil.getString("storage.adapters.devices.deviceState." + state.toString());
    }
}

