/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl.datastore;

import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.Capability;
import com.vmware.vim.binding.vim.host.StorageSystem;
import com.vmware.vim.binding.vim.host.VmfsVolume;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.util.Version;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.commonservice.util.QueryServiceUtil;
import com.vmware.vsphere.client.h5.storage.data.datastore.reclamation.DatastoreData;
import com.vmware.vsphere.client.h5.storage.data.datastore.reclamation.ReclamationOptionsData;
import com.vmware.vsphere.client.h5.storage.spec.QueryReclamationOptionsSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatastoreReclamationPropertyProvider
implements PropertyProviderBean {
    private static final String DEFAULT_UNMAP_PRIORITY = "low";
    private static final String HOST_MOUNT_PROPERTY = "hostMount";
    private static final String DS_UNMAP_PRIORITY_PROPERTY = "info.vmfs.unmapPriority";
    private static final String DS_UNMAP_BANDWIDTH_PROPERTY = "info.vmfs.unmapBandwidthSpec";
    private static final String DS_UUID_PROPERTY = "info.vmfs.uuid";
    private static final String HOST_UNMAP_METHOD_CAPABILITY_PROPERTY = "capability.unmapMethodSupported";
    private static final String HOST_ULTRA_LOW_FIXED_UNMAP_SUPPORTED_PROPERTY = "capability.ultralowFixedUnmapSupported";
    private static final String HOST_CONNECTION_STATE_PROPERTY = "runtime.connectionState";
    private static final String HOST_VERSION_PROPERTY = "config.product.version";
    private static final String HOST_STORAGE_SYSTEM = "storageSystem";
    private static final String[] HOST_CONFIG_STORAGE_PRIVILEGE = new String[]{"Host.Config.Storage"};
    private final QueryService _queryService;
    private static final Log _logger = LogFactory.getLog(DatastoreReclamationPropertyProvider.class);

    public DatastoreReclamationPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @ModelMetadata(type={"Datastore"}, propertyNamespace="datastore", property="reclamationOptionsData")
    public ReclamationOptionsData getReclamationOptionsData(ManagedObjectReference moRef, QueryReclamationOptionsSpec spec) throws Exception {
        if (spec == null || ArrayUtils.isEmpty((Object[])spec.datastores)) {
            return null;
        }
        List<DatastoreProps> datastoreProps = this.getDatastoreProperties(spec.datastores);
        HashSet<ManagedObjectReference> allMountedHosts = new HashSet<ManagedObjectReference>();
        for (DatastoreProps dsProps : datastoreProps) {
            allMountedHosts.addAll(dsProps.mountedHosts);
        }
        if (allMountedHosts.isEmpty()) {
            _logger.error((Object)"No mounted hosts found.");
            return null;
        }
        Map hostProperties = QueryServiceUtil.queryPropertiesForMultipleObjects((QueryService)this._queryService, allMountedHosts, (String[])new String[]{HOST_CONNECTION_STATE_PROPERTY, "grantedPrivileges", HOST_VERSION_PROPERTY, HOST_UNMAP_METHOD_CAPABILITY_PROPERTY, HOST_ULTRA_LOW_FIXED_UNMAP_SUPPORTED_PROPERTY});
        ReclamationOptionsData result = new ReclamationOptionsData();
        result.datastoresData = this.getConnectedHostsForDatastores(datastoreProps, hostProperties);
        this.populateSupportedReclamationMethods(result, hostProperties);
        if (result.fixedReclamationSupported) {
            this.populateVmfsConfigOptions(result, hostProperties);
            if (result.vmfsConfigOption == null || result.vmfsConfigOption.unmapBandwidthFixedValue == null) {
                result.fixedReclamationSupported = false;
                result.dynamicReclamationSupported = false;
            }
        }
        if (result.datastoresData.length == 1) {
            result.reclamationPriority = datastoreProps.get((int)0).unmapPriority;
            result.unmapBandwidthSpec = datastoreProps.get((int)0).unmapBandwidthSpec;
            if (result.reclamationPriority != null && !VmfsVolume.UnmapPriority.none.toString().equals(result.reclamationPriority) && result.unmapBandwidthSpec == null) {
                result.unmapBandwidthSpec = this.getDefaultUnmapBandwidthSpec(result.vmfsConfigOption);
            }
        } else {
            result.reclamationPriority = DEFAULT_UNMAP_PRIORITY;
            result.unmapBandwidthSpec = this.getDefaultUnmapBandwidthSpec(result.vmfsConfigOption);
        }
        return result;
    }

    private VmfsVolume.UnmapBandwidthSpec getDefaultUnmapBandwidthSpec(VmfsVolume.ConfigOption configOption) {
        if (configOption == null || configOption.unmapBandwidthFixedValue == null) {
            return null;
        }
        VmfsVolume.UnmapBandwidthSpec spec = new VmfsVolume.UnmapBandwidthSpec();
        spec.policy = Capability.UnmapMethodSupported.fixed.toString();
        spec.fixedValue = configOption.unmapBandwidthFixedValue.defaultValue;
        if (configOption.unmapBandwidthDynamicMax != null) {
            spec.dynamicMax = configOption.unmapBandwidthDynamicMax.defaultValue;
        }
        if (configOption.unmapBandwidthDynamicMin != null) {
            spec.dynamicMin = configOption.unmapBandwidthDynamicMin.defaultValue;
        }
        return spec;
    }

    private void populateVmfsConfigOptions(ReclamationOptionsData reclamationOptionsData, Map<ManagedObjectReference, Map<String, Object>> hostProperties) throws Exception {
        Version lowestHostVersionAvailable = null;
        ManagedObjectReference lowestHost = null;
        for (DatastoreData datastoreData : reclamationOptionsData.datastoresData) {
            if (datastoreData.connectedHost == null) continue;
            String version = (String)hostProperties.get(datastoreData.connectedHost).get(HOST_VERSION_PROPERTY);
            Version esxVersion = new Version(version);
            if (lowestHostVersionAvailable != null && esxVersion.compareTo(lowestHostVersionAvailable) >= 0) continue;
            lowestHost = datastoreData.connectedHost;
            lowestHostVersionAvailable = esxVersion;
        }
        if (lowestHost == null) {
            _logger.error((Object)"No connected host found.");
            return;
        }
        ManagedObjectReference storageSystemRef = (ManagedObjectReference)QueryServiceUtil.queryProperty((QueryService)this._queryService, lowestHost, (String)HOST_STORAGE_SYSTEM);
        if (storageSystemRef == null) {
            _logger.error((Object)("Failed to retrieve StorageSystem for host " + lowestHost.toString()));
            return;
        }
        StorageSystem storageSystem = (StorageSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)storageSystemRef);
        Object[] configOptions = storageSystem.queryVmfsConfigOption();
        if (!ArrayUtils.isEmpty((Object[])configOptions)) {
            reclamationOptionsData.vmfsConfigOption = configOptions[0];
        }
    }

    private void populateSupportedReclamationMethods(ReclamationOptionsData reclamationOptionsData, Map<ManagedObjectReference, Map<String, Object>> hostProperties) {
        reclamationOptionsData.fixedReclamationSupported = true;
        reclamationOptionsData.dynamicReclamationSupported = true;
        for (DatastoreData datastoreData : reclamationOptionsData.datastoresData) {
            if (datastoreData.connectedHost == null) {
                reclamationOptionsData.fixedReclamationSupported = false;
                reclamationOptionsData.dynamicReclamationSupported = false;
                reclamationOptionsData.ultralowFixedUnmapSupported = false;
                _logger.error((Object)("No connected host for datastore: " + datastoreData.datastore.toString()));
                break;
            }
            String supportedUnmapMethod = (String)hostProperties.get(datastoreData.connectedHost).get(HOST_UNMAP_METHOD_CAPABILITY_PROPERTY);
            if (supportedUnmapMethod == null || Capability.UnmapMethodSupported.priority.toString().equals(supportedUnmapMethod)) {
                reclamationOptionsData.fixedReclamationSupported = false;
                reclamationOptionsData.dynamicReclamationSupported = false;
                reclamationOptionsData.ultralowFixedUnmapSupported = false;
                break;
            }
            if (!Capability.UnmapMethodSupported.fixed.toString().equals(supportedUnmapMethod)) continue;
            reclamationOptionsData.dynamicReclamationSupported = false;
            reclamationOptionsData.ultralowFixedUnmapSupported = Boolean.TRUE.equals(hostProperties.get(datastoreData.connectedHost).get(HOST_ULTRA_LOW_FIXED_UNMAP_SUPPORTED_PROPERTY));
        }
    }

    private DatastoreData[] getConnectedHostsForDatastores(List<DatastoreProps> datastores, Map<ManagedObjectReference, Map<String, Object>> hostProperties) {
        DatastoreData[] datastoreData = new DatastoreData[datastores.size()];
        for (int i = 0; i < datastoreData.length; ++i) {
            datastoreData[i] = new DatastoreData();
            datastoreData[i].datastore = datastores.get((int)i).dsRef;
            datastoreData[i].datastoreUuid = datastores.get((int)i).uuid;
            Version lowestHostVersionAvailable = null;
            for (ManagedObjectReference mountedHost : datastores.get((int)i).mountedHosts) {
                String[] grantedPrivileges;
                Map<String, Object> mountedHostProps = hostProperties.get(mountedHost);
                if (mountedHost == null || mountedHostProps.get(HOST_CONNECTION_STATE_PROPERTY) != HostSystem.ConnectionState.connected || (grantedPrivileges = (String[])mountedHostProps.get("grantedPrivileges")) == null || !AuthorizationUtil.isPrivilegeGranted((String[])HOST_CONFIG_STORAGE_PRIVILEGE, (String[])grantedPrivileges)) continue;
                String version = (String)mountedHostProps.get(HOST_VERSION_PROPERTY);
                Version esxVersion = new Version(version);
                if (lowestHostVersionAvailable != null && esxVersion.compareTo(lowestHostVersionAvailable) >= 0) continue;
                datastoreData[i].connectedHost = mountedHost;
                lowestHostVersionAvailable = esxVersion;
            }
        }
        return datastoreData;
    }

    private List<DatastoreProps> getDatastoreProperties(ManagedObjectReference[] datastores) throws Exception {
        String[] stringArray;
        if (datastores.length == 1) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = HOST_MOUNT_PROPERTY;
            stringArray2[1] = DS_UUID_PROPERTY;
            stringArray2[2] = DS_UNMAP_PRIORITY_PROPERTY;
            stringArray = stringArray2;
            stringArray2[3] = DS_UNMAP_BANDWIDTH_PROPERTY;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = HOST_MOUNT_PROPERTY;
            stringArray = stringArray3;
            stringArray3[1] = DS_UUID_PROPERTY;
        }
        String[] propertiesToRetrieve = stringArray;
        Map dsProperties = QueryServiceUtil.queryPropertiesForMultipleObjects((QueryService)this._queryService, Arrays.asList(datastores), (String[])propertiesToRetrieve);
        ArrayList<DatastoreProps> result = new ArrayList<DatastoreProps>();
        for (ManagedObjectReference dsRef : datastores) {
            DatastoreProps datastoreData = new DatastoreProps();
            datastoreData.dsRef = dsRef;
            datastoreData.mountedHosts = new ArrayList<ManagedObjectReference>();
            result.add(datastoreData);
            if (!dsProperties.containsKey(dsRef)) continue;
            datastoreData.unmapPriority = (String)((Map)dsProperties.get(dsRef)).get(DS_UNMAP_PRIORITY_PROPERTY);
            datastoreData.uuid = (String)((Map)dsProperties.get(dsRef)).get(DS_UUID_PROPERTY);
            datastoreData.unmapBandwidthSpec = (VmfsVolume.UnmapBandwidthSpec)((Map)dsProperties.get(dsRef)).get(DS_UNMAP_BANDWIDTH_PROPERTY);
            Datastore.HostMount[] hostMounts = (Datastore.HostMount[])((Map)dsProperties.get(dsRef)).get(HOST_MOUNT_PROPERTY);
            if (hostMounts == null) continue;
            for (Datastore.HostMount hostMount : hostMounts) {
                if (hostMount == null || hostMount.mountInfo.mounted != null && !Boolean.TRUE.equals(hostMount.mountInfo.mounted)) continue;
                datastoreData.mountedHosts.add(hostMount.key);
            }
        }
        return result;
    }

    private static class DatastoreProps {
        public ManagedObjectReference dsRef;
        public List<ManagedObjectReference> mountedHosts;
        public VmfsVolume.UnmapBandwidthSpec unmapBandwidthSpec;
        public String unmapPriority;
        public String uuid;

        private DatastoreProps() {
        }
    }
}

