/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.util.internal;

import com.vmware.vim.binding.vim.host.DiskPartitionInfo;
import com.vmware.vim.binding.vim.host.VmfsDatastoreExpandSpec;
import com.vmware.vim.binding.vim.host.VmfsDatastoreOption;

public class PartitionUtil {
    private static final long BLOCK_SIZE_DEFAULT = 512L;
    private static final String PARTITION_TYPE_EMPTY = "0x00";
    private static final String PARTITION_TYPE_NONE = "none";

    public static DiskPartitionInfo.BlockRange getExtentOriginalBlockRange(DiskPartitionInfo diskInfo, VmfsDatastoreOption vmfsOption) {
        if (diskInfo == null) {
            throw new IllegalArgumentException("DiskPartitionInfo can't be null");
        }
        if (!(vmfsOption.spec instanceof VmfsDatastoreExpandSpec) || vmfsOption.spec == null) {
            return null;
        }
        VmfsDatastoreExpandSpec expandSpec = (VmfsDatastoreExpandSpec)vmfsOption.spec;
        DiskPartitionInfo.BlockRange newBlockRange = null;
        if (vmfsOption.info.layout.partition == null) {
            return null;
        }
        for (DiskPartitionInfo.BlockRange blockRange : vmfsOption.info.layout.partition) {
            if (blockRange.partition == null || blockRange.partition != expandSpec.extent.partition) continue;
            newBlockRange = blockRange;
            break;
        }
        if (newBlockRange == null) {
            return null;
        }
        if (diskInfo.layout.partition != null) {
            for (DiskPartitionInfo.BlockRange blockRange : diskInfo.layout.partition) {
                if (blockRange.start.block != newBlockRange.start.block) continue;
                return blockRange;
            }
        }
        return null;
    }

    public static long getMaxDatastoreSizeForVmfsOption(VmfsDatastoreOption option) {
        long result = 0L;
        if (option.info instanceof VmfsDatastoreOption.SingleExtentInfo) {
            VmfsDatastoreOption.SingleExtentInfo singleExtentInfo = (VmfsDatastoreOption.SingleExtentInfo)option.info;
            result = PartitionUtil.getSizeOfBlockRange(singleExtentInfo.vmfsExtent);
        } else {
            VmfsDatastoreOption.MultipleExtentInfo multipleExtentInfo = (VmfsDatastoreOption.MultipleExtentInfo)option.info;
            if (multipleExtentInfo.vmfsExtent != null) {
                for (DiskPartitionInfo.BlockRange range : multipleExtentInfo.vmfsExtent) {
                    result += PartitionUtil.getSizeOfBlockRange(range);
                }
            }
        }
        return result;
    }

    public static long getSizeOfBlockRange(DiskPartitionInfo.BlockRange range) {
        if (range == null) {
            return 0L;
        }
        long blockSize = 512L;
        if (range.start.blockSize != 0) {
            blockSize = range.start.blockSize;
        }
        long numberOfBlocks = PartitionUtil.getNumberOfBlocksForBlockRange(range);
        return numberOfBlocks * blockSize;
    }

    public static long getNumberOfBlocksForBlockRange(DiskPartitionInfo.BlockRange blockRange) {
        return blockRange.end.block - blockRange.start.block + 1L;
    }

    public static boolean isDiskEmpty(DiskPartitionInfo diskPartitionInfo) {
        if (diskPartitionInfo == null || diskPartitionInfo.layout == null || diskPartitionInfo.layout.partition == null) {
            return true;
        }
        for (DiskPartitionInfo.BlockRange block : diskPartitionInfo.layout.partition) {
            if (block.type == null || PartitionUtil.isFreePartition(block.type)) continue;
            return false;
        }
        return true;
    }

    public static boolean isFreePartition(String partitionType) {
        return PARTITION_TYPE_NONE.equals(partitionType) || PARTITION_TYPE_EMPTY.equals(partitionType);
    }

    public static boolean isChangingPartitionFormat(VmfsDatastoreOption option) {
        return option != null && option.info.partitionFormatChange != null && option.info.partitionFormatChange != false;
    }
}

