/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.computepolicy;

import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vapi.std.LocalizableMessage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vsphere.client.h5.computepolicy.model.ComputePolicyItem;
import com.vmware.vsphere.client.h5.computepolicy.model.ComputePolicyItemTag;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ComputePolicyPropertyProvider {
    private final QueryService _queryService;
    private final QueryBindingService _queryBindingService;
    private static final String NO_ASSOCIATED_OBJECTS_COUNT = "0";

    public ComputePolicyPropertyProvider(QueryServiceFactory queryServiceFactory, QueryBindingService queryBindingService) {
        this._queryService = queryServiceFactory.getQueryService();
        this._queryBindingService = queryBindingService;
    }

    @PropertyProvider(value="Folder/computePolicies")
    public List<List<ComputePolicyItem>> getComputePolicies(Collection<ManagedObjectReference> objects) {
        ArrayList<List<ComputePolicyItem>> result = new ArrayList<List<ComputePolicyItem>>(objects.size());
        ResultSet resultSet = this._queryService.select(new String[]{"policy_identifier", "policy_name", "policy_description", "policy_status", "capability_name", "capability_description", "vm_tag_identifier", "vm_tag_name", "vm_category_name", "vm_tag_association_count", "host_tag_identifier", "host_tag_name", "host_category_name", "host_tag_association_count", "group_size"}).from(new String[]{"com.vmware.vcenter.compute.policies"}).fetch();
        ArrayList<ComputePolicyItem> computePolicyItems = new ArrayList<ComputePolicyItem>(resultSet.getItems().size());
        for (ResourceItem resultItem : resultSet.getItems()) {
            ComputePolicyItem tempComputePolicyItem = new ComputePolicyItem();
            tempComputePolicyItem.id = (String)resultItem.get("policy_identifier");
            tempComputePolicyItem.name = (String)resultItem.get("policy_name");
            tempComputePolicyItem.modelId = (URI)resultItem.getKey();
            String description = (String)resultItem.get("policy_description");
            if (description == null || "".equals(description.trim())) {
                tempComputePolicyItem.defaultDescription = (LocalizableMessage)resultItem.get("capability_description");
                if (tempComputePolicyItem.defaultDescription == null) {
                    String[] parameters = new String[]{(String)resultItem.get("vm_tag_name"), (String)resultItem.get("host_tag_name")};
                    description = ResourceUtil.getString((String)"h5computepolicyservice", (String)"computePolicy.vmHostAffinity.default.description", (String[])parameters, (ClassLoader)ComputePolicyPropertyProvider.class.getClassLoader());
                }
            }
            tempComputePolicyItem.description = description;
            tempComputePolicyItem.status = (String)resultItem.get("policy_status");
            tempComputePolicyItem.type = (LocalizableMessage)resultItem.get("capability_name");
            tempComputePolicyItem.vmTag = new ComputePolicyItemTag();
            tempComputePolicyItem.vmTag.tagId = (String)resultItem.get("vm_tag_identifier");
            tempComputePolicyItem.vmTag.categoryName = (String)resultItem.get("vm_category_name");
            tempComputePolicyItem.vmTag.tagName = (String)resultItem.get("vm_tag_name");
            String string = tempComputePolicyItem.numberOfVms = resultItem.get("vm_tag_association_count") != null ? resultItem.get("vm_tag_association_count").toString() : NO_ASSOCIATED_OBJECTS_COUNT;
            if (resultItem.get("host_tag_identifier") != null) {
                tempComputePolicyItem.hostTag = new ComputePolicyItemTag();
                tempComputePolicyItem.hostTag.tagId = (String)resultItem.get("host_tag_identifier");
                tempComputePolicyItem.hostTag.categoryName = (String)resultItem.get("host_category_name");
                tempComputePolicyItem.hostTag.tagName = (String)resultItem.get("host_tag_name");
                String string2 = tempComputePolicyItem.numberOfHosts = resultItem.get("host_tag_association_count") != null ? resultItem.get("host_tag_association_count").toString() : NO_ASSOCIATED_OBJECTS_COUNT;
            }
            if (resultItem.get("group_size") != null) {
                tempComputePolicyItem.groupSize = (Long)resultItem.get("group_size");
            }
            computePolicyItems.add(tempComputePolicyItem);
        }
        Collections.sort(computePolicyItems);
        result.add(computePolicyItems);
        return result;
    }
}

