/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.computepolicy;

import com.vmware.cis.data.api.ComplexQueryService;
import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryCommand;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.util.Optional;
import com.vmware.vsphere.client.h5.computepolicy.model.ComputePolicyFilterCategoryModel;
import com.vmware.vsphere.client.h5.computepolicy.model.ComputePolicyFilterCategoryParam;
import com.vmware.vsphere.client.h5.computepolicy.model.ComputePolicyFilterTagsModel;
import com.vmware.vsphere.client.h5.computepolicy.model.ComputePolicyFilterTagsParam;
import java.util.ArrayList;
import java.util.List;

public class ComputePolicyTaggingFilterPropertyProvider
implements PropertyProviderBean {
    private final QueryService _queryService;
    private final ComplexQueryService _complexQueryService;

    public ComputePolicyTaggingFilterPropertyProvider(QueryServiceFactory queryServiceFactory, ComplexQueryService complexQueryService) {
        this._queryService = queryServiceFactory.getQueryService();
        this._complexQueryService = complexQueryService;
    }

    @ModelMetadata(type={"inventoryservice:InventoryServiceCategory"}, propertyNamespace="createPolicyDialog", property="assignableCategories")
    public ComputePolicyFilterCategoryModel[] getAssignableCategories(ManagedObjectReference categoryMor, ComputePolicyFilterCategoryParam param) {
        ResultSet resultSet;
        ArrayList<PropertyPredicate> entityPredicatesList = new ArrayList<PropertyPredicate>();
        entityPredicatesList.add(new PropertyPredicate("associableWithAllEntityTypes", PropertyPredicate.ComparisonOperator.EQUAL, (Object)true));
        entityPredicatesList.add(new PropertyPredicate("associableEntityTypeName", PropertyPredicate.ArrayOperator.ANY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)param.assignableType));
        ArrayList<PropertyPredicate> namePredicateList = null;
        if (param.categoryNameSubstring != null && !param.categoryNameSubstring.isEmpty()) {
            namePredicateList = new ArrayList<PropertyPredicate>();
            String categoryNamePattern = String.format("*%s*", param.categoryNameSubstring);
            namePredicateList.add(new PropertyPredicate("name", PropertyPredicate.ComparisonOperator.LIKE, (Object)categoryNamePattern, true));
        }
        QueryCommand.Builder queryBuilder = this.requestProperties("inventoryservice:InventoryServiceCategory", LogicalOperator.OR, entityPredicatesList);
        if (namePredicateList != null) {
            Optional nameFilter = Optional.of((Object)new Filter(namePredicateList));
            resultSet = this._complexQueryService.joinFilter(queryBuilder.build(), new Filter[]{(Filter)nameFilter.get()});
        } else {
            resultSet = queryBuilder.fetch();
        }
        ArrayList<ComputePolicyFilterCategoryModel> categoriesModelsList = new ArrayList<ComputePolicyFilterCategoryModel>(resultSet.getItems().size());
        for (ResourceItem resourceItem : resultSet.getItems()) {
            if (resourceItem == null) continue;
            ComputePolicyFilterCategoryModel catModel = new ComputePolicyFilterCategoryModel();
            catModel.categoryName = (String)resourceItem.get("name");
            catModel.categoryId = (ManagedObjectReference)resourceItem.get("@modelKey");
            categoriesModelsList.add(catModel);
        }
        return categoriesModelsList.toArray(new ComputePolicyFilterCategoryModel[0]);
    }

    @ModelMetadata(type={"inventoryservice:InventoryServiceTag"}, propertyNamespace="createPolicyDialog", property="tagsFromCategory")
    public ComputePolicyFilterTagsModel[] getTagsInCategory(ManagedObjectReference tagMor, ComputePolicyFilterTagsParam param) {
        ArrayList<PropertyPredicate> predicatesList = new ArrayList<PropertyPredicate>();
        predicatesList.add(new PropertyPredicate("category", PropertyPredicate.ComparisonOperator.EQUAL, (Object)param.categoryId));
        if (param.tagNameSubstring != null && !param.tagNameSubstring.isEmpty()) {
            String tagNamePattern = String.format("*%s*", param.tagNameSubstring);
            predicatesList.add(new PropertyPredicate("name", PropertyPredicate.ComparisonOperator.LIKE, (Object)tagNamePattern, true));
        }
        ResultSet resultSet = this.requestProperties("inventoryservice:InventoryServiceTag", LogicalOperator.AND, predicatesList).fetch();
        ArrayList<ComputePolicyFilterTagsModel> tagsModelsList = new ArrayList<ComputePolicyFilterTagsModel>(resultSet.getItems().size());
        for (ResourceItem resourceItem : resultSet.getItems()) {
            if (resourceItem == null) continue;
            ComputePolicyFilterTagsModel tagModel = new ComputePolicyFilterTagsModel();
            tagModel.tagName = (String)resourceItem.get("name");
            tagModel.tagMor = (ManagedObjectReference)resourceItem.get("@modelKey");
            tagsModelsList.add(tagModel);
        }
        return tagsModelsList.toArray(new ComputePolicyFilterTagsModel[0]);
    }

    private QueryCommand.Builder requestProperties(String model, LogicalOperator operator, List<PropertyPredicate> predicatesList) {
        return this._queryService.select(new String[]{"@modelKey", "name"}).from(new String[]{model}).where(operator, predicatesList).limit(10).orderBy("name", SortCriterion.SortDirection.ASCENDING, true);
    }
}

