/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.computepolicy;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.uri.resolve.VapiUriSchemeUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.net.URI;

public class ComputePolicyVmSummaryPropertyProvider {
    private final QueryService _queryService;

    public ComputePolicyVmSummaryPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="com.vmware.vcenter.compute.policies/computePolicyVmTagId")
    public String getComputePolicyVmTag(URI policyUri) {
        String policyId = VapiUriSchemeUtil.getId((URI)policyUri);
        ResultSet resultSet = this._queryService.select(new String[]{"vm_tag_identifier"}).from(new String[]{"com.vmware.vcenter.compute.policies"}).where(new PropertyPredicate[]{new PropertyPredicate("policy_identifier", PropertyPredicate.ComparisonOperator.EQUAL, (Object)policyId)}).fetch();
        String tagId = null;
        for (ResourceItem resourceItem : resultSet.getItems()) {
            if (resourceItem == null) continue;
            tagId = (String)resourceItem.get("vm_tag_identifier");
        }
        return tagId;
    }

    @PropertyProvider(value="VirtualMachine/isOnCloudVc")
    public boolean isOnCloudVc(ManagedObjectReference vmMor) {
        VcService vcService = VimSessionUtil.getService((String)vmMor.getServerGuid());
        return VcServiceUtil.isCloudVc((VcService)vcService);
    }
}

