/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.vmware.opsmgmt.client.event.impl.EventsTransformer;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.event.ClientEventInfo;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.derivedproperty.DerivedPropertyProviderAdapter;
import com.vmware.vsphere.client.mixed.ManagedEntityParentLocator;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientConfigIssuePropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(ClientConfigIssuePropertyProviderAdapter.class);
    private static final String[] MO_TYPES = new String[]{VmwareDistributedVirtualSwitch.class.getSimpleName(), DistributedVirtualSwitch.class.getSimpleName(), Folder.class.getSimpleName(), Datacenter.class.getSimpleName(), ComputeResource.class.getSimpleName(), HostSystem.class.getSimpleName(), VirtualMachine.class.getSimpleName(), VirtualApp.class.getSimpleName(), ClusterComputeResource.class.getSimpleName(), ResourcePool.class.getSimpleName(), Network.class.getSimpleName(), DistributedVirtualPortgroup.class.getSimpleName(), Datastore.class.getSimpleName(), StoragePod.class.getSimpleName(), OpaqueNetwork.class.getSimpleName()};
    private static final String CONFIG_ISSUE_PROP = "configIssue";
    private static final String CLIENT_CONFIG_ISSUE_PROP = "clientConfigIssue";
    private DataService _dataService;
    private final ManagedEntityParentLocator _locator;

    public ClientConfigIssuePropertyProviderAdapter(DataService dataService, ManagedEntityParentLocator locator, DataServiceExtensionRegistry extensionRegistry) {
        this._dataService = dataService;
        this._locator = locator;
        extensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        Validate.notNull((Object)propertyRequest);
        Validate.notNull((Object)propertyRequest.derivedPropertyData);
        Object[] objects = propertyRequest.objects;
        Object[] properties = propertyRequest.properties;
        if (ArrayUtils.isEmpty((Object[])objects) || ArrayUtils.isEmpty((Object[])properties)) {
            throw new IllegalArgumentException("Invalid input parameters.");
        }
        Map sourcePropertyValuesByObject = propertyRequest.derivedPropertyData.getSourcePropertyValuesByObject();
        ResultSet resultSet = new ResultSet();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        for (Object obj : objects) {
            Map sourcePropertyValuesMap = (Map)sourcePropertyValuesByObject.get(obj);
            if (sourcePropertyValuesMap == null || !(obj instanceof ManagedObjectReference)) continue;
            Object configIssue = sourcePropertyValuesMap.get(CONFIG_ISSUE_PROP);
            if (!(configIssue instanceof Event[])) {
                String exceptionMsg = String.format("'configIssue' property of managed object {%s} is not of type Event[]", obj);
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)exceptionMsg);
                }
                throw new IllegalArgumentException(exceptionMsg);
            }
            Event[] events = (Event[])configIssue;
            ManagedObjectReference moRef = (ManagedObjectReference)obj;
            ResultItem resItem = new ResultItem();
            resItem.resourceObject = obj;
            PropertyValue[] computedValues = this.calculateClientConfigIssue(moRef, events);
            resItem.properties = computedValues;
            resultItems.add(resItem);
        }
        resultSet.items = resultItems.toArray(new ResultItem[0]);
        return resultSet;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>();
        for (String type2 : MO_TYPES) {
            TypeInfo ti = new TypeInfo();
            ti.type = type2;
            ti.properties = new String[]{CLIENT_CONFIG_ISSUE_PROP};
            DerivedPropertyInfo dpi = new DerivedPropertyInfo();
            dpi.propertyName = CLIENT_CONFIG_ISSUE_PROP;
            dpi.sourcePropertyNames = new String[]{CONFIG_ISSUE_PROP};
            ti.derivedProperties = new DerivedPropertyInfo[]{dpi};
            typeInfos.add(ti);
        }
        return typeInfos.toArray(new TypeInfo[0]);
    }

    private PropertyValue[] calculateClientConfigIssue(ManagedObjectReference moRef, Event[] events) {
        ClientEventInfo[] clientEvents;
        block2: {
            clientEvents = new ClientEventInfo[]{};
            try {
                clientEvents = EventsTransformer.transformToClientEvents(this._dataService, events, moRef.getServerGuid(), this._locator, null);
            }
            catch (Exception e) {
                if (!_logger.isErrorEnabled()) break block2;
                _logger.error((Object)"Cannot compute clientConfigIssue.", (Throwable)e);
            }
        }
        PropertyValue pv = new PropertyValue();
        pv.propertyName = CLIENT_CONFIG_ISSUE_PROP;
        pv.value = clientEvents;
        pv.resourceObject = moRef;
        return new PropertyValue[]{pv};
    }
}

