/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.vmware.opsmgmt.client.commons.util.ManagedObjectTypes;
import com.vmware.opsmgmt.client.event.impl.BaseEventProcessor;
import com.vmware.opsmgmt.client.event.impl.EventFilter;
import com.vmware.opsmgmt.client.event.impl.EventsTransformer;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventHistoryCollector;
import com.vmware.vim.binding.vim.event.EventManager;
import com.vmware.vim.binding.vim.event.TaskEvent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.event.ClientEventInfo;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.task.TaskSearchHelper;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.mixed.ManagedEntityParentLocator;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientEventProcessor
extends BaseEventProcessor {
    private static final Log _logger = LogFactory.getLog(ClientEventProcessor.class);
    private static final int NUMBER_OF_EVENTS_IN_PAGE = 100;
    private static final int MAXIMUM_NUMBER_OF_PAGES_SMALL = 10;
    private static final int MAXIMUM_NUMBER_OF_PAGES_BIG = 5;
    private static final int NUMBER_OF_VCS_THRESHOLD = 5;
    private final ManagedEntityParentLocator _locator;
    private final DataService _dataService;
    private final TaskSearchHelper _taskSearchHelper;
    @Nonnull
    private final ExecutorService _executorService;

    public ClientEventProcessor(ManagedEntityParentLocator locator, DataService dataService, DataServiceExtensionRegistry registry, TaskSearchHelper taskSearchHelper, @Nonnull ExecutorService executorService) {
        super(registry);
        Validate.notNull((Object)executorService);
        this._locator = locator;
        this._dataService = dataService;
        this._taskSearchHelper = taskSearchHelper;
        this._executorService = executorService;
    }

    @Override
    protected ResultSet processFilter(EventFilter filter, ResultSet resultSet, QuerySpec spec) {
        if (StringUtils.isNotEmpty((CharSequence)filter.serverGuid)) {
            return this.populateResultSet(filter, resultSet, spec);
        }
        if (filter.count > 100) {
            filter.count = 100;
        }
        List<VcService> vcServices = this.getServices(filter);
        List<VcEvent> serverEvents = new ArrayList<VcEvent>();
        try {
            for (VcService vcService : vcServices) {
                this.extractEventsFromVc(vcService, vcServices.size(), filter, serverEvents);
            }
            Comparator<VcEvent> comparatorByCreatedTimeDesc = Comparator.comparing(VcEvent::getCreatedTime, Comparator.nullsLast(Comparator.reverseOrder())).thenComparingInt(VcEvent::getKey);
            Collections.sort(serverEvents, comparatorByCreatedTimeDesc);
            int startIndex = filter.count * filter.requestedPage;
            serverEvents = startIndex < serverEvents.size() ? serverEvents.subList(startIndex, Math.min(startIndex + filter.count, serverEvents.size())) : Collections.emptyList();
            HashMap<ManagedObjectReference, List<Event>> eventsByVc = new HashMap<ManagedObjectReference, List<Event>>();
            for (VcEvent event : serverEvents) {
                ArrayList<Event> events = (ArrayList<Event>)eventsByVc.get(event.rootFolder);
                if (events == null) {
                    events = new ArrayList<Event>();
                    eventsByVc.put(event.rootFolder, events);
                }
                events.add(event.event);
            }
            ArrayList<MethodFault> postProcessErrors = new ArrayList<MethodFault>();
            List<ResultItem> resultList = this.processEventsResult(eventsByVc, postProcessErrors, spec);
            Exception processedErrors = this.processErrorResult(null, postProcessErrors);
            ResultItem[] newResults = resultList.toArray(new ResultItem[resultList.size()]);
            resultSet.items = newResults;
            resultSet.totalMatchedObjectCount = resultSet.items.length;
            resultSet.error = processedErrors;
        }
        catch (Exception e) {
            resultSet.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return resultSet;
    }

    public void close() {
        this._executorService.shutdown();
    }

    @Override
    protected TypeInfo getTypeInfo() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = BaseEventProcessor.EVENT_TYPE;
        typeInfo.properties = new String[]{"info", "taskInfoName", "contextSensitiveMessage"};
        return typeInfo;
    }

    @Override
    protected List<ResultItem> processEventsResult(Map<ManagedObjectReference, List<Event>> events, List<MethodFault> faults, QuerySpec spec) {
        ArrayList<ClientEventInfo> clientEventInfos = new ArrayList<ClientEventInfo>();
        ArrayList<Future<ClientEventResult>> futures = new ArrayList<Future<ClientEventResult>>();
        for (Map.Entry<ManagedObjectReference, List<Event>> entry : events.entrySet()) {
            ClientEventCallable eventTransformCallable = new ClientEventCallable(entry.getKey(), entry.getValue());
            futures.add(this._executorService.submit(eventTransformCallable));
        }
        for (Future future : futures) {
            try {
                ClientEventResult futureResult = (ClientEventResult)future.get();
                ClientEventInfo[] clientEventInfoArray = futureResult.clientEventInfo;
                int n = clientEventInfoArray.length;
                for (int i = 0; i < n; ++i) {
                    ClientEventInfo currentEvent = clientEventInfoArray[i];
                    clientEventInfos.add(currentEvent);
                }
                faults.addAll(futureResult.methodFault);
            }
            catch (InterruptedException | ExecutionException ex) {
                _logger.warn((Object)String.format("The retrieval of the client events failed. Error = %s ", ex.getMessage()));
                faults.add(MixedUtil.getMethodFault((Throwable)ex));
            }
        }
        ArrayList<ResultItem> result = new ArrayList<ResultItem>();
        HashSet<String> hashSet = new HashSet<String>();
        for (PropertySpec ps : spec.resourceSpec.propertySpecs) {
            if (!ps.type.equals(EVENT_TYPE)) continue;
            hashSet.addAll(Arrays.asList(ps.propertyNames));
        }
        ManagedObjectReference contextObject = this.getContextObjectFromQuery(spec);
        for (ClientEventInfo currentEvent : clientEventInfos) {
            ArrayList<PropertyValue> resultPropertyValues = new ArrayList<PropertyValue>();
            if (hashSet.contains("info")) {
                PropertyValue infoPropertyValue = this.createPropertyValue("info", currentEvent);
                resultPropertyValues.add(infoPropertyValue);
            }
            if (hashSet.contains("taskInfoName")) {
                String taskInfoName = this.getTaskInfoName(currentEvent);
                PropertyValue taskNamePropertyValue = this.createPropertyValue("taskInfoName", taskInfoName);
                resultPropertyValues.add(taskNamePropertyValue);
            }
            if (hashSet.contains("contextSensitiveMessage")) {
                String message = this.getContextSensitiveMessage(currentEvent, contextObject);
                PropertyValue messagePropertyValue = this.createPropertyValue("contextSensitiveMessage", message);
                resultPropertyValues.add(messagePropertyValue);
            }
            ResultItem item = new ResultItem();
            item.properties = resultPropertyValues.toArray(new PropertyValue[resultPropertyValues.size()]);
            try {
                item.resourceObject = new URI("TODO:" + currentEvent.key + currentEvent.serverGuid);
            }
            catch (Exception ex) {
                faults.add(MixedUtil.getMethodFault((Throwable)ex));
                continue;
            }
            result.add(item);
        }
        return result;
    }

    private void extractEventsFromVc(VcService vcService, int numVcs, EventFilter filter, List<VcEvent> serverEvents) throws Exception {
        ManagedObjectReference rootFolder = ManagedObjectUtil.getRootFolder((String)vcService.getServiceGuid());
        EventManager eventManager = (EventManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vcService.getServiceInstanceContent().eventManager);
        ManagedObjectReference collectorRef = eventManager.createCollector(filter.eventFilterSpec);
        EventHistoryCollector collector = (EventHistoryCollector)ManagedObjectUtil.getManagedObject((ManagedObjectReference)collectorRef);
        collector.setLatestPageSize(filter.count);
        collector.reset();
        if (filter.requestedPage == 0) {
            this.getLatestPage(collector, rootFolder, serverEvents);
        } else {
            int maximumPagesToRetrieve = numVcs > 5 ? Math.min(5, filter.requestedPage) : Math.min(10, filter.requestedPage);
            this.getLatestPage(collector, rootFolder, serverEvents);
            for (int i = 0; i < maximumPagesToRetrieve; ++i) {
                Event[] nextPage = collector.readPrev(filter.count);
                if (nextPage == null) continue;
                for (Event event : nextPage) {
                    serverEvents.add(new VcEvent(event, rootFolder));
                }
            }
        }
    }

    private ManagedObjectReference getContextObjectFromQuery(QuerySpec query) {
        for (PropertySpec propertySpec : query.resourceSpec.propertySpecs) {
            if (!propertySpec.type.equals(EVENT_TYPE)) continue;
            for (ParameterSpec parameterSpec : propertySpec.parameters) {
                if (!parameterSpec.propertyName.equals("contextObject")) continue;
                return (ManagedObjectReference)parameterSpec.parameter;
            }
        }
        return null;
    }

    private String getContextSensitiveMessage(ClientEventInfo event, ManagedObjectReference contextObject) {
        if (contextObject == null) {
            if (event.eventDetail == null) {
                return event.fullFormattedMessage;
            }
            return event.eventDetail.fullFormat;
        }
        String result = "";
        ManagedObjectTypes contextObjectType = ManagedObjectTypes.getValueOf((String)contextObject.getType());
        switch (contextObjectType) {
            case VIRTUAL_MACHINE: {
                result = event.eventDetail.formatOnVm;
                break;
            }
            case HOST: {
                result = event.eventDetail.formatOnHost;
                break;
            }
            case COMPUTE_RESOURCE: {
                result = event.eventDetail.formatOnComputeResource;
                break;
            }
            case DATACENTER: {
                result = event.eventDetail.formatOnDatacenter;
                break;
            }
            case DATASTORE: {
                result = event.eventDetail.formatOnDatacenter;
                break;
            }
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            return event.eventDetail.fullFormat;
        }
        return result;
    }

    private String getTaskInfoName(ClientEventInfo event) {
        if (event.isTaskEvent.booleanValue()) {
            TaskEvent taskEvent = (TaskEvent)event.serverEvent;
            if (taskEvent.info != null) {
                return this._taskSearchHelper.getTaskDescription(taskEvent.info);
            }
        }
        return null;
    }

    private void getLatestPage(EventHistoryCollector collector, ManagedObjectReference rootFolder, List<VcEvent> serverEvents) {
        Event[] latestPage = collector.getLatestPage();
        if (latestPage != null) {
            for (Event event : latestPage) {
                serverEvents.add(new VcEvent(event, rootFolder));
            }
        }
    }

    private PropertyValue createPropertyValue(String propertyName, Object value) {
        PropertyValue pv = new PropertyValue();
        pv.propertyName = propertyName;
        pv.value = value;
        return pv;
    }

    private static class VcEvent {
        private Event event;
        private ManagedObjectReference rootFolder;

        private VcEvent(Event event, ManagedObjectReference rootFolder) {
            this.event = event;
            this.rootFolder = rootFolder;
        }

        Calendar getCreatedTime() {
            return this.event.createdTime;
        }

        int getKey() {
            return this.event.key;
        }
    }

    protected class ClientEventCallable
    implements Callable<ClientEventResult> {
        protected final ManagedObjectReference _vcMor;
        protected final List<Event> _clientEvents;
        protected final SessionUtil.ThreadContext sessionThreadCtx;

        public ClientEventCallable(ManagedObjectReference mor, List<Event> clientEvents) {
            this._vcMor = mor;
            this._clientEvents = clientEvents;
            this.sessionThreadCtx = SessionUtil.getThreadContext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClientEventResult call() throws Exception {
            ClientEventResult result;
            SessionUtil.ThreadContext originalThreadCtx = SessionUtil.getThreadContext();
            try {
                SessionUtil.setThreadContext((SessionUtil.ThreadContext)this.sessionThreadCtx);
                List<Event> serverEvents = this._clientEvents;
                ArrayList<MethodFault> faults = new ArrayList<MethodFault>();
                ClientEventInfo[] clientEventInfos = EventsTransformer.transformToClientEvents(ClientEventProcessor.this._dataService, serverEvents.toArray(new Event[serverEvents.size()]), this._vcMor.getServerGuid(), ClientEventProcessor.this._locator, faults);
                result = new ClientEventResult();
                result.clientEventInfo = clientEventInfos;
                result.methodFault = faults;
            }
            finally {
                SessionUtil.setThreadContext((SessionUtil.ThreadContext)originalThreadCtx);
            }
            return result;
        }
    }

    protected static class ClientEventResult {
        protected ClientEventInfo[] clientEventInfo;
        protected List<MethodFault> methodFault;

        protected ClientEventResult() {
        }
    }
}

