/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.vmware.opsmgmt.client.commons.util.ManagedObjectTypes;
import com.vmware.opsmgmt.client.event.EventDetailDescription;
import com.vmware.opsmgmt.client.event.impl.EventDetailDescriptionStore;
import com.vmware.vim.binding.vim.ElementDescription;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.event.EventDescription;
import com.vmware.vim.binding.vim.event.EventEx;
import com.vmware.vim.binding.vim.event.EventManager;
import com.vmware.vim.binding.vim.event.ExtendedEvent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventDescriptionCollector {
    private static final Log _logger = LogFactory.getLog(EventDescriptionCollector.class);
    private static final CacheLoader<Context, EventDescriptionCollector> COLLECTOR_LOADER = new CacheLoader<Context, EventDescriptionCollector>(){

        public EventDescriptionCollector load(Context context) throws Exception {
            if (_logger.isInfoEnabled()) {
                _logger.info((Object)("No event description data found for VC with GUID " + context._serverGuid + " and locale " + context._localeId + ". Load it from the server and store it in memory."));
            }
            EventManager manager = EventDescriptionCollector.getEventManagerInstance(context._serverGuid);
            EventDescriptionCollector collector = new EventDescriptionCollector(manager, context._dataService);
            return collector;
        }
    };
    private static final LoadingCache<Context, EventDescriptionCollector> COLLECTORS_BY_LOCALE_AND_VC = CacheBuilder.newBuilder().softValues().build(COLLECTOR_LOADER);
    private final Map<String, ElementDescription> _categoryDescriptions;
    private EventDetailDescriptionStore _store;

    static EventDescriptionCollector getEventDetailDescriptionCollector(String serverGuid, DataService dataService) throws Exception {
        String localeId = ResourceUtil.getLocale().toString();
        Context context = new Context(localeId, serverGuid, dataService);
        Object hasInvalidatedDataForThisSession = SessionUtil.setDataIfAbsent((String)context.toString(), (Object)Boolean.TRUE);
        if (hasInvalidatedDataForThisSession == null) {
            COLLECTORS_BY_LOCALE_AND_VC.refresh((Object)context);
        }
        EventDescriptionCollector collector = (EventDescriptionCollector)COLLECTORS_BY_LOCALE_AND_VC.get((Object)context);
        return collector;
    }

    private EventDescriptionCollector(EventManager manager, DataService dataService) {
        if (manager == null) {
            throw new IllegalArgumentException("Not initialized EventManager instance.");
        }
        this._categoryDescriptions = new HashMap<String, ElementDescription>();
        this.buildStore(manager, dataService);
    }

    private void buildStore(EventManager manager, DataService dataService) {
        EventDescription eventDescription = this.loadEventDetails(manager);
        this.extractCategoryDescriptions(eventDescription);
        this._store = this.createStore(dataService, eventDescription);
    }

    EventDetailDescription[] collectDetails(String[] eventTypeIds, String serverGuid) throws Exception {
        EventDetailDescription[] descriptions = this._store.getByIds(eventTypeIds);
        EventDescriptionCollector.addArgumentData(descriptions, EventDescriptionCollector.getEventManagerInstance(serverGuid));
        return descriptions;
    }

    EventDetailDescription[] collectDetails(String[] eventTypeIds) {
        EventDetailDescription[] descriptions = this._store.getByIds(eventTypeIds);
        return descriptions;
    }

    EventDetailDescription[] collectDetails(ManagedObjectTypes objectType, String serverGuid) throws Exception {
        EventDetailDescription[] descriptions = this._store.getByType(objectType);
        EventDescriptionCollector.addArgumentData(descriptions, EventDescriptionCollector.getEventManagerInstance(serverGuid));
        return descriptions;
    }

    EventDetailDescription[] collectDetails(ManagedObjectTypes objectType) {
        EventDetailDescription[] descriptions = this._store.getByType(objectType);
        return descriptions;
    }

    private static void addArgumentData(EventDetailDescription[] descriptions, EventManager manager) {
        if (descriptions != null && descriptions.length > 1) {
            for (EventDetailDescription description : descriptions) {
                if (description.eventArguments != null) continue;
                description.eventArguments = manager.retrieveArgumentDescription(description.eventTypeId);
            }
        }
    }

    private void extractCategoryDescriptions(EventDescription eventDescription) {
        ElementDescription[] categoryDescriptions = eventDescription.getCategory();
        if (categoryDescriptions == null || categoryDescriptions.length == 0) {
            return;
        }
        for (ElementDescription categoryElement : categoryDescriptions) {
            this._categoryDescriptions.put(categoryElement.label, categoryElement);
        }
    }

    private EventDescription loadEventDetails(EventManager manager) {
        EventDescription eventDescription = manager.getDescription();
        EventDescription.EventDetail[] eventDetails = eventDescription.getEventInfo();
        if (eventDetails == null || eventDetails.length == 0) {
            throw new RuntimeException("No details are found in server: " + manager._getRef().getServerGuid());
        }
        return eventDescription;
    }

    private EventDetailDescriptionStore createStore(DataService dataService, EventDescription eventDescription) {
        EventDetailDescriptionStore store = new EventDetailDescriptionStore();
        Map<String, Set<String>> moTypesByEventId = this.getEventClassification(dataService);
        for (EventDescription.EventDetail singleEvent : eventDescription.getEventInfo()) {
            if (singleEvent.key == null) continue;
            EventDetailDescription eventDetailDescription = this.extractDetails(singleEvent);
            Set<String> moTypes = moTypesByEventId.get(eventDetailDescription.eventTypeId);
            if (moTypes != null && moTypes.size() != 0) {
                for (String moType : moTypes) {
                    ManagedObjectTypes type2;
                    try {
                        type2 = ManagedObjectTypes.getValueOf((String)moType);
                    }
                    catch (Exception ex) {
                        _logger.warn((Object)("No enum value for " + moType));
                        type2 = ManagedObjectTypes.MANAGED_ENTITY;
                    }
                    store.putDescription(type2, eventDetailDescription);
                }
                continue;
            }
            store.putDescription(ManagedObjectTypes.MANAGED_ENTITY, eventDetailDescription);
        }
        return store;
    }

    private EventDetailDescription extractDetails(EventDescription.EventDetail eventDetails) {
        EventDetailDescription result = new EventDetailDescription();
        result.eventTypeId = this.getEventTypeId(eventDetails);
        result.eventDescription = StringUtils.isNotEmpty((CharSequence)eventDetails.description) ? eventDetails.description : (StringUtils.isNotEmpty((CharSequence)result.eventTypeId) ? result.eventTypeId : eventDetails.key.getName());
        result.eventDetail = eventDetails;
        result.categoryDescription = this._categoryDescriptions.get(eventDetails.category);
        return result;
    }

    private String getEventTypeId(EventDescription.EventDetail detail) {
        String eventTypeId = null;
        String keyName = detail.getKey().getName();
        if (ExtendedEvent.class.getName().equals(keyName) || EventEx.class.getName().equals(keyName)) {
            if (StringUtils.isNotEmpty((CharSequence)detail.fullFormat)) {
                int delimiterPosition = detail.fullFormat.indexOf("|");
                eventTypeId = delimiterPosition != -1 ? detail.fullFormat.substring(0, delimiterPosition) : detail.fullFormat;
            }
        } else {
            eventTypeId = keyName;
        }
        return eventTypeId;
    }

    private Map<String, Set<String>> getEventClassification(DataService dataService) {
        Constraint constraint = new Constraint();
        constraint.targetType = "EventClassification";
        QuerySpec querySpec = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{"allEvents"});
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = dataService.getData(requestSpec);
        Map<String, Set<String>> result = this.processEventClassificationResults(response.resultSet);
        if (result == null) {
            result = new HashMap<String, Set<String>>();
        }
        return result;
    }

    private Map<String, Set<String>> processEventClassificationResults(ResultSet[] results) {
        if (ArrayUtils.isEmpty((Object[])results)) {
            _logger.error((Object)"Empty result for EventClassification.allEvents");
            return null;
        }
        Map eventClassification = null;
        for (ResultSet result : results) {
            if (ArrayUtils.isEmpty((Object[])result.items)) {
                _logger.warn((Object)"Empty ResultSet.items");
                continue;
            }
            for (ResultItem resultItem : result.items) {
                Object[] properties = resultItem.properties;
                if (ArrayUtils.isEmpty((Object[])properties)) continue;
                for (Object property : properties) {
                    Map events = (Map)((PropertyValue)property).value;
                    if (eventClassification != null) {
                        this.combineMaps(events, eventClassification);
                        continue;
                    }
                    eventClassification = events;
                }
            }
        }
        return eventClassification;
    }

    private void combineMaps(Map<String, Set<String>> fromMap, Map<String, Set<String>> toMap) {
        for (Map.Entry<String, Set<String>> fromEntry : fromMap.entrySet()) {
            Set<String> toValueSet = toMap.get(fromEntry.getKey());
            if (toValueSet == null) {
                toValueSet = new HashSet<String>();
                toMap.put(fromEntry.getKey(), toValueSet);
            }
            toValueSet.addAll((Collection<String>)fromEntry.getValue());
        }
    }

    private static EventManager getEventManagerInstance(String serverGuid) throws Exception {
        VcService service = VimSessionUtil.getService((String)serverGuid);
        ServiceInstanceContent content = service.getServiceInstanceContent();
        return (EventManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)content.eventManager);
    }

    private static class Context {
        private final String _localeId;
        private final String _serverGuid;
        private transient DataService _dataService;

        Context(String localeId, String serverGuid, DataService dataService) {
            this._localeId = localeId;
            this._serverGuid = serverGuid;
            this._dataService = dataService;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Context)) {
                return false;
            }
            Context other = (Context)obj;
            return this._localeId.equals(other._localeId) && this._serverGuid.equals(other._serverGuid);
        }

        public int hashCode() {
            return Objects.hash(this._localeId, this._serverGuid);
        }

        public String toString() {
            return "Event description context for " + this._localeId + "@" + this._serverGuid;
        }
    }
}

