/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl.i18n;

import com.vmware.opsmgmt.client.event.impl.EntityEventArgumentWrapper;
import com.vmware.opsmgmt.client.event.impl.i18n.MessageParserUtil;
import com.vmware.opsmgmt.client.event.util.Util;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.event.ChangesInfoEventArgument;
import com.vmware.vim.binding.vim.event.EntityEventArgument;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventEx;
import com.vmware.vim.binding.vim.event.ExtendedEvent;
import com.vmware.vim.binding.vim.event.HostEventArgument;
import com.vmware.vim.binding.vim.event.VmEventArgument;
import com.vmware.vim.binding.vim.fault.VimFault;
import com.vmware.vim.binding.vim.vm.Message;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageParser {
    private static final Log _logger = LogFactory.getLog(MessageParser.class);
    private static final String FT_PRIMARY_NAME_SUFFIX = "\\p";
    private static final String FT_PRIMARY_NAME_KEY_SUFFIX = "ft.primary.suffix";
    private static final String FT_SECONDARY_NAME_SUFFIX = "\\s";
    private static final String FT_SECONDARY_NAME_KEY_SUFFIX = "ft.secondary.suffix";
    private static final String TYPE_DELIMITER = "|";
    private static final String ENUM_DELIMITER = "@";
    private static final String TASK_DESCRIPTION_PROPERTY_NAME = "descriptionId";
    private static final String VM_MESSAGE_FIELD = "message";
    private static final String VM_FAULT_FIELD = "fault";
    private static final String VM_MESSAGE_INFO_FIELD = "messageInfo";
    private static final String DVS_PORT_KEY_FIELD = "portKey";
    private static final String DVS_CHANGES_INFO_FIELD = "configChanges";
    private List<EntityEventArgumentWrapper> _eventArgumentWrappers = new ArrayList<EntityEventArgumentWrapper>();
    private final Event _serverEvent;
    private String _fullFormattedMessage = "";
    private String _linkableFormattedMessage = "";

    public MessageParser(Event serverEvent) {
        this._serverEvent = serverEvent;
    }

    public String getFullFormattedMessage() {
        return this._fullFormattedMessage;
    }

    public String getLinkableFormattedMessage() {
        return this._linkableFormattedMessage;
    }

    public List<EntityEventArgumentWrapper> getArguments() {
        return this._eventArgumentWrappers;
    }

    public String fixFtName(String name) {
        String resultName = name;
        resultName = this.getVmName(resultName, FT_PRIMARY_NAME_SUFFIX, FT_PRIMARY_NAME_KEY_SUFFIX);
        resultName = this.getVmName(resultName, FT_SECONDARY_NAME_SUFFIX, FT_SECONDARY_NAME_KEY_SUFFIX);
        return resultName;
    }

    public void parse(String message) {
        String[] tokens;
        int indexOfType = message.indexOf(TYPE_DELIMITER);
        if (indexOfType > -1) {
            message = message.substring(indexOfType + 1);
        }
        this._fullFormattedMessage = message;
        this._linkableFormattedMessage = message;
        for (String token : tokens = MessageParserUtil.collectSubstitutionVariables(message)) {
            String arguments = token.substring(1, token.length() - 1);
            if (arguments.trim().length() <= 0) continue;
            String lookup = "";
            int indexOfEnum = arguments.indexOf(ENUM_DELIMITER);
            if (indexOfEnum > 0) {
                lookup = arguments.substring(indexOfEnum + 1);
                arguments = arguments.substring(0, indexOfEnum - 1);
            }
            EntityEventArgumentWrapper argumentWrapper = new EntityEventArgumentWrapper();
            String replaceString = this.formatReplacementString(arguments, lookup, argumentWrapper);
            this._fullFormattedMessage = this.replace(this._fullFormattedMessage, token, replaceString);
            if (!argumentWrapper.isInventoryObject()) {
                this._linkableFormattedMessage = this.replace(this._linkableFormattedMessage, token, replaceString);
                continue;
            }
            this._eventArgumentWrappers.add(argumentWrapper);
        }
    }

    private String formatReplacementString(String arguments, String lookup, EntityEventArgumentWrapper argumentWrapper) {
        String[] args;
        String lastPath;
        String result = "";
        EntityEventArgument argumentValue = this.extractEventExArgumentValue(arguments);
        boolean argumentFound = argumentValue != null;
        Object[] objects = null;
        Object entity = null;
        if (!argumentFound && !ArrayUtils.isEmpty((Object[])(objects = this.resolveValues(this._serverEvent, arguments.split("\\."))))) {
            argumentValue = objects[objects.length - 1];
        }
        if (argumentValue == null) {
            return result;
        }
        if (lookup.contains("enum.")) {
            String key = String.format("%s.%s.label", lookup.substring(lookup.indexOf(".") + 1), String.valueOf(argumentValue));
            result = this.stringNotFound(LocalizationUtil.getLocalizedMessage((String)key, null), key);
        } else if (argumentValue instanceof EntityEventArgument || argumentValue instanceof HostEventArgument) {
            entity = argumentValue;
        } else if (argumentValue instanceof Date) {
            result = DateFormat.getDateTimeInstance(0, 1, ResourceUtil.getLocale()).format((Date)argumentValue);
        } else {
            if (argumentValue instanceof Calendar) {
                return DateFormat.getDateTimeInstance(0, 1, ResourceUtil.getLocale()).format(((Calendar)argumentValue).getTime());
            }
            EntityEventArgument entities = this.entityEventArgumentArray(argumentValue);
            if (entities != null) {
                if (((EntityEventArgument[])entities).length > 1) {
                    result = result + " ...";
                }
                entity = ((EntityEventArgument[])entities).length > 0 ? entities[0] : entities;
            } else {
                String localizedValue = argumentValue instanceof String ? LocalizationUtil.getLocalizedMessage((String)((String)argumentValue)) : "";
                String string = result = StringUtils.isEmpty((CharSequence)localizedValue) ? String.valueOf(argumentValue) : localizedValue;
            }
        }
        if (entity == null) {
            entity = objects == null || objects.length < 2 ? result : objects[objects.length - 2];
        }
        if (entity instanceof EntityEventArgument) {
            EntityEventArgument arg = entity;
            argumentWrapper.setArgumnents(arg);
            if (argumentFound) {
                result = arg.name;
            }
        } else if (entity instanceof TaskInfo && TASK_DESCRIPTION_PROPERTY_NAME.equals(lastPath = (args = arguments.split("\\."))[args.length - 1])) {
            String key = String.format("%s.label", String.valueOf(argumentValue));
            result = this.stringNotFound(LocalizationUtil.getLocalizedMessage((String)key, null), key);
        }
        return result;
    }

    private Object extractEventExArgumentValue(String key) {
        Object result = null;
        if (this._serverEvent instanceof EventEx) {
            EventEx eventEx = (EventEx)this._serverEvent;
            if (eventEx.arguments != null) {
                for (KeyAnyValue keyValue : eventEx.arguments) {
                    if (!keyValue.getKey().equals(key)) continue;
                    result = keyValue.getValue();
                    break;
                }
            }
        }
        return result;
    }

    private EntityEventArgument[] entityEventArgumentArray(Object entity) {
        Class<?> componentType;
        if (entity != null && entity.getClass().isArray() && EntityEventArgument.class.isAssignableFrom(componentType = entity.getClass().getComponentType())) {
            return (EntityEventArgument[])entity;
        }
        return null;
    }

    private String replace(String message, String pattern, String token) {
        token = this.fixFtVmName(this._serverEvent.vm, token);
        token = MixedUtil.unescapeVimEntityNameSpecialChars((String)token);
        message = message.replace(pattern, token);
        return message;
    }

    private Object[] resolveValues(Object source, String[] paths) {
        if (source == null) {
            return null;
        }
        if (paths.length == 0) {
            return new Object[]{source};
        }
        Object[] result = new Object[paths.length];
        Object newSource = null;
        for (int index = 0; index < paths.length; ++index) {
            String singlePath = paths[index];
            try {
                String localizedMsgInfo = this.extractLocalizedMessageInfo(source, paths);
                if (localizedMsgInfo != null) {
                    return new Object[]{localizedMsgInfo};
                }
                String localizedChangesInfo = this.extractLocalizedChangesInfo(source, paths);
                if (localizedChangesInfo != null) {
                    return new Object[]{localizedChangesInfo};
                }
                String localizedFault = this.extractLocalizedFault(source, paths);
                if (localizedFault != null) {
                    return new Object[]{localizedFault};
                }
                newSource = this.getValue(newSource != null ? newSource : source, singlePath);
                boolean resolved = false;
                if (newSource instanceof String[]) {
                    result[index] = StringUtils.join((Object[])((String[])newSource), (String)", ");
                    resolved = true;
                }
                if (resolved) continue;
                result[index] = newSource;
                continue;
            }
            catch (Exception ex) {
                if (!_logger.isWarnEnabled()) continue;
                _logger.warn((Object)("Failed to resolve path: " + singlePath + ", from paths: " + Arrays.toString(paths)));
            }
        }
        if (result[0] == null) {
            result[0] = Util.getLocalizedString("eventAttribute.notSpecified");
        } else if (result[0].getClass().isArray() && result[0] instanceof ExtendedEvent.Pair[]) {
            ExtendedEvent.Pair[] pairs = (ExtendedEvent.Pair[])result[0];
            for (int index = 0; index < pairs.length; ++index) {
                ExtendedEvent.Pair currentPair = pairs[index];
                if (currentPair.key.compareToIgnoreCase(paths[1]) != 0) continue;
                return new Object[]{currentPair.value};
            }
        }
        return result;
    }

    private String extractLocalizedMessageInfo(Object source, String[] paths) {
        block5: {
            if (paths.length == 1 && paths[0].equals(VM_MESSAGE_FIELD)) {
                Object childSource = this.getValue(source, VM_MESSAGE_INFO_FIELD);
                if (childSource == null) {
                    return null;
                }
                if (!(childSource instanceof Object[])) {
                    return null;
                }
                try {
                    Object[] nativeArray = (Object[])childSource;
                    Message msg = (Message)nativeArray[0];
                    return msg.text;
                }
                catch (RuntimeException e) {
                    if (!_logger.isWarnEnabled()) break block5;
                    _logger.warn((Object)("Unexpected failure in extractLocalizedMessageInfo for " + childSource), (Throwable)e);
                }
            }
        }
        return null;
    }

    private String extractLocalizedChangesInfo(Object source, String[] paths) {
        if (paths.length != 1 || !paths[0].equals(DVS_CHANGES_INFO_FIELD)) {
            return null;
        }
        Object portKeysSource = this.getValue(source, DVS_PORT_KEY_FIELD);
        if (portKeysSource == null || !(portKeysSource instanceof String[])) {
            return Util.getLocalizedString("eventAttribute.notSpecified");
        }
        String[] portKeys = (String[])portKeysSource;
        Object changesInfoSource = this.getValue(source, DVS_CHANGES_INFO_FIELD);
        if (changesInfoSource == null || !(changesInfoSource instanceof ChangesInfoEventArgument[])) {
            return Util.getLocalizedString("eventAttribute.notSpecified");
        }
        ChangesInfoEventArgument[] changesInfo = (ChangesInfoEventArgument[])changesInfoSource;
        if (portKeys.length != changesInfo.length) {
            return Util.getLocalizedString("eventAttribute.notSpecified");
        }
        String changeFormat = Util.getLocalizedString("dvsPortGroupChangeFormat");
        Object[] result = new String[portKeys.length];
        for (int i = 0; i < portKeys.length; ++i) {
            String portKey = portKeys[i];
            ChangesInfoEventArgument change = changesInfo[i];
            String added = this.getDefaultString(change.added);
            String modified = this.getDefaultString(change.modified);
            String deleted = this.getDefaultString(change.deleted);
            result[i] = String.format(changeFormat, portKey, added, modified, deleted);
        }
        return StringUtils.join((Object[])result, (String)"\n");
    }

    private String extractLocalizedFault(Object source, String[] paths) {
        if (paths.length != 1 || !VM_FAULT_FIELD.equals(paths[0])) {
            return null;
        }
        Object fault = this.getValue(source, VM_FAULT_FIELD);
        if (fault == null || !(fault instanceof VimFault)) {
            return null;
        }
        LocalizableMessage[] faultLocalizableMessages = ((VimFault)fault).getFaultMessage();
        if (faultLocalizableMessages == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < faultLocalizableMessages.length; ++i) {
            LocalizableMessage localizableMessage = faultLocalizableMessages[i];
            stringBuilder.append(this.localize(localizableMessage));
            if (i >= faultLocalizableMessages.length - 1) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    private String localize(LocalizableMessage message) {
        if (!ArrayUtils.isEmpty((Object[])message.getArg())) {
            return LocalizationUtil.getLocalizedMessage((String)message.getKey(), (KeyAnyValue[])message.getArg());
        }
        return LocalizationUtil.getLocalizedMessage((String)message.getKey());
    }

    private String getDefaultString(String input) {
        return StringUtils.isEmpty((CharSequence)input) ? Util.getLocalizedString("eventAttribute.notSpecified") : input;
    }

    private String stringNotFound(String searchedString, String key) {
        if (StringUtils.isNotEmpty((CharSequence)searchedString)) {
            return searchedString;
        }
        String result = null;
        result = String.format("%s %s %s", "XXX", key, "XXX");
        return result;
    }

    private String fixFtVmName(VmEventArgument vmArgument, String vmName) {
        if (StringUtils.isEmpty((CharSequence)vmName) || vmArgument == null || !vmName.equals(vmArgument.name)) {
            return vmName;
        }
        String name = this.fixFtName(vmName);
        vmArgument.setName(name);
        return name;
    }

    private String getVmName(String name, String suffix, String key) {
        String ftPrimarySuffix;
        int pos = name.indexOf(suffix);
        if (pos >= 0 && (ftPrimarySuffix = LocalizationUtil.getLocalizedMessage((String)key, null)) != null) {
            name = name.replace(suffix, ftPrimarySuffix);
        }
        return name;
    }

    public Object getValue(Object instance, String propertyName) {
        try {
            Object value = PropertyUtils.getProperty((Object)instance, (String)propertyName);
            if (value instanceof Calendar) {
                return ((Calendar)value).getTime();
            }
            return value;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            _logger.warn((Object)("Could not read property " + propertyName + " of object " + instance), (Throwable)ex);
            return null;
        }
    }
}

