/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.tagging.impl;

import com.vmware.vim.binding.dataservice.QName;
import com.vmware.vim.binding.dataservice.fault.AlreadyExistsFault;
import com.vmware.vim.binding.dataservice.tagging.CategoryInfo;
import com.vmware.vim.binding.impl.dataservice.QNameImpl;
import com.vmware.vim.binding.impl.dataservice.tagging.CategoryInfoImpl;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.search.impl.NamespaceUtils;
import com.vmware.vise.util.xml.NamespaceUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.tagging.CategoryCreateSpec;
import com.vmware.vsphere.client.tagging.TagService;
import com.vmware.vsphere.client.tagging.TagServiceLocator;
import com.vmware.vsphere.client.tagging.Util;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CategoryMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(CategoryMutationProvider.class);
    private static final String DEFAULT_NAMESPACE_PREFIX = "urn:";
    private final TagServiceLocator _tagServiceLocator;

    public CategoryMutationProvider(TagServiceLocator tagServiceLocator) {
        this._tagServiceLocator = tagServiceLocator;
    }

    private static QName[] typeSpecsToQNames(String[] specs) {
        if (specs == null) {
            return null;
        }
        LinkedList<QNameImpl> names = new LinkedList<QNameImpl>();
        for (String spec : specs) {
            String namespace = DEFAULT_NAMESPACE_PREFIX + NamespaceUtils.getNamespace((String)spec);
            String unqualifiedName = NamespaceUtil.getUnqualifiedTypeName((String)spec);
            QNameImpl name = new QNameImpl(namespace, unqualifiedName);
            names.add(name);
        }
        return names.toArray(new QName[names.size()]);
    }

    public OperationResult add(CategoryCreateSpec spec) {
        return this.addMulti(new CategoryCreateSpec[]{spec})[0];
    }

    public OperationResult[] addMulti(CategoryCreateSpec[] specs) {
        LinkedList<OperationResult> results = new LinkedList<OperationResult>();
        try {
            Util.checkNotNull(specs, "specs");
            if (specs.length > 0) {
                for (CategoryCreateSpec spec : specs) {
                    TagService service = this._tagServiceLocator.getTagService(null);
                    OperationResult r = new OperationResult();
                    r.entity = r.result = this.createCategory(service, spec);
                    results.add(r);
                }
            }
        }
        catch (Exception e) {
            _logger.error((Object)"A problem occurred while creating categories", (Throwable)e);
            OperationResult r = new OperationResult();
            r.error = e.getCause() instanceof InvalidArgument ? MixedUtil.getRuntimeFault((String)Util.getLocalizedString("error.invalidNameInput")) : (e.getCause() instanceof AlreadyExistsFault ? MixedUtil.getRuntimeFault((String)Util.getLocalizedString("tag.create.form.error.category.duplicate")) : MixedUtil.getMethodFault((Throwable)e));
            results.add(r);
        }
        return results.toArray(new OperationResult[results.size()]);
    }

    public OperationResult apply(ManagedObjectReference moRef, CategoryCreateSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = moRef;
        try {
            Util.checkNotNull(moRef, "moRef");
            Util.checkNotNull(spec, "spec");
            TagService service = this._tagServiceLocator.getTagService(null);
            CategoryInfoImpl info = new CategoryInfoImpl();
            info.setName(spec.categoryName);
            info.setDescription(spec.categoryDescription);
            info.setCardinality(spec.multipleCardinality ? CategoryInfo.Cardinality.multiple : CategoryInfo.Cardinality.single);
            QName[] entityTypes = CategoryMutationProvider.typeSpecsToQNames(spec.associableEntityTypes);
            info.setAssociableEntityType(entityTypes);
            service.updateCategory(moRef, (CategoryInfo)info);
        }
        catch (Exception e) {
            _logger.error((Object)"A problem occurred while updating category details", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult remove(ManagedObjectReference moRef, CategoryCreateSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = moRef;
        try {
            Util.checkNotNull(moRef, "moRef");
            TagService service = this._tagServiceLocator.getTagService(null);
            service.deleteCategory(moRef);
        }
        catch (Exception e) {
            _logger.error((Object)"A problem occurred while deleting a category", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    private ManagedObjectReference createCategory(TagService service, CategoryCreateSpec spec) throws InterruptedException, ExecutionException {
        CategoryInfoImpl info = new CategoryInfoImpl();
        info.setName(spec.categoryName);
        info.setDescription(spec.categoryDescription);
        info.setCardinality(spec.multipleCardinality ? CategoryInfo.Cardinality.multiple : CategoryInfo.Cardinality.single);
        QName[] entityTypes = CategoryMutationProvider.typeSpecsToQNames(spec.associableEntityTypes);
        info.setAssociableEntityType(entityTypes);
        return service.createCategory((CategoryInfo)info);
    }
}

