/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vapp.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.cluster.ConfigInfoEx;
import com.vmware.vim.binding.vim.cluster.DrsConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.h5.vapp.data.SourceVappData;
import com.vmware.vsphere.client.h5.vapp.data.ValidateDestinationSpec;
import com.vmware.vsphere.client.h5.vapp.data.ValidateMoveVappSpec;
import com.vmware.vsphere.client.h5.vapp.data.ValidateNameAndFolderSpec;
import com.vmware.vsphere.client.h5.vapp.data.ValidateSourceVappSpec;
import com.vmware.vsphere.client.h5.vapp.error.VappValidationError;
import com.vmware.vsphere.client.h5.vapp.model.VappMoveEntityData;
import com.vmware.vsphere.client.h5.vapp.util.VappStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class VappMutationProvider
implements MutationProvider {
    private static final String PRIVILEGE_VAPP_MOVE = "VApp.Move";
    private static final String PRIVILEGE_VAPP_CREATE = "VApp.Create";
    private static final String PRIVILEGE_ASSIGN_VAPP_TO_POOL = "Resource.AssignVAppToPool";
    private static final String PRIVILEGE_ASSIGN_VAPP_TO_VAPP = "VApp.AssignVApp";
    private final QueryBindingService _queryBindingService;
    private final QueryService _queryService;

    public VappMutationProvider(QueryBindingServiceFactory queryBindingServiceFactory, QueryServiceFactory queryServiceFactory) {
        this._queryBindingService = queryBindingServiceFactory.getQueryBindingService();
        this._queryService = queryServiceFactory.getQueryService();
    }

    public ValidationResult validate(ManagedObjectReference moRef, ValidateMoveVappSpec moveSpec) throws VappValidationError {
        ValidationResult result = new ValidationResult();
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, Folder.class)) {
            result = this.runFolderCheck(moRef, moveSpec);
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, VirtualApp.class)) {
            result = this.runVappCheck(moRef, moveSpec);
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, ResourcePool.class)) {
            result = this.runResourcePoolCheck(moRef, moveSpec);
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, Datacenter.class)) {
            result = this.runDatacenterCheck(moRef, moveSpec);
        }
        if (result.result != null) {
            return result;
        }
        result = this.checkMoveVappPrivileges(moRef);
        return result;
    }

    public ValidationResult validate(ValidateNameAndFolderSpec spec) {
        ValidationResult result = new ValidationResult();
        try {
            this.checkNameAndLocationSpeck(spec);
            ManagedObjectReference folderRef = this.getLocation(spec);
            if (folderRef == null) {
                throw new VappValidationError(VappStringUtil.getString("NewVAppNameFolderPage.folderDoesNotExist"));
            }
            this.checkNameAndLocationUniqueName(spec, folderRef);
            this.checkNameAndLocationPrivileges(folderRef);
            result.result = folderRef;
        }
        catch (VappValidationError e) {
            result.error = e;
        }
        return result;
    }

    public ValidationResult validate(ValidateSourceVappSpec spec) {
        ValidationResult result = new ValidationResult();
        try {
            this.checkVappNotNull(spec);
            ManagedObjectReference selectedRef = ManagedObjectUtil.stringToMoref((String)spec.sourceVappId);
            result.entity = selectedRef;
            this.checkVappType(selectedRef);
            ArrayList<ManagedObjectReference> destination = new ArrayList<ManagedObjectReference>(Arrays.asList(selectedRef));
            Collection sourceVappData = this._queryBindingService.prepare(SourceVappData.class).fetch(destination);
            SourceVappData vappData = (SourceVappData)sourceVappData.iterator().next();
            result.result = vappData;
            this.checkChildVms(vappData);
        }
        catch (VappValidationError e) {
            result.error = e;
        }
        return result;
    }

    public ValidationResult validate(ValidateDestinationSpec spec) {
        ValidationResult result = new ValidationResult();
        ManagedObjectReference selectedDestinationRef = ManagedObjectUtil.stringToMoref((String)spec.destinationId);
        result.entity = selectedDestinationRef;
        try {
            this.checkDestinationNotNull(spec);
            this.checkValidDestinationType(selectedDestinationRef);
            this.checkDestinationNotSameAsSource(spec, selectedDestinationRef);
            DestinationResourceData destinationData = this.getDestinationResourceData(selectedDestinationRef);
            this.checkHostRuntimeState(destinationData);
            this.checkDrsState(destinationData);
            this.checkResourcePoolPrivileges(destinationData);
            ValidateDestinationSpec.Result r = new ValidateDestinationSpec.Result();
            r.resourcePool = ManagedObjectUtil.isOfType((ManagedObjectReference)selectedDestinationRef, VirtualApp.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)selectedDestinationRef, ResourcePool.class) ? selectedDestinationRef : destinationData.computeResourceData.rootResourcePool;
            if (ManagedObjectUtil.isOfType((ManagedObjectReference)selectedDestinationRef, HostSystem.class)) {
                r.host = selectedDestinationRef;
            } else if (destinationData.computeResourceData.hosts.length > 0) {
                r.host = destinationData.computeResourceData.hosts[0];
            }
            r.environmentBrowser = destinationData.computeResourceData.environmentBrowser;
            result.result = r;
        }
        catch (VappValidationError e) {
            result.error = e;
        }
        return result;
    }

    private ValidationResult runFolderCheck(ManagedObjectReference target, ValidateMoveVappSpec moveSpec) {
        ArrayList<ManagedObjectReference> destination = new ArrayList<ManagedObjectReference>(Arrays.asList(target));
        Collection folderData = this._queryBindingService.prepare(FolderDatacenterData.class).fetch(destination);
        ManagedObjectReference datacenter = ((FolderDatacenterData)folderData.iterator().next()).datacenter;
        return this.runDatacenterCheck(datacenter, moveSpec);
    }

    private ValidationResult runDatacenterCheck(ManagedObjectReference datacenter, ValidateMoveVappSpec moveSpec) {
        ValidationResult result = new ValidationResult();
        ArrayList<ManagedObjectReference> list = new ArrayList<ManagedObjectReference>(Arrays.asList(moveSpec.entities));
        Collection moveEntitiesData = this._queryBindingService.prepare(VappMoveEntityData.class).fetch(list);
        for (VappMoveEntityData moveData : moveEntitiesData) {
            if (moveData.datacenter.equals((Object)datacenter)) continue;
            result.result = VappStringUtil.getString("MoveVAppValidation.moveOutsideOfDatacenterError");
            return result;
        }
        return result;
    }

    private ValidationResult runResourcePoolCheck(ManagedObjectReference target, ValidateMoveVappSpec moveSpec) {
        ValidationResult result = new ValidationResult();
        ArrayList<ManagedObjectReference> list = new ArrayList<ManagedObjectReference>(Arrays.asList(moveSpec.entities));
        Collection moveEntitiesData = this._queryBindingService.prepare(VappMoveEntityData.class).fetch(list);
        ArrayList<ManagedObjectReference> destination = new ArrayList<ManagedObjectReference>(Arrays.asList(target));
        Collection rpData = this._queryBindingService.prepare(ResourcePoolData.class).fetch(destination);
        ManagedObjectReference owner = ((ResourcePoolData)rpData.iterator().next()).owner;
        for (ManagedObjectReference[] moveData : moveEntitiesData) {
            if (moveData.owner.equals((Object)owner)) continue;
            result.result = VappStringUtil.getString("MoveVAppValidation.moveOutsideOfClusterOrHostError");
            return result;
        }
        for (ManagedObjectReference[] moveData : moveEntitiesData) {
            if (!moveData.parent.equals((Object)target)) continue;
            result.result = VappStringUtil.getString("MoveVAppValidation.targetIsParentError");
            return result;
        }
        ManagedObjectReference targetParent = ((ResourcePoolData)rpData.iterator().next()).parent;
        for (ManagedObjectReference moveEntity : moveSpec.entities) {
            if (!moveEntity.equals((Object)targetParent)) continue;
            result.result = VappStringUtil.getString("MoveVAppValidation.targetIsParentError");
            return result;
        }
        ManagedObjectReference[] ancestorRp = ((ResourcePoolData)rpData.iterator().next()).ancestorRp;
        for (ManagedObjectReference moveEntity : moveSpec.entities) {
            for (ManagedObjectReference arp : ancestorRp) {
                if (!moveEntity.equals((Object)arp)) continue;
                result.result = VappStringUtil.getString("MoveVAppValidation.targetNestedValidationError");
                return result;
            }
        }
        return result;
    }

    private ValidationResult runVappCheck(ManagedObjectReference target, ValidateMoveVappSpec moveSpec) {
        return this.runResourcePoolCheck(target, moveSpec);
    }

    private ValidationResult checkMoveVappPrivileges(ManagedObjectReference target) throws VappValidationError {
        ValidationResult result = new ValidationResult();
        String reqPrivilege = PRIVILEGE_VAPP_MOVE;
        String targetErrorMessage = VappStringUtil.getString("MoveVAppValidation.vappMovePrivilegeError");
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, ResourcePool.class)) {
            reqPrivilege = PRIVILEGE_ASSIGN_VAPP_TO_POOL;
            targetErrorMessage = VappStringUtil.getString("MoveVAppValidation.targetResourcePoolPrivilegeError");
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, VirtualApp.class)) {
            reqPrivilege = PRIVILEGE_ASSIGN_VAPP_TO_VAPP;
            targetErrorMessage = VappStringUtil.getString("MoveVAppValidation.targetVAppPrivilegeError");
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, Datacenter.class)) {
            target = this.getDatacenterVmFolder(target);
        }
        if (!this.hasPrivileges(target, new String[]{reqPrivilege})) {
            result.result = targetErrorMessage;
        }
        return result;
    }

    private void checkNameAndLocationSpeck(ValidateNameAndFolderSpec spec) throws VappValidationError {
        if (StringUtils.isEmpty((String)spec.name)) {
            throw new VappValidationError(VappStringUtil.getString("NewVAppNameFolderPage.errorNameEmpty"));
        }
        if (StringUtils.isEmpty((String)spec.locationId)) {
            throw new VappValidationError(VappStringUtil.getString("NewVAppNameFolderPage.noSelection"));
        }
        ManagedObjectReference locationRef = ManagedObjectUtil.stringToMoref((String)spec.locationId);
        if (!(ManagedObjectUtil.isOfType((ManagedObjectReference)locationRef, Datacenter.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)locationRef, Folder.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)locationRef, ResourcePool.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)locationRef, VirtualApp.class))) {
            throw new VappValidationError(VappStringUtil.getString("NewVAppNameFolderPage.noSelection"));
        }
    }

    private void checkNameAndLocationUniqueName(ValidateNameAndFolderSpec spec, ManagedObjectReference locationRef) throws VappValidationError {
        String parentPropertyName = ManagedObjectUtil.isOfType((ManagedObjectReference)locationRef, Datacenter.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)locationRef, Folder.class) ? "parentFolder" : "parent";
        ResultSet rs = this._queryService.select(new String[]{"@modelKey"}).from(new String[]{VirtualApp.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate(parentPropertyName, PropertyPredicate.ComparisonOperator.EQUAL, (Object)locationRef), new PropertyPredicate("name", PropertyPredicate.ComparisonOperator.EQUAL, (Object)spec.name)}).fetch();
        if (rs.getItems().size() > 0) {
            throw new VappValidationError(VappStringUtil.getString("NewVAppNameFolderPage.errorNameNotUnique"));
        }
    }

    private ManagedObjectReference getLocation(ValidateNameAndFolderSpec spec) {
        ManagedObjectReference ref = ManagedObjectUtil.stringToMoref((String)spec.locationId);
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)ref, Datacenter.class)) {
            ResultSet rs = this._queryService.select(new String[]{"vmFolder"}).from(new String[]{Datacenter.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)ref)}).fetch();
            if (rs.getItems().size() == 0) {
                return null;
            }
            return (ManagedObjectReference)((ResourceItem)rs.getItems().get(0)).get("vmFolder");
        }
        ResultSet rs = this._queryService.select(new String[]{"@modelKey"}).from(new String[]{Folder.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)ref)}).fetch();
        if (rs.getItems().size() == 0) {
            return null;
        }
        return (ManagedObjectReference)((ResourceItem)rs.getItems().get(0)).get("@modelKey");
    }

    private ManagedObjectReference getDatacenterVmFolder(ManagedObjectReference datacenter) {
        ResultSet rs = this._queryService.select(new String[]{"vmFolder"}).from(new String[]{Datacenter.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)datacenter)}).fetch();
        if (rs.getItems().size() == 0) {
            return null;
        }
        return (ManagedObjectReference)((ResourceItem)rs.getItems().get(0)).get("vmFolder");
    }

    private void checkNameAndLocationPrivileges(ManagedObjectReference folderRef) throws VappValidationError {
        if (!this.hasPrivileges(folderRef, new String[]{PRIVILEGE_VAPP_CREATE})) {
            throw new VappValidationError(VappStringUtil.getString("NewVAppNameFolderPage.errorNoPrivilege"));
        }
    }

    private void checkVappNotNull(ValidateSourceVappSpec spec) throws VappValidationError {
        if (StringUtils.isEmpty((String)spec.sourceVappId)) {
            throw new VappValidationError(VappStringUtil.getString("NewVAppSourcePage.errorNoSelection"));
        }
    }

    private void checkVappType(ManagedObjectReference ref) throws VappValidationError {
        if (!ManagedObjectUtil.isOfType((ManagedObjectReference)ref, VirtualApp.class)) {
            throw new VappValidationError(VappStringUtil.getString("NewVAppSourcePage.errorInvalidSelection"));
        }
    }

    private void checkChildVms(SourceVappData vappData) throws VappValidationError {
        if (vappData.vms == null || vappData.vms.length == 0) {
            throw new VappValidationError(VappStringUtil.getString("NewVAppSourcePage.noVms"));
        }
    }

    private void checkDestinationNotNull(ValidateDestinationSpec spec) throws VappValidationError {
        if (StringUtils.isEmpty((String)spec.destinationId)) {
            throw new VappValidationError(VappStringUtil.getString("NewVAppDestinationPage.errorNoSelection"));
        }
    }

    private void checkValidDestinationType(ManagedObjectReference ref) throws VappValidationError {
        if (!(ManagedObjectUtil.isOfType((ManagedObjectReference)ref, VirtualApp.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)ref, ResourcePool.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)ref, ClusterComputeResource.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)ref, HostSystem.class))) {
            throw new VappValidationError(VappStringUtil.getString("NewVAppDestinationPage.errorInvalidSelection"));
        }
    }

    private void checkDestinationNotSameAsSource(ValidateDestinationSpec spec, ManagedObjectReference selectedDestinationRef) throws VappValidationError {
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)selectedDestinationRef, VirtualApp.class) && spec.destinationId.equals(spec.sourceVappId)) {
            throw new VappValidationError(VappStringUtil.getString("NewVAppDestinationPage.errorCloneSameAsSource"));
        }
    }

    private DestinationResourceData getDestinationResourceData(ManagedObjectReference selectedDestinationRef) throws VappValidationError {
        ManagedObjectReference target = null;
        DestinationResourceData destinationData = new DestinationResourceData();
        destinationData.destination = selectedDestinationRef;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)selectedDestinationRef, ClusterComputeResource.class)) {
            target = selectedDestinationRef;
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)selectedDestinationRef, HostSystem.class)) {
            HostSystemData hostData;
            destinationData.hostSystemData = hostData = (HostSystemData)this._queryBindingService.prepare(HostSystemData.class).fetch((Object)selectedDestinationRef);
            target = hostData.parent;
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)selectedDestinationRef, ResourcePool.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)selectedDestinationRef, VirtualApp.class)) {
            ResourcePoolData rpData;
            destinationData.resourcePoolData = rpData = (ResourcePoolData)this._queryBindingService.prepare(ResourcePoolData.class).fetch((Object)selectedDestinationRef);
            target = rpData.owner;
        } else {
            throw new VappValidationError(VappStringUtil.getString("NewVAppDestinationPage.errorInvalidSelection"));
        }
        destinationData.computeResourceData = (ComputeResourceData)this._queryBindingService.prepare(ComputeResourceData.class).fetch((Object)target);
        return destinationData;
    }

    private void checkHostRuntimeState(DestinationResourceData destinationData) throws VappValidationError {
        ComputeResourceData computeResourceData = destinationData.computeResourceData;
        ManagedObjectReference selectedDestinationRef = destinationData.destination;
        if (computeResourceData.hosts == null || computeResourceData.hosts.length == 0) {
            throw new VappValidationError(VappStringUtil.getString("NewVAppDestinationPage.errorNoConnectedHosts"));
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)selectedDestinationRef, HostSystem.class) && !this.canCreateVappOnHost(destinationData.hostSystemData)) {
            throw new VappValidationError(VappStringUtil.getString("NewVAppDestinationPage.errorHostNotConnected"));
        }
        if (computeResourceData.environmentBrowser == null) {
            if (computeResourceData.configuration instanceof ConfigInfoEx) {
                if (ManagedObjectUtil.isOfType((ManagedObjectReference)selectedDestinationRef, ClusterComputeResource.class)) {
                    throw new VappValidationError(VappStringUtil.getString("NewVAppDestinationPage.errorNoConnectedHosts"));
                }
                throw new VappValidationError(VappStringUtil.getString("NewVAppDestinationPage.errorParentClusterNoConnectedHosts"));
            }
            throw new VappValidationError(VappStringUtil.getString("NewVAppDestinationPage.errorParentHostNotConnected"));
        }
    }

    private boolean canCreateVappOnHost(HostSystemData hostData) {
        return HostSystem.ConnectionState.connected.equals((Object)hostData.connectionState) && !Boolean.TRUE.equals(hostData.inMaintenanceMode);
    }

    private void checkDrsState(DestinationResourceData destinationData) throws VappValidationError {
        ComputeResourceData computeResourceData = destinationData.computeResourceData;
        ManagedObjectReference selectedDestinationRef = destinationData.destination;
        if (!(computeResourceData.configuration instanceof ConfigInfoEx)) {
            return;
        }
        DrsConfigInfo drsConfig = ((ConfigInfoEx)computeResourceData.configuration).drsConfig;
        if (!drsConfig.enabled.booleanValue()) {
            throw new VappValidationError(VappStringUtil.getString("NewVAppDestinationPage.errorNonDrsCluster"));
        }
        if (!this.hasPrivileges(selectedDestinationRef, new String[]{PRIVILEGE_VAPP_CREATE})) {
            throw new VappValidationError(VappStringUtil.getString("NewVAppDestinationPage.errorNoHostPrivilege"));
        }
    }

    private void checkResourcePoolPrivileges(DestinationResourceData destinationData) throws VappValidationError {
        ComputeResourceData computeResourceData = destinationData.computeResourceData;
        ManagedObjectReference selectedDestinationRef = destinationData.destination;
        ManagedObjectReference resourcePool = ManagedObjectUtil.isOfType((ManagedObjectReference)selectedDestinationRef, ClusterComputeResource.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)selectedDestinationRef, HostSystem.class) ? computeResourceData.rootResourcePool : selectedDestinationRef;
        String[] privileges = new String[]{};
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)resourcePool, ResourcePool.class)) {
            privileges = new String[]{PRIVILEGE_ASSIGN_VAPP_TO_POOL};
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)resourcePool, VirtualApp.class)) {
            privileges = new String[]{"VApp.Clone", PRIVILEGE_ASSIGN_VAPP_TO_VAPP};
        }
        if (!this.hasPrivileges(resourcePool, privileges)) {
            throw new VappValidationError(VappStringUtil.getString("NewVAppDestinationPage.errorNoPrivilege"));
        }
    }

    private boolean hasPrivileges(ManagedObjectReference object, String[] privileges) {
        ResourceItem result = (ResourceItem)this._queryService.select(new String[]{"grantedPrivileges"}).from(new String[]{object.getType()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)object).fetch().getItems().iterator().next();
        boolean hasPrivileges = true;
        if (result != null) {
            String[] grantedPrivileges = (String[])result.get("grantedPrivileges");
            hasPrivileges = AuthorizationUtil.isPrivilegeGranted((String[])privileges, (String[])grantedPrivileges);
        }
        return hasPrivileges;
    }

    @QueryBinding(value="HostSystem")
    static class HostSystemData {
        @Property(value="HostSystem/runtime/connectionState")
        HostSystem.ConnectionState connectionState;
        @Property(value="HostSystem/inMaintenanceMode")
        Boolean inMaintenanceMode;
        @Property(value="HostSystem/parent")
        ManagedObjectReference parent;

        HostSystemData() {
        }
    }

    @QueryBinding(value="AnyResourcePool")
    static class ResourcePoolData {
        @Property(value="AnyResourcePool/owner")
        ManagedObjectReference owner;
        @Property(value="AnyResourcePool/parent")
        ManagedObjectReference parent;
        @Property(value="AnyResourcePool/ancestorRp")
        ManagedObjectReference[] ancestorRp;

        ResourcePoolData() {
        }
    }

    @QueryBinding(value="Folder")
    static class FolderDatacenterData {
        @Property(value="Folder/dc")
        ManagedObjectReference datacenter;

        FolderDatacenterData() {
        }
    }

    @QueryBinding(value="AnyComputeResource")
    static class ComputeResourceData {
        @Property(value="AnyComputeResource/resourcePool")
        ManagedObjectReference rootResourcePool;
        @Property(value="AnyComputeResource/host")
        ManagedObjectReference[] hosts;
        @Property(value="AnyComputeResource/configurationEx")
        ComputeResource.ConfigInfo configuration;
        @Property(value="AnyComputeResource/environmentBrowser")
        ManagedObjectReference environmentBrowser;

        ComputeResourceData() {
        }
    }

    private class DestinationResourceData {
        public ManagedObjectReference destination;
        public ComputeResourceData computeResourceData;
        public HostSystemData hostSystemData;
        public ResourcePoolData resourcePoolData;

        private DestinationResourceData() {
        }
    }
}

