/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vapp.impl;

import com.vmware.vim.binding.vim.ResourceConfigSpec;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.vApp.EntityConfigInfo;
import com.vmware.vim.binding.vim.vApp.PropertySpec;
import com.vmware.vim.binding.vim.vApp.VAppConfigSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.vapp.VAppCloneSpec;
import com.vmware.vsphere.client.vapp.VAppCreateSpec;
import com.vmware.vsphere.client.vapp.VAppPowerOperationSpec;
import com.vmware.vsphere.client.vapp.VAppRemovalSpec;
import com.vmware.vsphere.client.vapp.impl.VAppConfig;
import com.vmware.vsphere.client.vapp.impl.VAppPowerOperations;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VAppMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(VAppMutationProvider.class);
    private DataService _dataService;

    public VAppMutationProvider(DataService dataService) {
        this._dataService = dataService;
    }

    public OperationResult add(VAppCreateSpec spec) {
        OperationResult result = new OperationResult();
        if (spec == null) {
            _logger.error((Object)"VAppCreateSpec is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        if (spec.resourcePool == null) {
            _logger.error((Object)"Target resource pool is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        result.entity = spec.resourcePool;
        VAppConfigSpec vAppConfigSpec = new VAppConfigSpec();
        vAppConfigSpec.property = new PropertySpec[0];
        vAppConfigSpec.entityConfig = new EntityConfigInfo[0];
        String name = "";
        try {
            ResourcePool resourcePool = (ResourcePool)ManagedObjectUtil.getManagedObject((ManagedObjectReference)spec.resourcePool);
            name = MixedUtil.escapeVimEntityNameSpecialChars((String)spec.name);
            ManagedObjectReference newVApp = resourcePool.createVApp(name, spec.resourceConfigSpec, vAppConfigSpec, spec.folder);
            result.result = newVApp;
            QueryUtil.waitUntilSearchable((DataService)this._dataService, (Object)result.result, (String[])new String[]{"parent"});
        }
        catch (Exception ex) {
            _logger.error((Object)"Error creating vApp", (Throwable)ex);
            _logger.error((Object)String.format("createVApp arguments:\nname=%s\nresourceConfigSpec=%s\nvAppConfigSpec=%s\nfolder=%s", name, spec.resourceConfigSpec.toString(), vAppConfigSpec, spec.folder));
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult add(VAppCloneSpec spec) {
        OperationResult result = new OperationResult();
        if (spec == null) {
            _logger.error((Object)"VAppCloneSpec is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        if (spec.source == null) {
            _logger.error((Object)"Source vApp is null");
            result.error = MixedUtil.getInvalidEntityFault();
            return result;
        }
        result.entity = spec.source;
        try {
            VirtualApp vApp = (VirtualApp)ManagedObjectUtil.getManagedObject((ManagedObjectReference)spec.source);
            String name = MixedUtil.escapeVimEntityNameSpecialChars((String)spec.name);
            ManagedObjectReference task = vApp.clone(name, spec.target, spec.cloneSpec);
            result.task = task;
        }
        catch (Exception ex) {
            _logger.error((Object)"Error cloning vApp", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vAppRef, VAppPowerOperationSpec spec) {
        return VAppPowerOperations.applyPowerOperation(vAppRef, spec);
    }

    public OperationResult apply(ManagedObjectReference vAppRef, VAppConfigSpec spec) {
        return VAppConfig.update(vAppRef, spec);
    }

    public OperationResult apply(ManagedObjectReference vAppRef, ResourceConfigSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vAppRef;
        try {
            VirtualApp vApp = (VirtualApp)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vAppRef);
            vApp.updateConfig(null, spec);
        }
        catch (Exception ex) {
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult remove(ManagedObjectReference vAppRef, VAppRemovalSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = vAppRef;
        try {
            VirtualApp vApp = (VirtualApp)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vAppRef);
            opResult.task = spec.deleteFromDisk != null && spec.deleteFromDisk.booleanValue() ? vApp.destroy() : vApp.unregister();
        }
        catch (Exception e) {
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }
}

