/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.eam;

import com.vmware.eam.util.EamUtil;
import com.vmware.vim.binding.eam.Agency;
import com.vmware.vim.binding.eam.EamObject;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AgencyData {
    private static final Log _logger = LogFactory.getLog(AgencyData.class);
    public String goalState;
    public ManagedEntity.Status status = ManagedEntity.Status.gray;
    public String name;
    public ManagedObjectReference agencyRef;
    public boolean optimizedDeploy;
    public ManagedObjectReference clusterRef;
    public String solutionId;

    public AgencyData(Agency agency, ManagedObjectReference agencyRef) {
        ManagedObjectReference[] computeResources;
        Validate.notNull((Object)agency);
        Validate.notNull((Object)agencyRef);
        Agency.ConfigInfo agencyConfig = agency.getConfig();
        this.name = agencyConfig.getAgencyName();
        Boolean optimizedDeploymentEnabled = agencyConfig.optimizedDeploymentEnabled;
        this.optimizedDeploy = optimizedDeploymentEnabled != null ? optimizedDeploymentEnabled.booleanValue() : Boolean.FALSE.booleanValue();
        EamObject.RuntimeInfo agencyRungtime = agency.getRuntime();
        this.goalState = AgencyData.getLocalizedGoalStateDescription(agencyRungtime.goalState);
        String status = agencyRungtime.getStatus();
        if (StringUtils.isEmpty((CharSequence)status)) {
            _logger.error((Object)("Agency '" + this.name + "'gave a null or empty status value."));
        } else {
            try {
                this.status = ManagedEntity.Status.valueOf((String)status);
            }
            catch (IllegalArgumentException e) {
                _logger.error((Object)("Unknown EAM agency status value likely indicates an unsupported change in EAM VMODL. The offending value is '" + agencyRungtime.getStatus() + "'"));
            }
        }
        this.agencyRef = agencyRef;
        Agency.Scope agencyScope = agencyConfig.getScope();
        if (agencyScope instanceof Agency.ComputeResourceScope && (computeResources = ((Agency.ComputeResourceScope)agencyScope).computeResource) != null && computeResources.length == 1 && ClusterComputeResource.class.getSimpleName().equals(computeResources[0].getType())) {
            this.clusterRef = computeResources[0];
            if (this.clusterRef.getServerGuid() == null) {
                this.clusterRef.setServerGuid(agencyRef.getServerGuid());
            }
        }
        this.solutionId = agency.getSolutionId();
    }

    public AgencyData() {
    }

    private static String getLocalizedGoalStateDescription(String goalState) {
        String key;
        switch (EamObject.RuntimeInfo.GoalState.valueOf((String)goalState)) {
            case disabled: {
                key = "eamObject.runtimeInfo.goalState.disabled";
                break;
            }
            case enabled: {
                key = "eamObject.runtimeInfo.goalState.enabled";
                break;
            }
            case uninstalled: {
                key = "eamObject.runtimeInfo.goalState.uninstalled";
                break;
            }
            default: {
                key = "eamObject.runtimeInfo.goalState.unknown";
                _logger.error((Object)"Unknown EamObject.RuntimeInfo.GoalState value");
            }
        }
        return EamUtil.getLocalizedString(key, new String[0]);
    }
}

