/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.eam.impl;

import com.vmware.eam.AgencyData;
import com.vmware.eam.util.EamConnection;
import com.vmware.eam.util.EamUtil;
import com.vmware.vim.binding.eam.Agency;
import com.vmware.vim.binding.eam.EsxAgentManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vsphere.client.vcextension.common.ExtensionUriSpec;
import com.vmware.vsphere.client.vcextension.common.VcExtensionConnection;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;

public class EamPropertyProvider
implements PropertyProviderBean {
    @type(value="VcExtension")
    public boolean getIsEam(URI extensionUri) {
        Validate.notNull((Object)extensionUri);
        ExtensionUriSpec extension = new ExtensionUriSpec(extensionUri);
        return "com.vmware.vim.eam".equals(extension.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @type(value="VcExtension")
    public boolean getHasEamAgency(URI extensionUri) throws Exception {
        Validate.notNull((Object)extensionUri);
        ExtensionUriSpec extension = new ExtensionUriSpec(extensionUri);
        if ("com.vmware.vim.eam".equals(extension.getKey())) {
            return false;
        }
        EamConnection eamConnection = null;
        try {
            eamConnection = EamConnection.newInstance(extension.getServerGuid());
            EsxAgentManager eam = eamConnection.getEsxAgentManager();
            Object[] agencies = eam.getAgency();
            if (!ArrayUtils.isEmpty((Object[])agencies)) {
                for (Object agencyRef : agencies) {
                    Agency agency = eamConnection.getAgency((ManagedObjectReference)agencyRef);
                    if (!agency.getSolutionId().equals(extension.getKey())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            EamConnection.tryClose((VcExtensionConnection)eamConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @type(value="VcExtension")
    public AgencyData[] getAgencies(URI extensionUri) throws Exception {
        Validate.notNull((Object)extensionUri);
        ExtensionUriSpec extension = new ExtensionUriSpec(extensionUri);
        EamConnection eamConnection = null;
        try {
            eamConnection = EamConnection.newInstance(extension.getServerGuid());
            EsxAgentManager eam = eamConnection.getEsxAgentManager();
            Object[] agencies = eam.getAgency();
            if (ArrayUtils.isEmpty((Object[])agencies)) {
                AgencyData[] agencyDataArray = new AgencyData[]{};
                return agencyDataArray;
            }
            ArrayList<AgencyData> result = new ArrayList<AgencyData>();
            boolean isEam = extension.getKey().equals("com.vmware.vim.eam");
            for (Object agencyRef : agencies) {
                Agency agency = eamConnection.getAgency((ManagedObjectReference)agencyRef);
                if (!isEam && !agency.getSolutionId().equals(extension.getKey())) continue;
                ManagedObjectReference dsMoRef = EamUtil.eamToDsMoref((ManagedObjectReference)agencyRef, extension.getServerGuid());
                result.add(new AgencyData(agency, dsMoRef));
            }
            Object[] objectArray = result.toArray(new AgencyData[result.size()]);
            return objectArray;
        }
        finally {
            EamConnection.tryClose((VcExtensionConnection)eamConnection);
        }
    }
}

