/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.impl;

import com.vmware.vim.binding.pbm.ServerObjectRef;
import com.vmware.vim.binding.pbm.profile.ProfileId;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vsphere.client.spbm.PbmService;
import com.vmware.vsphere.client.spbm.PbmServiceFactory;
import com.vmware.vsphere.client.spbm.util.ManagedUtil;
import com.vmware.vsphere.client.spbm.util.PbmSessionUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="VirtualMachine,Datastore")
public class ManagedEntityDataProviderAdapter
implements DataProviderAdapter {
    private static final Log _logger = LogFactory.getLog(ManagedEntityDataProviderAdapter.class);
    private DataService _dataService;
    private PbmServiceFactory _pbmServiceFactory;
    private static final String VM_TEMPLATE_RELATION = "vmTemplate";
    private static final String VM_AND_VM_TEMPLATE_RELATION = "vmAndVmTemplate";

    public ManagedEntityDataProviderAdapter(DataService dataService, PbmServiceFactory pbmServiceFactory) {
        this._pbmServiceFactory = pbmServiceFactory;
        this._dataService = dataService;
    }

    public Response getData(RequestSpec request) throws Exception {
        Validate.notNull((Object)request);
        QuerySpec[] querySpecs = request.querySpec;
        ResultSet[] resultSets = new ResultSet[querySpecs.length];
        for (int i = 0; i < querySpecs.length; ++i) {
            resultSets[i] = this.processQuery(querySpecs[i]);
        }
        Response response = new Response();
        response.resultSet = resultSets;
        return response;
    }

    private ResultSet processQuery(QuerySpec querySpec) {
        if (querySpec.resourceSpec == null) {
            return null;
        }
        RelationalConstraint relConstraint = this.extractRelationalConstraint(querySpec.resourceSpec.constraint);
        if (relConstraint == null) {
            return null;
        }
        if (!ObjectIdentityConstraint.class.isInstance(relConstraint.constraintOnRelatedObject)) {
            return null;
        }
        ObjectIdentityConstraint identityConstraint = (ObjectIdentityConstraint)relConstraint.constraintOnRelatedObject;
        if (!ManagedUtil.isProfileObject(identityConstraint.target)) {
            return null;
        }
        try {
            ManagedObjectReference[] moRefs = this.getTargetMoRefs((URI)identityConstraint.target, relConstraint.targetType, relConstraint.relation);
            if (moRefs == null || moRefs.length == 0) {
                return null;
            }
            Constraint moRefObjectIdentityConstraint = this.buildObjIdentityConstraints(moRefs);
            QuerySpec newQuerySpec = this.createQuerySpecForObjIdentityConstraints(querySpec, moRefObjectIdentityConstraint);
            return QueryUtil.getData((DataService)this._dataService, (QuerySpec)newQuerySpec);
        }
        catch (Exception e) {
            ResultSet resultSet = new ResultSet();
            resultSet.error = e;
            resultSet.queryName = querySpec.name;
            resultSet.totalMatchedObjectCount = 0;
            return resultSet;
        }
    }

    private RelationalConstraint extractRelationalConstraint(Constraint constraint) {
        if (constraint instanceof RelationalConstraint) {
            return (RelationalConstraint)constraint;
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            if (compositeConstraint.conjoiner.equals((Object)Conjoiner.AND) && compositeConstraint.nestedConstraints != null) {
                for (Constraint nestedConstraint : compositeConstraint.nestedConstraints) {
                    if (!(nestedConstraint instanceof RelationalConstraint)) continue;
                    return (RelationalConstraint)nestedConstraint;
                }
            }
        }
        return null;
    }

    private QuerySpec createQuerySpecForObjIdentityConstraints(QuerySpec originalQuerySpec, Constraint objIdentityConstraint) {
        QuerySpec querySpec = new QuerySpec(originalQuerySpec);
        if (querySpec.resourceSpec.constraint instanceof RelationalConstraint) {
            querySpec.resourceSpec.constraint = objIdentityConstraint;
        } else if (querySpec.resourceSpec.constraint instanceof CompositeConstraint) {
            CompositeConstraint originalCompositeConstraint = (CompositeConstraint)querySpec.resourceSpec.constraint;
            if (originalCompositeConstraint.conjoiner.equals((Object)Conjoiner.AND) && originalCompositeConstraint.nestedConstraints != null) {
                CompositeConstraint newCompositeConstraint = new CompositeConstraint();
                newCompositeConstraint.conjoiner = originalCompositeConstraint.conjoiner;
                newCompositeConstraint.nestedConstraints = new Constraint[originalCompositeConstraint.nestedConstraints.length];
                for (int i = 0; i < originalCompositeConstraint.nestedConstraints.length; ++i) {
                    newCompositeConstraint.nestedConstraints[i] = originalCompositeConstraint.nestedConstraints[i] instanceof RelationalConstraint ? objIdentityConstraint : originalCompositeConstraint.nestedConstraints[i];
                }
                querySpec.resourceSpec.constraint = newCompositeConstraint;
            }
        }
        return querySpec;
    }

    private Constraint buildObjIdentityConstraints(ManagedObjectReference[] moRefs) {
        CompositeConstraint cc = new CompositeConstraint();
        cc.conjoiner = Conjoiner.OR;
        Constraint[] nestedConstraints = new Constraint[moRefs.length];
        for (int index = 0; index < moRefs.length; ++index) {
            nestedConstraints[index] = QueryUtil.createObjectIdentityConstraint((Object)moRefs[index]);
        }
        cc.nestedConstraints = nestedConstraints;
        return cc;
    }

    private ManagedObjectReference[] getTargetMoRefs(URI profileUri, String targetType, String relation) throws Exception {
        String vcServiceGuid = ManagedUtil.getVcGuid(profileUri);
        PbmService pbmService = PbmSessionUtil.getService(vcServiceGuid, this._pbmServiceFactory);
        ProfileId profileId = ManagedUtil.uriToProfileId(profileUri);
        if ("Datastore".equals(targetType)) {
            return this.getRelatedDatastores(vcServiceGuid, pbmService, profileId);
        }
        if ("VirtualMachine".equals(targetType)) {
            return this.getRelatedVMs(vcServiceGuid, pbmService, profileId, relation);
        }
        return null;
    }

    private ManagedObjectReference[] getRelatedVMs(String vcServiceGuid, PbmService pbmService, ProfileId profileId, String relation) throws Exception {
        ArrayList<ServerObjectRef> relatedServerObjectRefs = new ArrayList<ServerObjectRef>();
        if (pbmService.isFeatureSupported("queryAssociatedEntityWithVirtualMachineAndDisks")) {
            this.addAllToListIfNotNull(relatedServerObjectRefs, pbmService.getProfileManager().queryAssociatedEntity(profileId, ServerObjectRef.ObjectType.virtualMachineAndDisks.toString()));
        } else {
            this.addAllToListIfNotNull(relatedServerObjectRefs, pbmService.getProfileManager().queryAssociatedEntity(profileId, ServerObjectRef.ObjectType.virtualMachine.toString()));
            this.addAllToListIfNotNull(relatedServerObjectRefs, pbmService.getProfileManager().queryAssociatedEntity(profileId, ServerObjectRef.ObjectType.virtualDiskId.toString()));
        }
        if (relatedServerObjectRefs.isEmpty()) {
            return new ManagedObjectReference[0];
        }
        HashSet<ManagedObjectReference> uniqueVmRefs = new HashSet<ManagedObjectReference>();
        for (ServerObjectRef serverObjectRef : relatedServerObjectRefs) {
            ManagedObjectReference vmRef = ManagedUtil.serverObjectRefToVmMor(serverObjectRef, vcServiceGuid);
            if (vmRef == null) continue;
            uniqueVmRefs.add(vmRef);
        }
        return this.getVMsForRelation(uniqueVmRefs.toArray(new ManagedObjectReference[0]), relation);
    }

    private void addAllToListIfNotNull(List<ServerObjectRef> list, ServerObjectRef[] serverObjectRefs) {
        if (serverObjectRefs != null) {
            list.addAll(Arrays.asList(serverObjectRefs));
        }
    }

    private ManagedObjectReference[] getRelatedDatastores(String vcServiceGuid, PbmService pbmService, ProfileId profileId) throws Exception {
        BlockingFuture datastoreFuture = new BlockingFuture();
        pbmService.getProfileManager().queryAssociatedEntity(profileId, ServerObjectRef.ObjectType.datastore.toString(), (Future)datastoreFuture);
        ServerObjectRef[] soRefs = (ServerObjectRef[])datastoreFuture.get();
        if (soRefs == null) {
            return null;
        }
        ManagedObjectReference[] targetMoRefs = new ManagedObjectReference[soRefs.length];
        for (int i = 0; i < targetMoRefs.length; ++i) {
            targetMoRefs[i] = ManagedUtil.serverObjectRefToManagedObjectRef(soRefs[i], vcServiceGuid);
        }
        return targetMoRefs;
    }

    private ManagedObjectReference[] getVMsForRelation(ManagedObjectReference[] vmRefs, String relation) throws Exception {
        PropertyValue[] propertyValues;
        if (vmRefs == null || vmRefs.length == 0) {
            return vmRefs;
        }
        ArrayList<ManagedObjectReference> result = new ArrayList<ManagedObjectReference>();
        for (PropertyValue value : propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object[])vmRefs, (String[])new String[]{"config.template"})) {
            if (VM_AND_VM_TEMPLATE_RELATION.equals(relation)) {
                result.add((ManagedObjectReference)value.resourceObject);
                continue;
            }
            Boolean isVmTemplate = (Boolean)value.value;
            if (VM_TEMPLATE_RELATION.equals(relation)) {
                if (!isVmTemplate.booleanValue()) continue;
                result.add((ManagedObjectReference)value.resourceObject);
                continue;
            }
            if (isVmTemplate.booleanValue()) continue;
            result.add((ManagedObjectReference)value.resourceObject);
        }
        return result.toArray(new ManagedObjectReference[0]);
    }
}

