/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.util;

import com.vmware.vim.binding.pbm.capability.CapabilityInstance;
import com.vmware.vim.binding.pbm.capability.CapabilityMetadata;
import com.vmware.vim.binding.pbm.capability.ConstraintInstance;
import com.vmware.vim.binding.pbm.capability.PropertyInstance;
import com.vmware.vim.binding.pbm.capability.PropertyMetadata;
import com.vmware.vim.binding.pbm.capability.provider.CapabilityObjectMetadataPerCategory;
import com.vmware.vim.binding.pbm.capability.provider.CapabilityObjectSchema;
import com.vmware.vim.binding.pbm.capability.provider.LineOfServiceInfo;
import com.vmware.vim.binding.pbm.capability.types.BuiltinTypesEnum;
import com.vmware.vim.binding.pbm.capability.types.DiscreteSet;
import com.vmware.vim.binding.pbm.capability.types.Range;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.pbm.profile.ProfileId;
import com.vmware.vim.binding.pbm.profile.ProfileManager;
import com.vmware.vim.binding.pbm.profile.ResourceType;
import com.vmware.vim.binding.pbm.profile.SubProfileCapabilityConstraints;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vsphere.client.spbm.PbmService;
import com.vmware.vsphere.client.spbm.data.NamespaceCapabilityMetadata;
import com.vmware.vsphere.client.spbm.impl.PbmServiceUnableToConnectException;
import com.vmware.vsphere.client.spbm.util.PbmLocalizationUtil;
import com.vmware.vsphere.client.spbm.util.PbmUtil;
import com.vmware.vsphere.client.spbm.util.RuleSetUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetadataUtil {
    public static final String DATA_SERVICE_REFERENCES_NAMESPACE = "com.vmware.storageprofile.dataservice";
    public static final String TAG_CAPABILITY_NAMESPACE = "http://www.vmware.com/storage/tag";
    public static final String VMWARE_COMMON_NAMESPACE = "com.vmware.storageprofile.std";
    public static final String LEGACY_IO_FILTER_NAMESPACE = "IOFILTERS";
    public static final String SPBM_DATA_DRIVEN_UI_OWNER = "spbmDataDrivenUI";
    public static final String VMCRYPT_IOFILTER_NAMESPACE = "vmwarevmcrypt";
    public static final String SIOC_IOFILTER_NAMESPACE = "spm";
    public static final String CONSUMPTION_DOMAIN_NAMESPACE = "com.vmware.storage.consumptiondomain";
    public static final String DEFAULT_PROFILE_ID = "defaultId";
    private static final Log _logger = LogFactory.getLog(MetadataUtil.class);
    private static final String DEFAULT_LINE_OF_SERVICE = LineOfServiceInfo.LineOfServiceEnum.PERSISTENCE.toString();

    public static boolean isDataServiceReferenceCapability(CapabilityInstance capabilityInstance) {
        if (capabilityInstance == null || capabilityInstance.id == null || capabilityInstance.id.namespace == null) {
            return false;
        }
        return DATA_SERVICE_REFERENCES_NAMESPACE.equals(capabilityInstance.id.namespace);
    }

    public static boolean isVmwareIoFilterNamespace(String namespaceId) {
        return VMCRYPT_IOFILTER_NAMESPACE.equals(namespaceId) || SIOC_IOFILTER_NAMESPACE.equals(namespaceId);
    }

    public static boolean isVendorNamespace(String namespace) {
        return namespace != null && !DATA_SERVICE_REFERENCES_NAMESPACE.equals(namespace) && !VMWARE_COMMON_NAMESPACE.equals(namespace) && !TAG_CAPABILITY_NAMESPACE.equals(namespace) && !LEGACY_IO_FILTER_NAMESPACE.equalsIgnoreCase(namespace) && !CONSUMPTION_DOMAIN_NAMESPACE.equalsIgnoreCase(namespace);
    }

    public static String getLocalizedNamespaceTitle(NamespaceCapabilityMetadata namespaceMetadata) {
        if (namespaceMetadata == null || namespaceMetadata.namespaceInfo == null) {
            return null;
        }
        if (namespaceMetadata.namespaceInfo.info != null && namespaceMetadata.namespaceInfo.info.label != null) {
            return namespaceMetadata.namespaceInfo.info.label;
        }
        return MetadataUtil.localizeNamespaceId(namespaceMetadata.namespaceInfo.namespace);
    }

    public static String localizeNamespaceId(String namespaceId) {
        if (VMWARE_COMMON_NAMESPACE.equals(namespaceId)) {
            return PbmUtil.getLocalizedString("profile.namespace.vmwareCommonNamespace", new String[0]);
        }
        if (MetadataUtil.isVmwareIoFilterNamespace(namespaceId)) {
            return PbmUtil.getLocalizedString("profile.namespace.vmwareIoFilter." + namespaceId, new String[0]);
        }
        if (TAG_CAPABILITY_NAMESPACE.equals(namespaceId)) {
            return null;
        }
        if (LEGACY_IO_FILTER_NAMESPACE.equals(namespaceId)) {
            return null;
        }
        return namespaceId;
    }

    public static ProfileId getProfileIdFromCapabilityInstance(CapabilityInstance capabilityInstance) {
        if (MetadataUtil.isDataServiceReferenceCapability(capabilityInstance)) {
            ProfileId profileId = new ProfileId();
            profileId.uniqueId = capabilityInstance.id.id;
            return profileId;
        }
        return null;
    }

    public static List<ProfileId> getNestedProfileIds(Profile ... profiles) {
        ArrayList<ProfileId> nestedProfileIds = new ArrayList<ProfileId>();
        if (profiles == null) {
            return nestedProfileIds;
        }
        for (Profile profile : profiles) {
            SubProfileCapabilityConstraints.SubProfile[] subProfiles = RuleSetUtil.getSubProfiles(profile);
            if (subProfiles == null) continue;
            for (SubProfileCapabilityConstraints.SubProfile subProfile : subProfiles) {
                if (subProfile.capability == null) continue;
                for (CapabilityInstance capabilityInstance : subProfile.capability) {
                    if (!MetadataUtil.isDataServiceReferenceCapability(capabilityInstance)) continue;
                    nestedProfileIds.add(MetadataUtil.getProfileIdFromCapabilityInstance(capabilityInstance));
                }
            }
        }
        return nestedProfileIds;
    }

    public static void updateValueTypesInSubProfiles(SubProfileCapabilityConstraints.SubProfile[] subProfiles, PbmService pbmService, ResourceType resourceType) throws Exception {
        if (subProfiles == null || pbmService == null) {
            return;
        }
        NamespaceCapabilityMetadata[] metadata = MetadataUtil.getNamespaceCapabilityMetadata(pbmService, resourceType);
        for (SubProfileCapabilityConstraints.SubProfile subProfile : subProfiles) {
            if (subProfile.capability == null) continue;
            for (CapabilityInstance capabilityInstance : subProfile.capability) {
                if (capabilityInstance.id == null || ArrayUtils.isEmpty((Object[])capabilityInstance.constraint)) continue;
                NamespaceCapabilityMetadata ciNamespace = MetadataUtil.getNamespaceMetadata(metadata, capabilityInstance.id.namespace);
                if (ciNamespace == null) {
                    _logger.error((Object)("Failed to find namespace - " + capabilityInstance.id.namespace));
                    continue;
                }
                CapabilityMetadata cpMetadata = MetadataUtil.getCapabilityMetadata(ciNamespace.capabilityMetadata, capabilityInstance.id);
                if (cpMetadata == null || cpMetadata.propertyMetadata == null) continue;
                for (ConstraintInstance constraintInstance : capabilityInstance.constraint) {
                    if (ArrayUtils.isEmpty((Object[])constraintInstance.propertyInstance)) continue;
                    for (PropertyInstance propInstance : constraintInstance.propertyInstance) {
                        PropertyMetadata propMetadata = MetadataUtil.getPropertyMetadata(cpMetadata.propertyMetadata, propInstance.id);
                        if (propMetadata == null) {
                            _logger.warn((Object)"PropertyInstances don't match PropertyMetadata");
                            continue;
                        }
                        MetadataUtil.updateValueTypesInPropertyInstance(propInstance, propMetadata);
                    }
                }
            }
        }
    }

    private static void updateValueTypesInPropertyInstance(PropertyInstance propInstance, PropertyMetadata propMetadata) {
        if (propInstance == null || propMetadata == null) {
            return;
        }
        if (propInstance.value instanceof Range) {
            Range rangeValue = (Range)propInstance.value;
            rangeValue.min = MetadataUtil.convertValue(rangeValue.min, propMetadata.type.typeName);
            rangeValue.max = MetadataUtil.convertValue(rangeValue.max, propMetadata.type.typeName);
        } else if (propInstance.value instanceof DiscreteSet) {
            MetadataUtil.updateValueTypesInDiscreteSet((DiscreteSet)propInstance.value, propMetadata);
        } else {
            propInstance.value = MetadataUtil.convertValue(propInstance.value, propMetadata.type.typeName);
        }
    }

    private static void updateValueTypesInDiscreteSet(DiscreteSet discreteSet, PropertyMetadata propMetadata) {
        if (discreteSet == null || discreteSet.values == null || propMetadata == null) {
            return;
        }
        for (int i = 0; i < discreteSet.values.length; ++i) {
            discreteSet.values[i] = MetadataUtil.convertValue(discreteSet.values[i], propMetadata.type.typeName);
        }
    }

    private static Object convertValue(Object value, String valueTypeName) {
        BuiltinTypesEnum valueType = BuiltinTypesEnum.valueOf((String)valueTypeName);
        switch (valueType) {
            case XSD_INT: {
                return MetadataUtil.convertToXsdIntValue(value);
            }
            case XSD_LONG: {
                return MetadataUtil.convertToXsdLongValue(value);
            }
            case XSD_DOUBLE: {
                return MetadataUtil.convertToDoubleValue(value);
            }
        }
        return value;
    }

    private static Object convertToXsdLongValue(Object value) {
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Double) {
            return ((Double)value).longValue();
        }
        return value;
    }

    private static Object convertToXsdIntValue(Object value) {
        if (value instanceof Double) {
            return ((Double)value).intValue();
        }
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        return value;
    }

    private static Object convertToDoubleValue(Object value) {
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        if (value instanceof Long) {
            return ((Long)value).doubleValue();
        }
        return value;
    }

    public static PropertyMetadata getPropertyMetadata(PropertyMetadata[] metadata, String id) {
        if (metadata == null || id == null) {
            return null;
        }
        for (PropertyMetadata propMetadata : metadata) {
            if (!id.equals(propMetadata.id)) continue;
            return propMetadata;
        }
        return null;
    }

    private static NamespaceCapabilityMetadata getNamespaceMetadata(NamespaceCapabilityMetadata[] metadata, String namespace) {
        if (metadata == null) {
            return null;
        }
        for (NamespaceCapabilityMetadata namespaceMetadata : metadata) {
            if (!namespaceMetadata.namespaceInfo.namespace.equals(namespace)) continue;
            return namespaceMetadata;
        }
        return null;
    }

    public static CapabilityMetadata getCapabilityMetadata(CapabilityMetadata[] metadata, CapabilityMetadata.UniqueId id) {
        if (metadata == null || id == null || id.id == null) {
            return null;
        }
        for (CapabilityMetadata capMetadata : metadata) {
            if (capMetadata == null || capMetadata.id == null || !id.id.equals(capMetadata.id.id)) continue;
            return capMetadata;
        }
        return null;
    }

    public static NamespaceCapabilityMetadata[] getNamespaceCapabilityMetadata(PbmService service, ResourceType resourceType) throws Exception {
        try {
            if (service.isFeatureSupported("dataService")) {
                return MetadataUtil.getMetadataFromCapabilityObjectSchema(service);
            }
            return MetadataUtil.getMetadataFromCapabilityMetadata(service, resourceType);
        }
        catch (PbmServiceUnableToConnectException | ExecutionException ex) {
            _logger.error((Object)"Failed to retrieve capability metadata: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
    }

    public static NamespaceCapabilityMetadata[] getLocalizedNamespaceCapabilityMetadata(PbmService service, ResourceType resourceType, String vcServiceGuid) throws Exception {
        NamespaceCapabilityMetadata[] namespaceCapabilityMetadata = MetadataUtil.getNamespaceCapabilityMetadata(service, resourceType);
        PbmLocalizationUtil.localizeNamespaceCapabilityMetadata(namespaceCapabilityMetadata, VimSessionUtil.getService((String)vcServiceGuid));
        return namespaceCapabilityMetadata;
    }

    private static NamespaceCapabilityMetadata[] getMetadataFromCapabilityMetadata(PbmService service, ResourceType resourceType) throws Exception {
        ProfileManager profileManager = service.getProfileManager();
        CapabilityObjectSchema.VendorResourceTypeInfo[] vendorInfos = MetadataUtil.getVendorResourceTypeInfo(profileManager, resourceType);
        HashMap<String, CapabilityObjectSchema.VendorInfo> vendorInfoMap = new HashMap<String, CapabilityObjectSchema.VendorInfo>();
        HashMap<String, CapabilityObjectSchema.NamespaceInfo> namespaceInfoMap = new HashMap<String, CapabilityObjectSchema.NamespaceInfo>();
        MetadataUtil.initializeMetadataMaps(vendorInfoMap, namespaceInfoMap, vendorInfos);
        return MetadataUtil.retrieveNamespaceCapabilityMetadata(vendorInfoMap, namespaceInfoMap, profileManager, resourceType);
    }

    public static List<CapabilityObjectSchema.NamespaceInfo> getNamespaceInfo(PbmService service, ResourceType resourceType) throws Exception {
        try {
            ProfileManager profileManager = service.getProfileManager();
            Object[] vendorInfos = MetadataUtil.getVendorResourceTypeInfo(profileManager, resourceType);
            ArrayList<CapabilityObjectSchema.NamespaceInfo> namespaceInfos = new ArrayList<CapabilityObjectSchema.NamespaceInfo>();
            if (!ArrayUtils.isEmpty((Object[])vendorInfos)) {
                for (Object vendorInfo : vendorInfos) {
                    if (((CapabilityObjectSchema.VendorResourceTypeInfo)vendorInfo).vendorNamespaceInfo == null) continue;
                    for (CapabilityObjectSchema.VendorNamespaceInfo vendorNamespaceInfo : ((CapabilityObjectSchema.VendorResourceTypeInfo)vendorInfo).vendorNamespaceInfo) {
                        if (vendorNamespaceInfo == null || vendorNamespaceInfo.namespaceInfo == null) continue;
                        MetadataUtil.setDefaultNamespaceOwner(vendorNamespaceInfo.namespaceInfo);
                        namespaceInfos.add(vendorNamespaceInfo.namespaceInfo);
                    }
                }
            }
            return namespaceInfos;
        }
        catch (PbmServiceUnableToConnectException | ExecutionException ex) {
            _logger.error((Object)"Failed to retrieve namespace info-s: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
    }

    private static void setDefaultNamespaceOwner(CapabilityObjectSchema.NamespaceInfo namespaceInfo) {
        if (namespaceInfo != null && namespaceInfo.owner == null) {
            namespaceInfo.owner = SPBM_DATA_DRIVEN_UI_OWNER;
        }
    }

    private static NamespaceCapabilityMetadata[] getMetadataFromCapabilityObjectSchema(PbmService service) throws Exception {
        ProfileManager profileManager = service.getProfileManager();
        Object[] capabilityObjectSchemas = profileManager.fetchCapabilitySchema(null, null);
        if (ArrayUtils.isEmpty((Object[])capabilityObjectSchemas)) {
            return new NamespaceCapabilityMetadata[0];
        }
        NamespaceCapabilityMetadata[] namespaceMetadata = new NamespaceCapabilityMetadata[capabilityObjectSchemas.length];
        for (int i = 0; i < namespaceMetadata.length; ++i) {
            namespaceMetadata[i] = MetadataUtil.capabilitySchemaToNamespaceMetadata((CapabilityObjectSchema)capabilityObjectSchemas[i]);
        }
        return namespaceMetadata;
    }

    public static String getNamespaceLineOfService(NamespaceCapabilityMetadata namespaceCapabilityMetadata) {
        if (namespaceCapabilityMetadata == null) {
            return null;
        }
        if (namespaceCapabilityMetadata.lineOfServiceInfo != null) {
            return namespaceCapabilityMetadata.lineOfServiceInfo.lineOfService;
        }
        return LineOfServiceInfo.LineOfServiceEnum.PERSISTENCE.toString();
    }

    public static boolean isPersistenceNamespace(NamespaceCapabilityMetadata namespaceCapabilityMetadata) {
        return LineOfServiceInfo.LineOfServiceEnum.PERSISTENCE.toString().equals(MetadataUtil.getNamespaceLineOfService(namespaceCapabilityMetadata));
    }

    private static NamespaceCapabilityMetadata capabilitySchemaToNamespaceMetadata(CapabilityObjectSchema capabilityObjectSchema) {
        NamespaceCapabilityMetadata namespaceMetadata = new NamespaceCapabilityMetadata();
        namespaceMetadata.vendorInfo = capabilityObjectSchema.vendorInfo;
        namespaceMetadata.namespaceInfo = capabilityObjectSchema.namespaceInfo;
        MetadataUtil.setDefaultNamespaceOwner(namespaceMetadata.namespaceInfo);
        if (capabilityObjectSchema.lineOfService != null) {
            namespaceMetadata.lineOfServiceInfo = capabilityObjectSchema.lineOfService;
        } else {
            namespaceMetadata.lineOfServiceInfo = new LineOfServiceInfo();
            namespaceMetadata.lineOfServiceInfo.lineOfService = DEFAULT_LINE_OF_SERVICE;
        }
        ArrayList<CapabilityMetadata> capabilities = new ArrayList<CapabilityMetadata>();
        if (!ArrayUtils.isEmpty((Object[])capabilityObjectSchema.capabilityMetadataPerCategory)) {
            for (CapabilityObjectMetadataPerCategory capabilityMetadataPerCategory : capabilityObjectSchema.capabilityMetadataPerCategory) {
                if (capabilityMetadataPerCategory == null || ArrayUtils.isEmpty((Object[])capabilityMetadataPerCategory.capabilityMetadata)) continue;
                for (CapabilityMetadata capability : capabilityMetadataPerCategory.capabilityMetadata) {
                    capabilities.add(capability);
                }
            }
        }
        namespaceMetadata.capabilityMetadata = capabilities.toArray(new CapabilityMetadata[capabilities.size()]);
        return namespaceMetadata;
    }

    private static CapabilityObjectSchema.VendorResourceTypeInfo[] getVendorResourceTypeInfo(ProfileManager profileManager, ResourceType resourceType) throws Exception {
        BlockingFuture vendorFuture = new BlockingFuture();
        profileManager.fetchVendorInfo(null, (Future)vendorFuture);
        CapabilityObjectSchema.VendorResourceTypeInfo[] vendorInfos = (CapabilityObjectSchema.VendorResourceTypeInfo[])vendorFuture.get();
        if (vendorInfos == null) {
            return new CapabilityObjectSchema.VendorResourceTypeInfo[0];
        }
        return vendorInfos;
    }

    private static void initializeMetadataMaps(HashMap<String, CapabilityObjectSchema.VendorInfo> vendorInfoMap, HashMap<String, CapabilityObjectSchema.NamespaceInfo> namespaceInfoMap, CapabilityObjectSchema.VendorResourceTypeInfo[] vendorInfos) {
        for (CapabilityObjectSchema.VendorResourceTypeInfo vendorInfo : vendorInfos) {
            if (vendorInfo.vendorNamespaceInfo == null) continue;
            for (CapabilityObjectSchema.VendorNamespaceInfo vendorNamespaceInfo : vendorInfo.vendorNamespaceInfo) {
                String namespace = vendorNamespaceInfo.namespaceInfo.namespace;
                if (!vendorInfoMap.containsKey(namespace)) {
                    vendorInfoMap.put(namespace, vendorNamespaceInfo.vendorInfo);
                }
                if (namespaceInfoMap.containsKey(namespace)) continue;
                namespaceInfoMap.put(namespace, vendorNamespaceInfo.namespaceInfo);
            }
        }
    }

    private static NamespaceCapabilityMetadata[] retrieveNamespaceCapabilityMetadata(HashMap<String, CapabilityObjectSchema.VendorInfo> vendorInfoMap, HashMap<String, CapabilityObjectSchema.NamespaceInfo> namespaceInfoMap, ProfileManager profileManager, ResourceType resourceType) throws Exception {
        HashMap<String, ArrayList<CapabilityMetadata>> capabilityMap = MetadataUtil.retrieveCapabilityMetadata(profileManager, resourceType);
        if (capabilityMap == null) {
            return new NamespaceCapabilityMetadata[0];
        }
        NamespaceCapabilityMetadata[] metadata = new NamespaceCapabilityMetadata[capabilityMap.size()];
        int namespaceIndex = 0;
        for (String namespace : capabilityMap.keySet()) {
            metadata[namespaceIndex] = new NamespaceCapabilityMetadata();
            metadata[namespaceIndex].namespaceInfo = namespaceInfoMap.get(namespace);
            if (metadata[namespaceIndex].namespaceInfo == null) {
                _logger.error((Object)("Missing namespaceInfo: " + namespace));
                throw PbmUtil.getMethodFault(PbmUtil.getLocalizedException("error.missingNamespace", namespace));
            }
            metadata[namespaceIndex].vendorInfo = vendorInfoMap.get(namespace);
            metadata[namespaceIndex].capabilityMetadata = capabilityMap.get(namespace).toArray(new CapabilityMetadata[0]);
            MetadataUtil.setDefaultNamespaceOwner(metadata[namespaceIndex].namespaceInfo);
            metadata[namespaceIndex].lineOfServiceInfo = new LineOfServiceInfo();
            metadata[namespaceIndex].lineOfServiceInfo.lineOfService = DEFAULT_LINE_OF_SERVICE;
            ++namespaceIndex;
        }
        return metadata;
    }

    private static HashMap<String, ArrayList<CapabilityMetadata>> retrieveCapabilityMetadata(ProfileManager profileManager, ResourceType resourceType) throws Exception {
        BlockingFuture capabilitiesFuture = new BlockingFuture();
        profileManager.fetchCapabilityMetadata(resourceType, null, (Future)capabilitiesFuture);
        Object[] capabilityMetadataPerCategoryObjects = (CapabilityObjectMetadataPerCategory[])capabilitiesFuture.get();
        HashMap<String, ArrayList<CapabilityMetadata>> capabilityMap = new HashMap<String, ArrayList<CapabilityMetadata>>();
        if (ArrayUtils.isEmpty((Object[])capabilityMetadataPerCategoryObjects)) {
            return capabilityMap;
        }
        for (Object capabilityMetadataPerCategory : capabilityMetadataPerCategoryObjects) {
            if (capabilityMetadataPerCategory == null || ArrayUtils.isEmpty((Object[])((CapabilityObjectMetadataPerCategory)capabilityMetadataPerCategory).capabilityMetadata)) continue;
            for (CapabilityMetadata capability : ((CapabilityObjectMetadataPerCategory)capabilityMetadataPerCategory).capabilityMetadata) {
                String capabilityNamespace = capability.id.namespace;
                if (!capabilityMap.containsKey(capabilityNamespace)) {
                    capabilityMap.put(capabilityNamespace, new ArrayList());
                }
                capabilityMap.get(capabilityNamespace).add(capability);
            }
        }
        return capabilityMap;
    }

    public static DiscreteSet tryGetAllowedValueAsSet(PropertyMetadata propertyMetadata) {
        Object[] allowedValueAsArray;
        if (propertyMetadata == null || propertyMetadata.allowedValue == null) {
            return null;
        }
        if (propertyMetadata.allowedValue instanceof DiscreteSet) {
            return (DiscreteSet)propertyMetadata.allowedValue;
        }
        if (propertyMetadata.allowedValue instanceof Object[] && (allowedValueAsArray = (Object[])propertyMetadata.allowedValue) != null && allowedValueAsArray.length > 0 && allowedValueAsArray[0] instanceof DiscreteSet) {
            return (DiscreteSet)allowedValueAsArray[0];
        }
        return null;
    }
}

