/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.util;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.LicenseAssignmentManager;
import com.vmware.vim.binding.vim.LicenseManager;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.spbm.data.ClusterSpbmLicenseData;
import com.vmware.vsphere.client.spbm.data.HostSpbmLicenseData;
import com.vmware.vsphere.client.spbm.data.SpbmEnableAction;
import com.vmware.vsphere.client.spbm.data.SpbmLicenseBaseData;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpbmLicenseUtil {
    private static final Log _logger = LogFactory.getLog(SpbmLicenseUtil.class);
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_CONNECTION_STATE = "runtime.connectionState";
    private static final String PROPERTY_MAINTENANCE_MODE = "runtime.inMaintenanceMode";

    public static HashMap<String, SpbmLicenseBaseData> fillMapWithDataPerDc(String dcName, Object[] computeResources, HashMap<String, SpbmLicenseBaseData> resultMap) {
        for (Object computeResource : computeResources) {
            ManagedObjectReference crRef = (ManagedObjectReference)computeResource;
            Object crData = crRef.getType().equals(ClusterComputeResource.class.getSimpleName()) ? new ClusterSpbmLicenseData() : new HostSpbmLicenseData();
            crData.computeResource = crRef;
            crData.datacenterName = dcName;
            resultMap.put(crRef.getValue(), (SpbmLicenseBaseData)crData);
        }
        return resultMap;
    }

    public static LicenseAssignmentManager.FeatureLicenseAvailability[] getSpbmLicenseAvailablityForHosts(ArrayList<ManagedObjectReference> hosts) throws Exception {
        LicenseAssignmentManager.EntityFeaturePair[] entityPairs = new LicenseAssignmentManager.EntityFeaturePair[hosts.size()];
        for (int i = 0; i < hosts.size(); ++i) {
            LicenseAssignmentManager.EntityFeaturePair entityPair;
            ManagedObjectReference host = hosts.get(i);
            entityPairs[i] = entityPair = new LicenseAssignmentManager.EntityFeaturePair(host.getValue(), "spbm");
        }
        LicenseAssignmentManager licenseAssignmentManager = SpbmLicenseUtil.getLicenseAssignmentManager(hosts.get(0).getServerGuid());
        return licenseAssignmentManager.isFeatureAvailable(entityPairs);
    }

    public static HashMap<String, Object[]> getConnectionStateAndSpbmLicenseInfoForHosts(DataService dataService, ArrayList<ManagedObjectReference> hosts) throws Exception {
        LicenseAssignmentManager.FeatureLicenseAvailability[] spbmAvailability;
        PropertyValue[] hostProperties = QueryUtil.getProperties((DataService)dataService, (Object[])hosts.toArray(new ManagedObjectReference[hosts.size()]), (String[])new String[]{PROPERTY_NAME, PROPERTY_CONNECTION_STATE, PROPERTY_MAINTENANCE_MODE});
        HashMap<String, Object[]> hostIdToPropsMap = new HashMap<String, Object[]>();
        for (PropertyValue property : hostProperties) {
            String hostId = ((ManagedObjectReference)property.resourceObject).getValue();
            Object[] hostProps = (Object[])hostIdToPropsMap.get(hostId);
            if (hostProps == null) {
                hostProps = new Object[4];
            }
            if (property.propertyName.equals(PROPERTY_NAME)) {
                hostProps[0] = (String)property.value;
            } else if (property.propertyName.equals(PROPERTY_CONNECTION_STATE)) {
                Boolean hostConnected = HostSystem.ConnectionState.connected.equals((Object)((HostSystem.ConnectionState)property.value));
                hostProps[1] = hostConnected;
            } else if (property.propertyName.equals(PROPERTY_MAINTENANCE_MODE)) {
                Boolean hostInMaintenanceMode = (Boolean)property.value;
                hostProps[2] = hostInMaintenanceMode;
            }
            hostIdToPropsMap.put(hostId, hostProps);
        }
        for (LicenseAssignmentManager.FeatureLicenseAvailability hostAvailability : spbmAvailability = SpbmLicenseUtil.getSpbmLicenseAvailablityForHosts(hosts)) {
            String hostId = hostAvailability.entityFeature.entityId;
            Boolean spbmLicensedOnHost = hostAvailability.licensed;
            Object[] hostProps = hostIdToPropsMap.get(hostId);
            if (hostProps != null) {
                hostProps[3] = spbmLicensedOnHost;
                continue;
            }
            hostProps = new Object[]{"", false, false, spbmLicensedOnHost};
            hostIdToPropsMap.put(hostId, hostProps);
        }
        return hostIdToPropsMap;
    }

    public static SpbmLicenseBaseData[] buildSpbmLicenseData(HashMap<String, SpbmLicenseBaseData> resultMap, HashMap<String, Object[]> crIdToPropsMap, HashMap<String, Object[]> hostIdToPropsMap) {
        ArrayList<SpbmLicenseBaseData> result = new ArrayList<SpbmLicenseBaseData>();
        for (String crId : resultMap.keySet()) {
            SpbmLicenseBaseData data = resultMap.get(crId);
            Object[] crProps = crIdToPropsMap.get(crId);
            if (data instanceof ClusterSpbmLicenseData) {
                SpbmLicenseUtil.fillClusterSpbmData((ClusterSpbmLicenseData)data, crProps, hostIdToPropsMap);
            } else {
                SpbmLicenseUtil.fillHostSpbmData((HostSpbmLicenseData)data, crProps, hostIdToPropsMap);
            }
            result.add(data);
        }
        return result.toArray(new SpbmLicenseBaseData[result.size()]);
    }

    private static LicenseAssignmentManager getLicenseAssignmentManager(String serverGuid) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)serverGuid);
        if (vcService == null) {
            return null;
        }
        ServiceInstanceContent content = vcService.getServiceInstanceContent();
        if (content == null) {
            _logger.error((Object)"ServiceInstanceContent found null");
            return null;
        }
        ManagedObjectReference licenseMgrMoref = content.licenseManager;
        if (licenseMgrMoref == null) {
            _logger.error((Object)"Could not get LicenseManager moref");
            return null;
        }
        LicenseManager licenseManager = (LicenseManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)licenseMgrMoref);
        if (licenseManager == null) {
            _logger.error((Object)"Could not get LicenseManager");
            return null;
        }
        ManagedObjectReference lam = licenseManager.getLicenseAssignmentManager();
        if (lam == null) {
            return null;
        }
        LicenseAssignmentManager licenseAssignmentMgr = (LicenseAssignmentManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)lam);
        return licenseAssignmentMgr;
    }

    private static void fillClusterSpbmData(ClusterSpbmLicenseData data, Object[] crProps, HashMap<String, Object[]> hostIdToPropsMap) {
        data.name = (String)crProps[0];
        data.spbmEnabled = (Boolean)crProps[2];
        data = SpbmLicenseUtil.createAndSetChildrenForCluster(data, (ManagedObjectReference[])crProps[1], hostIdToPropsMap);
        if (data.spbmEnabled != null && data.spbmEnabled.booleanValue()) {
            data.availableAction = SpbmEnableAction.DISABLE;
            data.isUnlicensedUse = data.unlicensedHostCount > 0 || data.children.length == 0;
        } else if (data.unlicensedHostCount + data.unknownLicenseHostCount == 0 && data.children.length > 0) {
            data.availableAction = SpbmEnableAction.ENABLE;
        }
    }

    private static ClusterSpbmLicenseData createAndSetChildrenForCluster(ClusterSpbmLicenseData data, ManagedObjectReference[] hosts, HashMap<String, Object[]> hostIdToPropsMap) {
        if (hosts == null || hosts.length == 0) {
            data.children = new HostSpbmLicenseData[0];
            return data;
        }
        HostSpbmLicenseData[] children = new HostSpbmLicenseData[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            ManagedObjectReference host = hosts[i];
            children[i] = new HostSpbmLicenseData();
            Object[] hostProps = hostIdToPropsMap.get(host.getValue());
            SpbmLicenseUtil.fillHostSpbmData(children[i], hostProps);
            if (!children[i].isConnected || children[i].spbmLicensed == null) {
                ++data.unknownLicenseHostCount;
                continue;
            }
            if (children[i].spbmLicensed.booleanValue()) continue;
            ++data.unlicensedHostCount;
        }
        data.children = children;
        return data;
    }

    private static void fillHostSpbmData(HostSpbmLicenseData data, Object[] crProps, HashMap<String, Object[]> hostIdToPropsMap) {
        data.spbmEnabled = (Boolean)crProps[2];
        ManagedObjectReference host = ((ManagedObjectReference[])crProps[1])[0];
        Object[] hostProps = hostIdToPropsMap.get(host.getValue());
        SpbmLicenseUtil.fillHostSpbmData(data, hostProps);
    }

    private static void fillHostSpbmData(HostSpbmLicenseData data, Object[] hostProps) {
        data.name = (String)hostProps[0];
        data.isConnected = (Boolean)hostProps[1];
        data.inMaintenanceMode = (Boolean)hostProps[2];
        data.spbmLicensed = (Boolean)hostProps[3];
        data.availableAction = SpbmEnableAction.NONE;
        if (data.isConnected) {
            if (data.spbmEnabled != null && data.spbmEnabled.booleanValue()) {
                data.isUnlicensedUse = data.spbmLicensed != null && data.spbmLicensed == false;
                data.availableAction = SpbmEnableAction.DISABLE;
            } else if (data.spbmLicensed != null && data.spbmLicensed.booleanValue()) {
                data.availableAction = SpbmEnableAction.ENABLE;
            }
        }
    }
}

