/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.h5.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.license.client.cis.global.ds.LicensingGlobalData;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.VpxManagementEditor;
import com.vmware.license.client.cis.management.VsphereObjectAssetSpec;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.license.client.cis.util.LicensingMethodFault;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.uri.resolve.DefaultUriSchemeUtil;
import com.vmware.vise.util.session.SessionUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AssetAvailabilityPropertyProvider {
    private static final String LICENSING_GLOBAL_DATA_TYPE = "LicensingGlobalData";
    private static final String LICENSE_GLOBAL_DATA_PROP = "licensingGlobalData";
    private static final Log _logger = LogFactory.getLog(AssetAvailabilityPropertyProvider.class);
    private QueryService _queryService;
    private ExecutorService _threadPoolExecutor;
    private final VpxManagementEditor _managementEditor;

    public AssetAvailabilityPropertyProvider(QueryServiceFactory queryServiceFactory, ExecutorService threadPoolExecutor, VpxManagementEditor managementEditor) {
        this._queryService = queryServiceFactory.getQueryService();
        this._threadPoolExecutor = threadPoolExecutor;
        this._managementEditor = managementEditor;
    }

    @PropertyProvider(value="HostSystem/isAssignLicenseActionAvailable")
    public Collection<Boolean> getHostIsAssignLicenseActionAvailable(Collection<ManagedObjectReference> hostRefs) {
        return this.getIsAssignLicenseActionAvailable(hostRefs, true);
    }

    @PropertyProvider(value="ClusterComputeResource/isAssignLicenseActionAvailable")
    public Collection<Boolean> getClusterComputeResourceIsAssignLicenseActionAvailable(Collection<ManagedObjectReference> clusterRefs) {
        return this.getIsAssignLicenseActionAvailable(clusterRefs, false);
    }

    @PropertyProvider(value="Folder/isAssignLicenseActionAvailable")
    public Collection<Boolean> getFolderIsAssignLicenseActionAvailable(Collection<ManagedObjectReference> vcRefs) {
        return this.getIsAssignLicenseActionAvailable(vcRefs, true);
    }

    private Collection<Boolean> getIsAssignLicenseActionAvailable(Collection<ManagedObjectReference> assetRefs, boolean checkSubscription) {
        if (assetRefs == null || assetRefs.size() == 0) {
            return null;
        }
        ManagedObjectReference[] assets = assetRefs.toArray(new ManagedObjectReference[0]);
        if (!LicenseScopeUtil.doAssetsHaveSameScope((ManagedObjectReference[])assets)) {
            return Collections.nCopies(assetRefs.size(), false);
        }
        HttpServletRequest threadContext = SessionUtil.getHttpRequest();
        LicenseScope scope = LicenseScopeUtil.getLicenseScopeByMoRef((ManagedObjectReference)assets[0]);
        Future<Boolean> checkPrivilegeTask = this._threadPoolExecutor.submit(this.createCheckPrivilegesTask(scope, threadContext, assets.length));
        Future<List<Boolean>> checkAssetsOnSubscriptionTask = null;
        if (checkSubscription) {
            checkAssetsOnSubscriptionTask = this._threadPoolExecutor.submit(this.createCheckAssetsOnSubscriptionTask(scope, threadContext, assets));
        }
        try {
            boolean hasAdminPrivilege = checkPrivilegeTask.get();
            if (!checkSubscription || !hasAdminPrivilege) {
                return Collections.nCopies(assetRefs.size(), hasAdminPrivilege);
            }
            return checkAssetsOnSubscriptionTask.get();
        }
        catch (InterruptedException | ExecutionException e) {
            _logger.error((Object)("The operation failed with error: " + e.getMessage()), (Throwable)e);
            return Collections.nCopies(assetRefs.size(), false);
        }
    }

    private Boolean checkLicensingAdminPrivilege(LicenseScope scope) {
        LicensingGlobalData licensingGlobalData = this.retrieveLicensingGlobalDataForScope(scope);
        if (licensingGlobalData != null) {
            return licensingGlobalData.isLicensingAdminPrivilegeGranted();
        }
        return false;
    }

    private LicensingGlobalData retrieveLicensingGlobalDataForScope(LicenseScope scope) {
        URI licensingGlobalDataUri = DefaultUriSchemeUtil.createUri((String)LICENSING_GLOBAL_DATA_TYPE, (String)scope.getId());
        ResultSet licensePropsResultSet = null;
        try {
            licensePropsResultSet = this._queryService.select(new String[]{LICENSE_GLOBAL_DATA_PROP}).from(new String[]{LICENSING_GLOBAL_DATA_TYPE}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)licensingGlobalDataUri).fetch();
        }
        catch (RuntimeException exception) {
            if (exception.getCause() instanceof LicensingMethodFault) {
                _logger.error((Object)("The request for license global data failed with error: " + exception.getMessage()));
            }
            throw exception;
        }
        if (licensePropsResultSet == null || licensePropsResultSet.getItems() == null || licensePropsResultSet.getItems().isEmpty()) {
            return null;
        }
        ResourceItem resourceItem = (ResourceItem)licensePropsResultSet.getItems().get(0);
        return (LicensingGlobalData)resourceItem.get(LICENSE_GLOBAL_DATA_PROP);
    }

    private Callable<Boolean> createCheckPrivilegesTask(final LicenseScope scope, final HttpServletRequest threadContext, int collectionSize) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                return AssetAvailabilityPropertyProvider.this.checkLicensingAdminPrivilege(scope);
            }
        };
    }

    private Callable<List<Boolean>> createCheckAssetsOnSubscriptionTask(final LicenseScope scope, final HttpServletRequest threadContext, final ManagedObjectReference[] assetRefs) {
        return new Callable<List<Boolean>>(){

            @Override
            public List<Boolean> call() throws Exception {
                SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                VsphereObjectAssetSpec[] vsphereObjectAssetSpec = Arrays.asList(assetRefs).stream().collect(Collectors.mapping(assetRef -> new VsphereObjectAssetSpec(assetRef, null), Collectors.toList())).toArray(new VsphereObjectAssetSpec[0]);
                Asset[] assets = AssetAvailabilityPropertyProvider.this._managementEditor.getAssetsByVsphereObjectRefs(vsphereObjectAssetSpec, scope);
                ArrayList<Boolean> result = new ArrayList<Boolean>(assets.length);
                for (Asset asset : assets) {
                    boolean isSubscription = asset != null && asset.getLicense() != null && asset.getLicense().isSubscription();
                    result.add(!isSubscription);
                }
                return result;
            }
        };
    }
}

